/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.sort.SortController;
import org.jdesktop.swingx.table.TableColumnExt;

public class JXTableHeader
extends JTableHeader
implements TableColumnModelExtListener {
    private static final Logger LOG = Logger.getLogger(JXTableHeader.class.getName());
    @Deprecated
    private SortGestureRecognizer sortGestureRecognizer;
    private MouseInputListener headerListener;

    public JXTableHeader() {
    }

    public JXTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
    }

    public void setTable(JTable jTable) {
        super.setTable(jTable);
        if (this.getXTable() != null) {
            this.installHeaderListener();
        } else {
            this.uninstallHeaderListener();
        }
    }

    public void columnPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.isColumnEvent(propertyChangeEvent)) {
            return;
        }
        this.resizeAndRepaint();
    }

    protected boolean isColumnEvent(PropertyChangeEvent propertyChangeEvent) {
        return "width".equals(propertyChangeEvent.getPropertyName()) || "preferredWidth".equals(propertyChangeEvent.getPropertyName()) || "visible".equals(propertyChangeEvent.getPropertyName());
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = this.getColumnToolTipText(mouseEvent);
        return string != null ? string : super.getToolTipText(mouseEvent);
    }

    protected String getColumnToolTipText(MouseEvent mouseEvent) {
        if (this.getXTable() == null) {
            return null;
        }
        int n = this.columnAtPoint(mouseEvent.getPoint());
        if (n < 0) {
            return null;
        }
        TableColumnExt tableColumnExt = this.getXTable().getColumnExt(n);
        return tableColumnExt != null ? tableColumnExt.getToolTipText() : null;
    }

    public JXTable getXTable() {
        if (!(this.getTable() instanceof JXTable)) {
            return null;
        }
        return (JXTable)this.getTable();
    }

    public TableCellRenderer getCellRenderer(int n) {
        TableCellRenderer tableCellRenderer = this.getColumnModel().getColumn(n).getHeaderRenderer();
        return tableCellRenderer != null ? tableCellRenderer : this.getDefaultRenderer();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension = this.getPreferredSize(dimension);
        dimension.height = this.getMinimumHeight(dimension.height);
        return dimension;
    }

    protected Dimension getPreferredSize(Dimension dimension) {
        int n = dimension.height;
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableCellRenderer tableCellRenderer = this.getCellRenderer(i);
            Component component = tableCellRenderer.getTableCellRendererComponent(this.table, this.getColumnModel().getColumn(i).getHeaderValue(), false, false, -1, i);
            n = Math.max(n, component.getPreferredSize().height);
        }
        dimension.height = n;
        return dimension;
    }

    protected int getMinimumHeight(int n) {
        if (n == 0) {
            TableCellRenderer tableCellRenderer = this.getDefaultRenderer();
            Component component = tableCellRenderer.getTableCellRendererComponent(this.getTable(), "dummy", false, false, -1, -1);
            n = component.getPreferredSize().height;
        }
        return n;
    }

    public void setDraggedDistance(int n) {
        int n2 = this.getDraggedDistance();
        super.setDraggedDistance(n);
        this.firePropertyChange("draggedDistance", n2, this.getDraggedDistance());
        if (!this.getAutoscrolls() || this.getXTable() == null) {
            return;
        }
        TableColumn tableColumn = this.getDraggedColumn();
        if (tableColumn != null) {
            this.getXTable().scrollColumnToVisible(this.getViewIndexForColumn(tableColumn));
        }
    }

    public TableColumn getDraggedColumn() {
        return this.isVisible(this.draggedColumn) ? this.draggedColumn : null;
    }

    private boolean isVisible(TableColumn tableColumn) {
        return this.getViewIndexForColumn(tableColumn) >= 0;
    }

    private int getViewIndexForColumn(TableColumn tableColumn) {
        if (tableColumn == null) {
            return -1;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    protected void installHeaderListener() {
        if (this.headerListener == null) {
            this.headerListener = new HeaderListener();
            this.addMouseListener(this.headerListener);
            this.addMouseMotionListener(this.headerListener);
        }
    }

    protected void uninstallHeaderListener() {
        if (this.headerListener != null) {
            this.removeMouseListener(this.headerListener);
            this.removeMouseMotionListener(this.headerListener);
            this.headerListener = null;
        }
    }

    @Deprecated
    public SortGestureRecognizer getSortGestureRecognizer() {
        if (this.sortGestureRecognizer == null) {
            this.sortGestureRecognizer = this.createSortGestureRecognizer();
        }
        return this.sortGestureRecognizer;
    }

    @Deprecated
    public void setSortGestureRecognizer(SortGestureRecognizer sortGestureRecognizer) {
        SortGestureRecognizer sortGestureRecognizer2 = this.getSortGestureRecognizer();
        this.sortGestureRecognizer = sortGestureRecognizer;
        this.firePropertyChange("sortGestureRecognizer", sortGestureRecognizer2, this.getSortGestureRecognizer());
    }

    @Deprecated
    protected SortGestureRecognizer createSortGestureRecognizer() {
        return new SortGestureRecognizer();
    }

    @Deprecated
    public static class SortGestureRecognizer {
        public boolean isResetSortOrderGesture(MouseEvent mouseEvent) {
            return this.isSortOrderGesture(mouseEvent) && this.isResetModifier(mouseEvent);
        }

        public boolean isToggleSortOrderGesture(MouseEvent mouseEvent) {
            return this.isSortOrderGesture(mouseEvent) && !this.isResetModifier(mouseEvent);
        }

        public boolean isSortOrderGesture(MouseEvent mouseEvent) {
            return mouseEvent.getClickCount() == 1;
        }

        protected boolean isResetModifier(MouseEvent mouseEvent) {
            return (mouseEvent.getModifiersEx() & 0x40) == 64;
        }
    }

    private class HeaderListener
    implements MouseInputListener,
    Serializable {
        private TableColumn cachedResizingColumn;
        private SortOrder[] cachedSortOrderCycle;

        private HeaderListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            this.doResize(mouseEvent);
            this.uncacheResizingColumn();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.resetToggleSortOrder(mouseEvent);
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            this.cacheResizingColumn(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            this.cacheResizingColumn(mouseEvent);
            if (this.isInResizeRegion(mouseEvent) && mouseEvent.getClickCount() % 2 == 1) {
                this.disableToggleSortOrder(mouseEvent);
            }
        }

        private boolean shouldIgnore(MouseEvent mouseEvent) {
            return !SwingUtilities.isLeftMouseButton(mouseEvent) || !JXTableHeader.this.table.isEnabled();
        }

        private void doResize(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() != 2) {
                return;
            }
            int n = JXTableHeader.this.getViewIndexForColumn(this.cachedResizingColumn);
            if (n >= 0) {
                JXTableHeader.this.getXTable().packColumn(n, 5);
            }
        }

        private void disableToggleSortOrder(MouseEvent mouseEvent) {
            SortController sortController = JXTableHeader.this.getXTable().getSortController();
            if (sortController == null) {
                return;
            }
            this.cachedSortOrderCycle = sortController.getSortOrderCycle();
            sortController.setSortOrderCycle(new SortOrder[0]);
        }

        private void resetToggleSortOrder(MouseEvent mouseEvent) {
            if (this.cachedSortOrderCycle == null) {
                return;
            }
            JXTableHeader.this.getXTable().getSortController().setSortOrderCycle(this.cachedSortOrderCycle);
            this.cachedSortOrderCycle = null;
        }

        private void cacheResizingColumn(MouseEvent mouseEvent) {
            TableColumn tableColumn = JXTableHeader.this.getResizingColumn();
            if (tableColumn != null) {
                this.cachedResizingColumn = tableColumn;
            }
        }

        private void uncacheResizingColumn() {
            this.cachedResizingColumn = null;
        }

        private boolean isInResizeRegion(MouseEvent mouseEvent) {
            return this.cachedResizingColumn != null;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.uncacheResizingColumn();
            this.resetToggleSortOrder(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.uncacheResizingColumn();
            this.resetToggleSortOrder(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.resetToggleSortOrder(mouseEvent);
        }
    }
}

