/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellEditor;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.UIDependent;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.rollover.RolloverProducer;
import org.jdesktop.swingx.rollover.RolloverRenderer;
import org.jdesktop.swingx.rollover.TreeRolloverController;
import org.jdesktop.swingx.rollover.TreeRolloverProducer;
import org.jdesktop.swingx.search.SearchFactory;
import org.jdesktop.swingx.search.Searchable;
import org.jdesktop.swingx.search.TreeSearchable;
import org.jdesktop.swingx.tree.DefaultXTreeCellEditor;
import org.jdesktop.swingx.tree.DefaultXTreeCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXTree
extends JTree {
    private static final Logger LOG = Logger.getLogger(JXTree.class.getName());
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final TreePath[] EMPTY_TREEPATH_ARRAY = new TreePath[0];
    protected CompoundHighlighter compoundHighlighter;
    private ChangeListener highlighterChangeListener;
    private DelegatingRenderer delegatingRenderer;
    private RolloverProducer rolloverProducer;
    private TreeRolloverController<JXTree> linkController;
    private boolean overwriteIcons;
    private Searchable searchable;
    private CellEditorRemover editorRemover;
    private CellEditorListener editorListener;
    private Color selectionForeground;
    private Color selectionBackground;
    protected ComponentAdapter dataAdapter;

    public JXTree() {
        this.init();
    }

    public JXTree(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    public JXTree(Vector vector) {
        super(vector);
        this.init();
    }

    public JXTree(Hashtable hashtable) {
        super(hashtable);
        this.init();
    }

    public JXTree(TreeNode treeNode) {
        super(treeNode, false);
        this.init();
    }

    public JXTree(TreeNode treeNode, boolean bl) {
        super(treeNode, bl);
        this.init();
    }

    public JXTree(TreeModel treeModel) {
        super(treeModel);
        this.init();
    }

    private void init() {
        this.setCellRenderer(this.createDefaultCellRenderer());
        if (this.getWrappedCellRenderer() instanceof DefaultTreeCellRenderer) {
            this.setCellEditor(new DefaultXTreeCellEditor(this, (DefaultTreeCellRenderer)this.getWrappedCellRenderer()));
        }
        ActionMap actionMap = this.getActionMap();
        actionMap.put("expand-all", new Actions("expand-all"));
        actionMap.put("collapse-all", new Actions("collapse-all"));
        actionMap.put("find", this.createFindAction());
        KeyStroke keyStroke = SearchFactory.getInstance().getSearchAccelerator();
        this.getInputMap(1).put(keyStroke, "find");
    }

    @Override
    protected TreeModelListener createTreeModelListener() {
        return new XTreeModelHandler();
    }

    private Action createFindAction() {
        return new UIAction("find"){

            public void actionPerformed(ActionEvent actionEvent) {
                JXTree.this.doFind();
            }
        };
    }

    protected void doFind() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new TreeSearchable(this);
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    public String getStringAt(int n) {
        return this.getStringAt(this.getPathForRow(n));
    }

    public String getStringAt(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        TreeCellRenderer treeCellRenderer = this.getDelegatingRenderer().getDelegateRenderer();
        if (treeCellRenderer instanceof StringValue) {
            return ((StringValue)((Object)treeCellRenderer)).getString(treePath.getLastPathComponent());
        }
        return StringValues.TO_STRING.getString(treePath.getLastPathComponent());
    }

    public void collapseAll() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.collapseRow(i);
        }
    }

    public void expandAll() {
        if (this.getRowCount() == 0) {
            this.expandRoot();
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    private void expandRoot() {
        TreeModel treeModel = this.getModel();
        if (treeModel != null && treeModel.getRoot() != null) {
            this.expandPath(new TreePath(treeModel.getRoot()));
        }
    }

    @Override
    public int[] getSelectionRows() {
        int[] nArray = super.getSelectionRows();
        return nArray != null ? nArray : EMPTY_INT_ARRAY;
    }

    @Override
    public TreePath[] getSelectionPaths() {
        TreePath[] treePathArray = super.getSelectionPaths();
        return treePathArray != null ? treePathArray : EMPTY_TREEPATH_ARRAY;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.getSelectionForeground();
        this.selectionForeground = color;
        this.firePropertyChange("selectionForeground", color2, this.getSelectionForeground());
        this.repaint();
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.getSelectionBackground();
        this.selectionBackground = color;
        this.firePropertyChange("selectionBackground", color2, this.getSelectionBackground());
        this.repaint();
    }

    @Override
    public void updateUI() {
        this.uninstallSelectionColors();
        super.updateUI();
        this.installSelectionColors();
        this.updateHighlighterUI();
        this.updateRendererEditorUI();
    }

    protected void updateRendererEditorUI() {
        if (this.getCellEditor() instanceof UIDependent) {
            ((UIDependent)((Object)this.getCellEditor())).updateUI();
        }
    }

    private void installSelectionColors() {
        if (SwingXUtilities.isUIInstallable(this.getSelectionBackground())) {
            this.setSelectionBackground(UIManager.getColor("Tree.selectionBackground"));
        }
        if (SwingXUtilities.isUIInstallable(this.getSelectionForeground())) {
            this.setSelectionForeground(UIManager.getColor("Tree.selectionForeground"));
        }
    }

    private void uninstallSelectionColors() {
        if (SwingXUtilities.isUIInstallable(this.getSelectionBackground())) {
            this.setSelectionBackground(null);
        }
        if (SwingXUtilities.isUIInstallable(this.getSelectionForeground())) {
            this.setSelectionForeground(null);
        }
    }

    protected void updateHighlighterUI() {
        if (this.compoundHighlighter == null) {
            return;
        }
        this.compoundHighlighter.updateUI();
    }

    public void setRolloverEnabled(boolean bl) {
        boolean bl2 = this.isRolloverEnabled();
        if (bl == bl2) {
            return;
        }
        if (bl) {
            this.rolloverProducer = this.createRolloverProducer();
            this.addMouseListener(this.rolloverProducer);
            this.addMouseMotionListener(this.rolloverProducer);
            this.getLinkController().install(this);
        } else {
            this.removeMouseListener(this.rolloverProducer);
            this.removeMouseMotionListener(this.rolloverProducer);
            this.rolloverProducer = null;
            this.getLinkController().release();
        }
        this.firePropertyChange("rolloverEnabled", bl2, this.isRolloverEnabled());
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    protected TreeRolloverController<JXTree> getLinkController() {
        if (this.linkController == null) {
            this.linkController = this.createLinkController();
        }
        return this.linkController;
    }

    protected TreeRolloverController<JXTree> createLinkController() {
        return new TreeRolloverController<JXTree>();
    }

    protected RolloverProducer createRolloverProducer() {
        return new TreeRolloverProducer();
    }

    public void setHighlighters(Highlighter ... highlighterArray) {
        Highlighter[] highlighterArray2 = this.getHighlighters();
        this.getCompoundHighlighter().setHighlighters(highlighterArray);
        this.firePropertyChange("highlighters", highlighterArray2, this.getHighlighters());
    }

    public Highlighter[] getHighlighters() {
        return this.getCompoundHighlighter().getHighlighters();
    }

    public void addHighlighter(Highlighter highlighter) {
        Highlighter[] highlighterArray = this.getHighlighters();
        this.getCompoundHighlighter().addHighlighter(highlighter);
        this.firePropertyChange("highlighters", highlighterArray, this.getHighlighters());
    }

    public void removeHighlighter(Highlighter highlighter) {
        Highlighter[] highlighterArray = this.getHighlighters();
        this.getCompoundHighlighter().removeHighlighter(highlighter);
        this.firePropertyChange("highlighters", highlighterArray, this.getHighlighters());
    }

    protected CompoundHighlighter getCompoundHighlighter() {
        if (this.compoundHighlighter == null) {
            this.compoundHighlighter = new CompoundHighlighter(new Highlighter[0]);
            this.compoundHighlighter.addChangeListener(this.getHighlighterChangeListener());
        }
        return this.compoundHighlighter;
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = this.createHighlighterChangeListener();
        }
        return this.highlighterChangeListener;
    }

    protected ChangeListener createHighlighterChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JXTree.this.repaint();
            }
        };
    }

    public void setExpandedIcon(Icon icon) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setExpandedIcon(icon);
        }
    }

    public void setCollapsedIcon(Icon icon) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setCollapsedIcon(icon);
        }
    }

    public void setLeafIcon(Icon icon) {
        this.getDelegatingRenderer().setLeafIcon(icon);
    }

    public void setOpenIcon(Icon icon) {
        this.getDelegatingRenderer().setOpenIcon(icon);
    }

    public void setClosedIcon(Icon icon) {
        this.getDelegatingRenderer().setClosedIcon(icon);
    }

    public void setOverwriteRendererIcons(boolean bl) {
        if (this.overwriteIcons == bl) {
            return;
        }
        boolean bl2 = this.overwriteIcons;
        this.overwriteIcons = bl;
        this.firePropertyChange("overwriteRendererIcons", bl2, bl);
    }

    public boolean isOverwriteRendererIcons() {
        return this.overwriteIcons;
    }

    private DelegatingRenderer getDelegatingRenderer() {
        if (this.delegatingRenderer == null) {
            this.delegatingRenderer = new DelegatingRenderer();
        }
        return this.delegatingRenderer;
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultXTreeCellRenderer();
    }

    @Override
    public TreeCellRenderer getCellRenderer() {
        return this.getDelegatingRenderer();
    }

    public TreeCellRenderer getWrappedCellRenderer() {
        return this.getDelegatingRenderer().getDelegateRenderer();
    }

    @Override
    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.getDelegatingRenderer().setDelegateRenderer(treeCellRenderer);
        super.setCellRenderer(this.delegatingRenderer);
        if (treeCellRenderer instanceof DefaultTreeCellRenderer && this.getCellEditor() instanceof DefaultXTreeCellEditor) {
            ((DefaultXTreeCellEditor)this.getCellEditor()).setRenderer((DefaultTreeCellRenderer)treeCellRenderer);
        }
    }

    @Override
    public void startEditingAtPath(TreePath treePath) {
        super.startEditingAtPath(treePath);
        if (this.isEditing()) {
            this.updateEditorListener();
            this.updateEditorRemover();
        }
    }

    private void updateEditorListener() {
        if (this.editorListener == null) {
            this.editorListener = new CellEditorListener(){

                public void editingCanceled(ChangeEvent changeEvent) {
                    this.terminated(changeEvent);
                }

                private void terminated(ChangeEvent changeEvent) {
                    JXTree.this.analyseFocus();
                    ((CellEditor)changeEvent.getSource()).removeCellEditorListener(JXTree.this.editorListener);
                }

                public void editingStopped(ChangeEvent changeEvent) {
                    this.terminated(changeEvent);
                }
            };
        }
        this.getCellEditor().addCellEditorListener(this.editorListener);
    }

    protected void analyseFocus() {
        if (this.isFocusOwnerDescending()) {
            this.requestFocusInWindow();
        }
    }

    private boolean isFocusOwnerDescending() {
        if (!this.isEditing()) {
            return false;
        }
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == null) {
            return false;
        }
        if (SwingXUtilities.isDescendingFrom(component, this)) {
            return true;
        }
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        return SwingXUtilities.isDescendingFrom(component2, this);
    }

    @Override
    public void removeNotify() {
        if (this.editorRemover != null) {
            this.editorRemover.release();
            this.editorRemover = null;
        }
        super.removeNotify();
    }

    private void updateEditorRemover() {
        if (this.editorRemover == null) {
            this.editorRemover = new CellEditorRemover();
        }
        this.editorRemover.updateKeyboardFocusManager();
    }

    @Override
    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TreeAdapter(this);
        }
        return this.dataAdapter;
    }

    protected ComponentAdapter getComponentAdapter(int n) {
        ComponentAdapter componentAdapter = this.getComponentAdapter();
        componentAdapter.column = 0;
        componentAdapter.row = n;
        return componentAdapter;
    }

    protected static class TreeAdapter
    extends ComponentAdapter {
        private final JXTree tree;

        public TreeAdapter(JXTree jXTree) {
            super(jXTree);
            this.tree = jXTree;
        }

        public JXTree getTree() {
            return this.tree;
        }

        public boolean hasFocus() {
            return this.tree.isFocusOwner() && this.tree.getLeadSelectionRow() == this.row;
        }

        public Object getValueAt(int n, int n2) {
            TreePath treePath = this.tree.getPathForRow(n);
            return treePath.getLastPathComponent();
        }

        public Object getFilteredValueAt(int n, int n2) {
            return this.getValueAt(n, n2);
        }

        public Object getValue() {
            return this.getValueAt(this.row, this.column);
        }

        public String getFilteredStringAt(int n, int n2) {
            return this.tree.getStringAt(n);
        }

        public String getString() {
            return this.tree.getStringAt(this.row);
        }

        public String getStringAt(int n, int n2) {
            return this.tree.getStringAt(n);
        }

        public boolean isEditable() {
            return this.tree.isPathEditable(this.tree.getPathForRow(this.row));
        }

        public boolean isSelected() {
            return this.tree.isRowSelected(this.row);
        }

        public boolean isExpanded() {
            return this.tree.isExpanded(this.row);
        }

        public int getDepth() {
            return this.tree.getPathForRow(this.row).getPathCount() - 1;
        }

        public boolean isHierarchical() {
            return true;
        }

        public boolean isLeaf() {
            return this.tree.getModel().isLeaf(this.getValue());
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    public class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover() {
            this.updateKeyboardFocusManager();
        }

        public void updateKeyboardFocusManager() {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.setKeyboardFocusManager(keyboardFocusManager);
        }

        public void release() {
            this.setKeyboardFocusManager(null);
        }

        private void setKeyboardFocusManager(KeyboardFocusManager keyboardFocusManager) {
            if (this.focusManager == keyboardFocusManager) {
                return;
            }
            KeyboardFocusManager keyboardFocusManager2 = this.focusManager;
            if (keyboardFocusManager2 != null) {
                keyboardFocusManager2.removePropertyChangeListener("permanentFocusOwner", this);
            }
            this.focusManager = keyboardFocusManager;
            if (this.focusManager != null) {
                this.focusManager.addPropertyChangeListener("permanentFocusOwner", this);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!JXTree.this.isEditing()) {
                return;
            }
            Component component = this.focusManager.getPermanentFocusOwner();
            JXTree jXTree = JXTree.this;
            while (component != null) {
                if (component instanceof JPopupMenu) {
                    component = ((JPopupMenu)component).getInvoker();
                    continue;
                }
                if (component == jXTree) {
                    return;
                }
                if (component instanceof Window || component instanceof Applet && component.getParent() == null) {
                    if (component != SwingUtilities.getRoot(jXTree)) break;
                    if (jXTree.getInvokesStopCellEditing()) {
                        jXTree.stopEditing();
                    }
                    if (!jXTree.isEditing()) break;
                    jXTree.cancelEditing();
                    break;
                }
                component = component.getParent();
            }
        }
    }

    public class DelegatingRenderer
    implements TreeCellRenderer,
    RolloverRenderer {
        private Icon closedIcon = null;
        private Icon openIcon = null;
        private Icon leafIcon = null;
        private TreeCellRenderer delegate;

        public DelegatingRenderer() {
            this(null);
            this.initIcons(new DefaultTreeCellRenderer());
        }

        public DelegatingRenderer(TreeCellRenderer treeCellRenderer) {
            this.initIcons((DefaultTreeCellRenderer)(treeCellRenderer instanceof DefaultTreeCellRenderer ? treeCellRenderer : new DefaultTreeCellRenderer()));
            this.setDelegateRenderer(treeCellRenderer);
        }

        private void initIcons(DefaultTreeCellRenderer defaultTreeCellRenderer) {
            this.closedIcon = defaultTreeCellRenderer.getDefaultClosedIcon();
            this.openIcon = defaultTreeCellRenderer.getDefaultOpenIcon();
            this.leafIcon = defaultTreeCellRenderer.getDefaultLeafIcon();
        }

        public void setDelegateRenderer(TreeCellRenderer treeCellRenderer) {
            if (treeCellRenderer == null) {
                treeCellRenderer = JXTree.this.createDefaultCellRenderer();
            }
            this.delegate = treeCellRenderer;
            this.updateIcons();
        }

        private void updateIcons() {
            if (!JXTree.this.isOverwriteRendererIcons()) {
                return;
            }
            this.setClosedIcon(this.closedIcon);
            this.setOpenIcon(this.openIcon);
            this.setLeafIcon(this.leafIcon);
        }

        public void setClosedIcon(Icon icon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setClosedIcon(icon);
            }
            this.closedIcon = icon;
        }

        public void setOpenIcon(Icon icon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setOpenIcon(icon);
            }
            this.openIcon = icon;
        }

        public void setLeafIcon(Icon icon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setLeafIcon(icon);
            }
            this.leafIcon = icon;
        }

        public TreeCellRenderer getDelegateRenderer() {
            return this.delegate;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = this.delegate.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (JXTree.this.compoundHighlighter != null && n < JXTree.this.getRowCount() && n >= 0) {
                component = JXTree.this.compoundHighlighter.highlight(component, JXTree.this.getComponentAdapter(n));
            }
            return component;
        }

        public boolean isEnabled() {
            return this.delegate instanceof RolloverRenderer && ((RolloverRenderer)((Object)this.delegate)).isEnabled();
        }

        public void doClick() {
            if (this.isEnabled()) {
                ((RolloverRenderer)((Object)this.delegate)).doClick();
            }
        }
    }

    private class Actions
    extends UIAction {
        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("expand-all".equals(this.getName())) {
                JXTree.this.expandAll();
            } else if ("collapse-all".equals(this.getName())) {
                JXTree.this.collapseAll();
            }
        }
    }

    protected class XTreeModelHandler
    extends JTree.TreeModelHandler {
        protected XTreeModelHandler() {
            super(JXTree.this);
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath.getParentPath() == null && !JXTree.this.isRootVisible() && JXTree.this.isCollapsed(treePath)) {
                JXTree.this.expandPath(treePath);
            }
            super.treeNodesInserted(treeModelEvent);
        }
    }
}

