/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionManager;
import org.jdesktop.swingx.action.ToggleActionPropertyChangeListener;

public class ActionContainerFactory {
    private static Insets TOOLBAR_BUTTON_MARGIN = new Insets(1, 1, 1, 1);
    private ActionManager manager;
    private Map groupMap;

    public ActionContainerFactory() {
    }

    public ActionContainerFactory(ActionManager actionManager) {
        this.setActionManager(actionManager);
    }

    public ActionManager getActionManager() {
        if (this.manager == null) {
            this.manager = ActionManager.getInstance();
        }
        return this.manager;
    }

    public void setActionManager(ActionManager actionManager) {
        this.manager = actionManager;
    }

    public JToolBar createToolBar(Object[] objectArray) {
        return this.createToolBar(Arrays.asList(objectArray));
    }

    public JToolBar createToolBar(List list) {
        JToolBar jToolBar = new JToolBar();
        for (Object e : list) {
            if (e == null) {
                jToolBar.addSeparator();
                continue;
            }
            AbstractButton abstractButton = this.createButton(e, (JComponent)jToolBar);
            abstractButton.setFocusable(false);
            abstractButton.setMargin(TOOLBAR_BUTTON_MARGIN);
            abstractButton.setBorderPainted(false);
            jToolBar.add(abstractButton);
        }
        return jToolBar;
    }

    public JPopupMenu createPopup(Object[] objectArray) {
        return this.createPopup(Arrays.asList(objectArray));
    }

    public JPopupMenu createPopup(List list) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (Object e : list) {
            if (e == null) {
                jPopupMenu.addSeparator();
                continue;
            }
            if (e instanceof List) {
                JMenu jMenu = this.createMenu((List)e);
                if (jMenu == null) continue;
                jPopupMenu.add(jMenu);
                continue;
            }
            jPopupMenu.add(this.createMenuItem(e, (JComponent)jPopupMenu));
        }
        return jPopupMenu;
    }

    public JMenuBar createMenuBar(Object[] objectArray) {
        return this.createMenuBar(Arrays.asList(objectArray));
    }

    public JMenuBar createMenuBar(List list) {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        for (Object e : list) {
            if (e == null) {
                if (jMenu == null) continue;
                jMenu.addSeparator();
                continue;
            }
            if (e instanceof List) {
                jMenu = this.createMenu((List)e);
                if (jMenu == null) continue;
                jMenuBar.add(jMenu);
                continue;
            }
            if (jMenu == null) continue;
            jMenu.add(this.createMenuItem(e, (JComponent)jMenu));
        }
        return jMenuBar;
    }

    public JMenu createMenu(Object[] objectArray) {
        return this.createMenu(Arrays.asList(objectArray));
    }

    public JMenu createMenu(List list) {
        Action action = this.getAction(list.get(0));
        if (action == null) {
            return null;
        }
        JMenu jMenu = new JMenu(action);
        ListIterator listIterator = list.listIterator(1);
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (e == null) {
                jMenu.addSeparator();
                continue;
            }
            if (e instanceof List) {
                JMenu jMenu2 = this.createMenu((List)e);
                if (jMenu2 == null) continue;
                jMenu.add(jMenu2);
                continue;
            }
            jMenu.add(this.createMenuItem(e, (JComponent)jMenu));
        }
        return jMenu;
    }

    private Action getAction(Object object) {
        Action action = this.getActionManager().getAction(object);
        if (action == null) {
            throw new RuntimeException("ERROR: No Action for " + object);
        }
        return action;
    }

    private ButtonGroup getGroup(String string, JComponent jComponent) {
        Integer n;
        ButtonGroup buttonGroup;
        if (this.groupMap == null) {
            this.groupMap = new HashMap();
        }
        int n2 = string.hashCode();
        if (jComponent != null) {
            n2 ^= jComponent.hashCode();
        }
        if ((buttonGroup = (ButtonGroup)this.groupMap.get(n = new Integer(n2))) == null) {
            buttonGroup = new ButtonGroup();
            this.groupMap.put(n, buttonGroup);
        }
        return buttonGroup;
    }

    private JMenuItem createMenuItem(Object object, JComponent jComponent) {
        return this.createMenuItem(this.getAction(object), jComponent);
    }

    public JMenuItem createMenuItem(Action action, JComponent jComponent) {
        AbstractActionExt abstractActionExt;
        JMenuItem jMenuItem = null;
        if (action instanceof AbstractActionExt && (abstractActionExt = (AbstractActionExt)action).isStateAction()) {
            String string = (String)abstractActionExt.getGroup();
            jMenuItem = string != null ? this.createRadioButtonMenuItem(this.getGroup(string, jComponent), (AbstractActionExt)action) : this.createCheckBoxMenuItem((AbstractActionExt)action);
        }
        if (jMenuItem == null) {
            jMenuItem = new JMenuItem(action);
            this.configureMenuItemFromExtActionProperties(jMenuItem, action);
        }
        return jMenuItem;
    }

    public JMenuItem createMenuItem(Action action) {
        return this.createMenuItem(action, null);
    }

    public AbstractButton createButton(Object object, JComponent jComponent) {
        return this.createButton(this.getAction(object), jComponent);
    }

    public AbstractButton createButton(Action action, JComponent jComponent) {
        AbstractActionExt abstractActionExt;
        if (action == null) {
            return null;
        }
        AbstractButton abstractButton = null;
        if (action instanceof AbstractActionExt && (abstractActionExt = (AbstractActionExt)action).isStateAction()) {
            String string = (String)abstractActionExt.getGroup();
            abstractButton = string == null ? this.createToggleButton(abstractActionExt) : this.createToggleButton(abstractActionExt, this.getGroup(string, jComponent));
        }
        if (abstractButton == null) {
            abstractButton = new JButton(action);
            this.configureButtonFromExtActionProperties(abstractButton, action);
        }
        return abstractButton;
    }

    public AbstractButton createButton(Action action) {
        return this.createButton(action, null);
    }

    private JToggleButton createToggleButton(AbstractActionExt abstractActionExt) {
        return this.createToggleButton(abstractActionExt, null);
    }

    private JToggleButton createToggleButton(AbstractActionExt abstractActionExt, ButtonGroup buttonGroup) {
        JToggleButton jToggleButton = new JToggleButton();
        this.configureButton(jToggleButton, abstractActionExt, buttonGroup);
        return jToggleButton;
    }

    public void configureButton(JToggleButton jToggleButton, AbstractActionExt abstractActionExt, ButtonGroup buttonGroup) {
        this.configureSelectableButton(jToggleButton, abstractActionExt, buttonGroup);
        this.configureButtonFromExtActionProperties(jToggleButton, abstractActionExt);
    }

    public void configureSelectableButton(AbstractButton abstractButton, AbstractActionExt abstractActionExt, ButtonGroup buttonGroup) {
        if (abstractActionExt != null && !abstractActionExt.isStateAction()) {
            throw new IllegalArgumentException("the Action must be a stateAction");
        }
        if (abstractButton.getAction() == abstractActionExt) {
            return;
        }
        Action action = abstractButton.getAction();
        if (action instanceof AbstractActionExt) {
            AbstractActionExt abstractActionExt2 = (AbstractActionExt)action;
            abstractButton.removeItemListener(abstractActionExt2);
            PropertyChangeListener[] propertyChangeListenerArray = abstractActionExt2.getPropertyChangeListeners();
            for (int i = propertyChangeListenerArray.length - 1; i >= 0; --i) {
                ToggleActionPropertyChangeListener toggleActionPropertyChangeListener;
                if (!(propertyChangeListenerArray[i] instanceof ToggleActionPropertyChangeListener) || !(toggleActionPropertyChangeListener = (ToggleActionPropertyChangeListener)propertyChangeListenerArray[i]).isToggling(abstractButton)) continue;
                abstractActionExt2.removePropertyChangeListener(toggleActionPropertyChangeListener);
            }
        }
        abstractButton.setAction(abstractActionExt);
        if (buttonGroup != null) {
            buttonGroup.add(abstractButton);
        }
        if (abstractActionExt != null) {
            abstractButton.addItemListener(abstractActionExt);
            abstractButton.setSelected(abstractActionExt.isSelected());
            new ToggleActionPropertyChangeListener(abstractActionExt, abstractButton);
        }
    }

    protected void configureButtonFromExtActionProperties(AbstractButton abstractButton, Action action) {
        if (action.getValue("ShortDescription") == null) {
            abstractButton.setToolTipText((String)action.getValue("Name"));
        }
        if (action.getValue("__LargeIcon__") != null) {
            abstractButton.setIcon((Icon)action.getValue("__LargeIcon__"));
        }
        if (abstractButton.getIcon() != null) {
            abstractButton.setText("");
        }
    }

    protected void configureMenuItemFromExtActionProperties(JMenuItem jMenuItem, Action action) {
    }

    private JCheckBoxMenuItem createCheckBoxMenuItem(AbstractActionExt abstractActionExt) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.configureSelectableButton(jCheckBoxMenuItem, abstractActionExt, null);
        this.configureMenuItemFromExtActionProperties(jCheckBoxMenuItem, abstractActionExt);
        return jCheckBoxMenuItem;
    }

    private JRadioButtonMenuItem createRadioButtonMenuItem(ButtonGroup buttonGroup, AbstractActionExt abstractActionExt) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.configureSelectableButton(jRadioButtonMenuItem, abstractActionExt, buttonGroup);
        this.configureMenuItemFromExtActionProperties(jRadioButtonMenuItem, abstractActionExt);
        return jRadioButtonMenuItem;
    }
}

