/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.util.prefs.Preferences;
import org.jdesktop.swingx.auth.UserNameStore;

public class DefaultUserNameStore
extends UserNameStore {
    private Preferences prefs;
    private String[] userNames = new String[0];

    public void loadUserNames() {
        this.initPrefs();
        if (this.prefs != null) {
            int n = this.prefs.getInt("usernames.length", 0);
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.prefs.get("usernames." + i, null);
            }
            this.setUserNames(stringArray);
        }
    }

    public void saveUserNames() {
        this.initPrefs();
        if (this.prefs != null) {
            this.prefs.putInt("usernames.length", this.userNames.length);
            for (int i = 0; i < this.userNames.length; ++i) {
                this.prefs.put("usernames." + i, this.userNames[i]);
            }
        }
    }

    public String[] getUserNames() {
        String[] stringArray = new String[this.userNames.length];
        System.arraycopy(this.userNames, 0, stringArray, 0, this.userNames.length);
        return stringArray;
    }

    public void setUserNames(String[] stringArray) {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        String[] stringArray2 = this.getUserNames();
        this.userNames = stringArray;
        this.firePropertyChange("userNames", stringArray2, this.getUserNames());
    }

    public void addUserName(String string) {
        if (!this.containsUserName(string)) {
            String[] stringArray = new String[this.userNames.length + 1];
            for (int i = 0; i < this.userNames.length; ++i) {
                stringArray[i] = this.userNames[i];
            }
            stringArray[stringArray.length - 1] = string;
            this.setUserNames(stringArray);
        }
    }

    public void removeUserName(String string) {
        if (this.containsUserName(string)) {
            String[] stringArray = new String[this.userNames.length - 1];
            int n = 0;
            for (String string2 : this.userNames) {
                if (string2.equals(string)) continue;
                stringArray[n++] = string2;
            }
            this.setUserNames(stringArray);
        }
    }

    public boolean containsUserName(String string) {
        for (String string2 : this.userNames) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    public void setPreferences(Preferences preferences) {
        Preferences preferences2 = this.getPreferences();
        this.initPrefs();
        this.prefs = preferences;
        this.firePropertyChange("preferences", preferences2, this.getPreferences());
        if (this.prefs != preferences2) {
            this.loadUserNames();
        }
    }

    private void initPrefs() {
        if (this.prefs == null) {
            this.prefs = Preferences.userNodeForPackage(DefaultUserNameStore.class);
            this.prefs = this.prefs.node("DefaultUserNameStore");
        }
    }
}

