/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jdesktop.swingx.auth.LoginService;

public class JAASLoginService
extends LoginService {
    private static final Logger LOG = Logger.getLogger(JAASLoginService.class.getName());
    protected LoginContext loginContext;

    public JAASLoginService(String string) {
        super(string);
    }

    public JAASLoginService() {
    }

    public boolean authenticate(String string, char[] cArray, String string2) throws Exception {
        if (string2 != null && !string2.equals(this.getServer())) {
            this.setServer(string2);
        }
        this.loginContext = null;
        try {
            this.loginContext = new LoginContext(this.getServer(), new JAASCallbackHandler(string, cArray));
            this.loginContext.login();
            return true;
        }
        catch (AccountExpiredException accountExpiredException) {
            LOG.log(Level.WARNING, "", accountExpiredException);
            return false;
        }
        catch (CredentialExpiredException credentialExpiredException) {
            LOG.log(Level.WARNING, "", credentialExpiredException);
            return false;
        }
        catch (FailedLoginException failedLoginException) {
            LOG.log(Level.WARNING, "", failedLoginException);
            return false;
        }
        catch (LoginException loginException) {
            LOG.log(Level.WARNING, "", loginException);
            return false;
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "", throwable);
            return false;
        }
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    public Subject getSubject() {
        if (this.loginContext == null) {
            return null;
        }
        return this.loginContext.getSubject();
    }

    class JAASCallbackHandler
    implements CallbackHandler {
        private String name;
        private char[] password;

        public JAASCallbackHandler(String string, char[] cArray) {
            this.name = string;
            this.password = cArray;
        }

        public void handle(Callback[] callbackArray) throws IOException {
            for (int i = 0; i < callbackArray.length; ++i) {
                Callback callback;
                if (callbackArray[i] instanceof NameCallback) {
                    callback = (NameCallback)callbackArray[i];
                    ((NameCallback)callback).setName(this.name);
                    continue;
                }
                if (!(callbackArray[i] instanceof PasswordCallback)) continue;
                callback = (PasswordCallback)callbackArray[i];
                ((PasswordCallback)callback).setPassword(this.password);
            }
        }
    }
}

