/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jdesktop.swingx.auth.LoginService;

public class JDBCLoginService
extends LoginService {
    private static final Logger LOG = Logger.getLogger(JDBCLoginService.class.getName());
    private Connection conn;
    private String jndiContext;
    private Properties properties;

    public JDBCLoginService(String string, String string2) {
        super(string2);
        try {
            Class.forName(string);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "The driver passed to the JDBCLoginService constructor could not be loaded. This may be due to the driver not being on the classpath", exception);
        }
        this.setUrl(string2);
    }

    public JDBCLoginService(String string, String string2, Properties properties) {
        super(string2);
        try {
            Class.forName(string);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "The driver passed to the JDBCLoginService constructor could not be loaded. This may be due to the driver not being on the classpath", exception);
        }
        this.setUrl(string2);
        this.setProperties(properties);
    }

    public JDBCLoginService(String string) {
        super(string);
        this.jndiContext = string;
    }

    public JDBCLoginService() {
    }

    public String getUrl() {
        return this.getServer();
    }

    public void setUrl(String string) {
        String string2 = this.getUrl();
        this.setServer(string);
        this.firePropertyChange("url", string2, this.getUrl());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        Properties properties2 = this.getProperties();
        this.properties = properties;
        this.firePropertyChange("properties", properties2, this.getProperties());
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void setConnection(Connection connection) {
        Connection connection2 = this.getConnection();
        this.conn = connection;
        this.firePropertyChange("connection", connection2, this.getConnection());
    }

    private void connectByJNDI(String string, char[] cArray) throws Exception {
        InitialContext initialContext = new InitialContext();
        DataSource dataSource = (DataSource)initialContext.lookup(this.jndiContext);
        this.conn = dataSource.getConnection(string, new String(cArray));
        this.conn.setTransactionIsolation(4);
    }

    private void connectByDriverManager(String string, char[] cArray) throws Exception {
        if (this.getProperties() != null) {
            try {
                this.conn = DriverManager.getConnection(this.getUrl(), this.getProperties());
                this.conn.setTransactionIsolation(4);
            }
            catch (Exception exception) {
                try {
                    this.conn = DriverManager.getConnection(this.getUrl(), string, new String(cArray));
                    this.conn.setTransactionIsolation(4);
                }
                catch (Exception exception2) {
                    this.conn = DriverManager.getConnection(this.getUrl());
                    this.conn.setTransactionIsolation(4);
                }
            }
        } else {
            try {
                this.conn = DriverManager.getConnection(this.getUrl(), string, new String(cArray));
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Connection with properties failed. Tryint to connect without.", exception);
                this.conn = DriverManager.getConnection(this.getUrl());
            }
        }
    }

    public boolean authenticate(String string, char[] cArray, String string2) throws Exception {
        if (this.jndiContext != null) {
            try {
                this.connectByJNDI(string, cArray);
            }
            catch (Exception exception) {
                try {
                    this.connectByDriverManager(string, cArray);
                }
                catch (Exception exception2) {
                    LOG.log(Level.WARNING, "Login failed", exception2);
                    return false;
                }
            }
        } else {
            try {
                this.connectByDriverManager(string, cArray);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "", exception);
                return false;
            }
        }
        return true;
    }
}

