/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class AutoCompleteComboBoxEditor
implements ComboBoxEditor {
    private final ComboBoxEditor wrapped;
    private final ObjectToStringConverter stringConverter;
    private Object oldItem;

    public AutoCompleteComboBoxEditor(ComboBoxEditor comboBoxEditor, ObjectToStringConverter objectToStringConverter) {
        this.wrapped = comboBoxEditor;
        this.stringConverter = objectToStringConverter;
    }

    public Component getEditorComponent() {
        return this.wrapped.getEditorComponent();
    }

    public void setItem(Object object) {
        this.oldItem = object;
        this.wrapped.setItem(this.stringConverter.getPreferredStringForItem(object));
    }

    public Object getItem() {
        Object object = this.wrapped.getItem();
        for (String string : this.stringConverter.getPossibleStringsForItem(this.oldItem)) {
            if (string == null || !string.equals(object)) continue;
            return this.oldItem;
        }
        return null;
    }

    public void selectAll() {
        this.wrapped.selectAll();
    }

    public void addActionListener(ActionListener actionListener) {
        this.wrapped.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.wrapped.removeActionListener(actionListener);
    }
}

