/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.DelegatingDocumentEvent;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.util.Contract;

public class AutoCompleteDocument
implements Document {
    boolean selecting = false;
    protected boolean strictMatching;
    AbstractAutoCompleteAdaptor adaptor;
    ObjectToStringConverter stringConverter;
    private final Handler handler;
    protected final Document delegate;

    public AutoCompleteDocument(AbstractAutoCompleteAdaptor abstractAutoCompleteAdaptor, boolean bl, ObjectToStringConverter objectToStringConverter, Document document) {
        this.adaptor = Contract.asNotNull(abstractAutoCompleteAdaptor, "adaptor cannot be null");
        this.strictMatching = bl;
        this.stringConverter = objectToStringConverter == null ? ObjectToStringConverter.DEFAULT_IMPLEMENTATION : objectToStringConverter;
        this.delegate = document == null ? this.createDefaultDocument() : document;
        this.handler = new Handler();
        this.delegate.addDocumentListener(this.handler);
        Object object = abstractAutoCompleteAdaptor.getSelectedItem();
        if (object != null) {
            this.setText(this.stringConverter.getPreferredStringForItem(object));
        }
        this.adaptor.markEntireText();
    }

    public AutoCompleteDocument(AbstractAutoCompleteAdaptor abstractAutoCompleteAdaptor, boolean bl, ObjectToStringConverter objectToStringConverter) {
        this(abstractAutoCompleteAdaptor, bl, objectToStringConverter, null);
    }

    public AutoCompleteDocument(AbstractAutoCompleteAdaptor abstractAutoCompleteAdaptor, boolean bl) {
        this(abstractAutoCompleteAdaptor, bl, null);
    }

    protected Document createDefaultDocument() {
        return new PlainDocument();
    }

    public void remove(int n, int n2) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        this.delegate.remove(n, n2);
        if (!this.strictMatching) {
            this.setSelectedItem(this.getText(0, this.getLength()), this.getText(0, this.getLength()));
            this.adaptor.getTextComponent().setCaretPosition(n);
        }
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        LookupResult lookupResult;
        if (this.selecting) {
            return;
        }
        this.delegate.insertString(n, string, attributeSet);
        String string2 = this.getText(0, this.getLength());
        if (string2 == null || string2.length() == 0) {
            lookupResult = new LookupResult(null, "");
            this.setSelectedItem(lookupResult.matchingItem, lookupResult.matchingString);
        } else {
            lookupResult = this.lookupItem(string2);
            if (lookupResult.matchingItem != null) {
                this.setSelectedItem(lookupResult.matchingItem, lookupResult.matchingString);
            } else if (this.strictMatching) {
                lookupResult.matchingItem = this.adaptor.getSelectedItem();
                lookupResult.matchingString = this.adaptor.getSelectedItemAsString();
                n -= string.length();
                UIManager.getLookAndFeel().provideErrorFeedback(this.adaptor.getTextComponent());
            } else {
                lookupResult.matchingItem = this.getText(0, this.getLength());
                lookupResult.matchingString = this.getText(0, this.getLength());
                this.setSelectedItem(lookupResult.matchingItem, lookupResult.matchingString);
            }
        }
        this.setText(lookupResult.matchingString);
        this.adaptor.markText(n + string.length());
    }

    private void setText(String string) {
        try {
            this.delegate.remove(0, this.getLength());
            this.delegate.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException.toString());
        }
    }

    private void setSelectedItem(Object object, String string) {
        this.selecting = true;
        this.adaptor.setSelectedItem(object);
        this.adaptor.setSelectedItemAsString(string);
        this.selecting = false;
    }

    private LookupResult lookupItem(String string) {
        int n;
        String[] stringArray;
        Object object;
        int n2;
        Object object2 = this.adaptor.getSelectedItem();
        int n3 = this.adaptor.getItemCount();
        for (n2 = 0; n2 < n3; ++n2) {
            object = this.adaptor.getItem(n2);
            stringArray = this.stringConverter.getPossibleStringsForItem(object);
            if (stringArray == null) continue;
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].equalsIgnoreCase(string)) continue;
                return new LookupResult(object, stringArray[n]);
            }
        }
        stringArray = this.stringConverter.getPossibleStringsForItem(object2);
        if (stringArray != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (!this.startsWithIgnoreCase(stringArray[n2], string)) continue;
                return new LookupResult(object2, stringArray[n2]);
            }
        }
        n3 = this.adaptor.getItemCount();
        for (n2 = 0; n2 < n3; ++n2) {
            object = this.adaptor.getItem(n2);
            stringArray = this.stringConverter.getPossibleStringsForItem(object);
            if (stringArray == null) continue;
            for (n = 0; n < stringArray.length; ++n) {
                if (!this.startsWithIgnoreCase(stringArray[n], string)) continue;
                return new LookupResult(object, stringArray[n]);
            }
        }
        return new LookupResult(null, "");
    }

    private boolean startsWithIgnoreCase(String string, String string2) {
        if (string.length() < string2.length()) {
            return false;
        }
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.handler.addDocumentListener(documentListener);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.handler.addUndoableEditListener(undoableEditListener);
    }

    public Position createPosition(int n) throws BadLocationException {
        return this.delegate.createPosition(n);
    }

    public Element getDefaultRootElement() {
        return this.delegate.getDefaultRootElement();
    }

    public Position getEndPosition() {
        return this.delegate.getEndPosition();
    }

    public int getLength() {
        return this.delegate.getLength();
    }

    public Object getProperty(Object object) {
        return this.delegate.getProperty(object);
    }

    public Element[] getRootElements() {
        return this.delegate.getRootElements();
    }

    public Position getStartPosition() {
        return this.delegate.getStartPosition();
    }

    public String getText(int n, int n2) throws BadLocationException {
        return this.delegate.getText(n, n2);
    }

    public void getText(int n, int n2, Segment segment) throws BadLocationException {
        this.delegate.getText(n, n2, segment);
    }

    public void putProperty(Object object, Object object2) {
        this.delegate.putProperty(object, object2);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.handler.removeDocumentListener(documentListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.handler.removeUndoableEditListener(undoableEditListener);
    }

    public void render(Runnable runnable) {
        this.delegate.render(runnable);
    }

    public boolean isStrictMatching() {
        return this.strictMatching;
    }

    private static class LookupResult {
        Object matchingItem;
        String matchingString;

        public LookupResult(Object object, String string) {
            this.matchingItem = object;
            this.matchingString = string;
        }
    }

    private class Handler
    implements DocumentListener,
    UndoableEditListener {
        private final EventListenerList listenerList = new EventListenerList();

        private Handler() {
        }

        public void addDocumentListener(DocumentListener documentListener) {
            this.listenerList.add(DocumentListener.class, documentListener);
        }

        public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
            this.listenerList.add(UndoableEditListener.class, undoableEditListener);
        }

        public void removeDocumentListener(DocumentListener documentListener) {
            this.listenerList.remove(DocumentListener.class, documentListener);
        }

        public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
            this.listenerList.remove(UndoableEditListener.class, undoableEditListener);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            documentEvent = new DelegatingDocumentEvent(AutoCompleteDocument.this, documentEvent);
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DocumentListener.class) continue;
                ((DocumentListener)objectArray[i + 1]).changedUpdate(documentEvent);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            documentEvent = new DelegatingDocumentEvent(AutoCompleteDocument.this, documentEvent);
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DocumentListener.class) continue;
                ((DocumentListener)objectArray[i + 1]).insertUpdate(documentEvent);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            documentEvent = new DelegatingDocumentEvent(AutoCompleteDocument.this, documentEvent);
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DocumentListener.class) continue;
                ((DocumentListener)objectArray[i + 1]).removeUpdate(documentEvent);
            }
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            undoableEditEvent = new UndoableEditEvent(AutoCompleteDocument.this, undoableEditEvent.getEdit());
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != UndoableEditListener.class) continue;
                ((UndoableEditListener)objectArray[i + 1]).undoableEditHappened(undoableEditEvent);
            }
        }
    }
}

