/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class ListAdaptor
extends AbstractAutoCompleteAdaptor
implements ListSelectionListener {
    JList list;
    JTextComponent textComponent;
    ObjectToStringConverter stringConverter;

    public ListAdaptor(JList jList, JTextComponent jTextComponent) {
        this(jList, jTextComponent, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public ListAdaptor(JList jList, JTextComponent jTextComponent, ObjectToStringConverter objectToStringConverter) {
        this.list = jList;
        this.textComponent = jTextComponent;
        this.stringConverter = objectToStringConverter;
        jList.addListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.getTextComponent().setText(this.stringConverter.getPreferredStringForItem(this.list.getSelectedValue()));
        this.markEntireText();
    }

    public Object getSelectedItem() {
        return this.list.getSelectedValue();
    }

    public int getItemCount() {
        return this.list.getModel().getSize();
    }

    public Object getItem(int n) {
        return this.list.getModel().getElementAt(n);
    }

    public void setSelectedItem(Object object) {
        this.list.setSelectedValue(object, true);
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }
}

