/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.border;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.border.Border;
import org.jdesktop.swingx.icon.EmptyIcon;

public class IconBorder
implements Border,
Serializable {
    public static final Icon EMPTY_ICON = new EmptyIcon();
    private int padding;
    private Icon icon;
    private int iconPosition;
    private Rectangle iconBounds = new Rectangle();

    public IconBorder() {
        this(null);
    }

    public IconBorder(Icon icon) {
        this(icon, 11);
    }

    public IconBorder(Icon icon, int n) {
        this(icon, n, 4);
    }

    public IconBorder(Icon icon, int n, int n2) {
        this.setIcon(icon);
        this.setPadding(n2);
        this.setIconPosition(n);
    }

    private boolean isValidPosition(int n) {
        boolean bl = false;
        switch (n) {
            case 3: 
            case 7: 
            case 10: 
            case 11: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public Insets getBorderInsets(Component component) {
        int n = this.icon.getIconWidth() + 2 * this.padding;
        int n2 = this.bidiDecodeLeadingTrailing(component.getComponentOrientation(), this.iconPosition);
        if (n2 == 3) {
            return new Insets(0, 0, 0, n);
        }
        return new Insets(0, n, 0, 0);
    }

    public void setIcon(Icon icon) {
        this.icon = icon == null ? EMPTY_ICON : icon;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.bidiDecodeLeadingTrailing(component.getComponentOrientation(), this.iconPosition);
        if (n5 == 2) {
            this.iconBounds.y = n2 + this.padding;
            this.iconBounds.x = n + n3 - this.padding - this.icon.getIconWidth();
        } else if (n5 == 3) {
            this.iconBounds.y = n2 + (n4 - this.icon.getIconHeight()) / 2;
            this.iconBounds.x = n + n3 - this.padding - this.icon.getIconWidth();
        } else if (n5 == 7) {
            this.iconBounds.y = n2 + (n4 - this.icon.getIconHeight()) / 2;
            this.iconBounds.x = n + this.padding;
        }
        this.iconBounds.width = this.icon.getIconWidth();
        this.iconBounds.height = this.icon.getIconHeight();
        this.icon.paintIcon(component, graphics, this.iconBounds.x, this.iconBounds.y);
    }

    private int bidiDecodeLeadingTrailing(ComponentOrientation componentOrientation, int n) {
        if (n == 11) {
            if (!componentOrientation.isLeftToRight()) {
                return 7;
            }
            return 3;
        }
        if (n == 10) {
            if (componentOrientation.isLeftToRight()) {
                return 7;
            }
            return 3;
        }
        return n;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int n) {
        this.padding = n < 0 ? 0 : n;
    }

    public int getIconPosition() {
        return this.iconPosition;
    }

    public void setIconPosition(int n) {
        if (!this.isValidPosition(n)) {
            throw new IllegalArgumentException("Invalid icon position");
        }
        this.iconPosition = n;
    }
}

