/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import org.jdesktop.swingx.calendar.CalendarUtils;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;
import org.jdesktop.swingx.event.EventListenerMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDateSelectionModel
implements DateSelectionModel {
    public static final SortedSet<Date> EMPTY_DATES = Collections.unmodifiableSortedSet(new TreeSet());
    protected EventListenerMap listenerMap = new EventListenerMap();
    protected boolean adjusting;
    protected Calendar calendar;
    protected Date upperBound;
    protected Date lowerBound;
    protected Locale locale;

    public AbstractDateSelectionModel() {
        this(null);
    }

    public AbstractDateSelectionModel(Locale locale) {
        this.setLocale(locale);
    }

    @Override
    public Calendar getCalendar() {
        return (Calendar)this.calendar.clone();
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.calendar.getFirstDayOfWeek();
    }

    @Override
    public void setFirstDayOfWeek(int n) {
        if (n == this.getFirstDayOfWeek()) {
            return;
        }
        this.calendar.setFirstDayOfWeek(n);
        this.fireValueChanged(DateSelectionEvent.EventType.CALENDAR_CHANGED);
    }

    @Override
    public int getMinimalDaysInFirstWeek() {
        return this.calendar.getMinimalDaysInFirstWeek();
    }

    @Override
    public void setMinimalDaysInFirstWeek(int n) {
        if (n == this.getMinimalDaysInFirstWeek()) {
            return;
        }
        this.calendar.setMinimalDaysInFirstWeek(n);
        this.fireValueChanged(DateSelectionEvent.EventType.CALENDAR_CHANGED);
    }

    @Override
    public TimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        if (this.getTimeZone().equals(timeZone)) {
            return;
        }
        TimeZone timeZone2 = this.getTimeZone();
        this.calendar.setTimeZone(timeZone);
        this.adjustDatesToTimeZone(timeZone2);
        this.fireValueChanged(DateSelectionEvent.EventType.CALENDAR_CHANGED);
    }

    protected void adjustDatesToTimeZone(TimeZone timeZone) {
        this.clearSelection();
        this.setLowerBound(null);
        this.setUpperBound(null);
        this.setUnselectableDates(EMPTY_DATES);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (locale.equals(this.getLocale())) {
            return;
        }
        this.locale = locale;
        this.calendar = this.calendar != null ? Calendar.getInstance(this.calendar.getTimeZone(), locale) : Calendar.getInstance(locale);
        this.fireValueChanged(DateSelectionEvent.EventType.CALENDAR_CHANGED);
    }

    protected Date startOfDay(Date date) {
        return CalendarUtils.startOfDay(this.calendar, date);
    }

    protected Date endOfDay(Date date) {
        return CalendarUtils.endOfDay(this.calendar, date);
    }

    protected boolean isSameDay(Date date, Date date2) {
        return this.startOfDay(date).equals(this.startOfDay(date2));
    }

    @Override
    public Date getUpperBound() {
        return this.upperBound;
    }

    @Override
    public void setUpperBound(Date date) {
        if (date != null) {
            date = this.getNormalizedDate(date);
        }
        if (CalendarUtils.areEqual(date, this.getUpperBound())) {
            return;
        }
        this.upperBound = date;
        if (this.upperBound != null && !this.isSelectionEmpty()) {
            long l = this.upperBound.getTime() + 1L;
            this.removeSelectionInterval(new Date(l), this.getLastSelectionDate());
        }
        this.fireValueChanged(DateSelectionEvent.EventType.UPPER_BOUND_CHANGED);
    }

    @Override
    public Date getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public void setLowerBound(Date date) {
        if (date != null) {
            date = this.getNormalizedDate(date);
        }
        if (CalendarUtils.areEqual(date, this.getLowerBound())) {
            return;
        }
        this.lowerBound = date;
        if (this.lowerBound != null && !this.isSelectionEmpty()) {
            long l = this.lowerBound.getTime() - 1L;
            this.removeSelectionInterval(this.getFirstSelectionDate(), new Date(l));
        }
        this.fireValueChanged(DateSelectionEvent.EventType.LOWER_BOUND_CHANGED);
    }

    @Override
    public boolean isAdjusting() {
        return this.adjusting;
    }

    @Override
    public void setAdjusting(boolean bl) {
        if (bl == this.isAdjusting()) {
            return;
        }
        this.adjusting = bl;
        this.fireValueChanged(bl ? DateSelectionEvent.EventType.ADJUSTING_STARTED : DateSelectionEvent.EventType.ADJUSTING_STOPPED);
    }

    @Override
    public void addDateSelectionListener(DateSelectionListener dateSelectionListener) {
        this.listenerMap.add(DateSelectionListener.class, dateSelectionListener);
    }

    @Override
    public void removeDateSelectionListener(DateSelectionListener dateSelectionListener) {
        this.listenerMap.remove(DateSelectionListener.class, dateSelectionListener);
    }

    public List<DateSelectionListener> getDateSelectionListeners() {
        return this.listenerMap.getListeners(DateSelectionListener.class);
    }

    protected void fireValueChanged(DateSelectionEvent.EventType eventType) {
        List<DateSelectionListener> list = this.getDateSelectionListeners();
        DateSelectionEvent dateSelectionEvent = null;
        for (DateSelectionListener dateSelectionListener : list) {
            if (dateSelectionEvent == null) {
                dateSelectionEvent = new DateSelectionEvent(this, eventType, this.isAdjusting());
            }
            dateSelectionListener.valueChanged(dateSelectionEvent);
        }
    }
}

