/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.JFormattedTextField;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatePickerFormatter
extends JFormattedTextField.AbstractFormatter {
    private static final Logger LOG = Logger.getLogger(DatePickerFormatter.class.getName());
    private DateFormat[] _formats = null;

    public DatePickerFormatter() {
        this(null, null);
    }

    public DatePickerFormatter(DateFormat[] dateFormatArray) {
        this(dateFormatArray, null);
    }

    public DatePickerFormatter(Locale locale) {
        this(null, locale);
    }

    public DatePickerFormatter(DateFormat[] dateFormatArray, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (dateFormatArray == null) {
            dateFormatArray = this.createDefaultFormats(locale);
        }
        Contract.asNotNull(dateFormatArray, "The array of DateFormats must not contain null formats");
        this._formats = dateFormatArray;
    }

    public DateFormat[] getFormats() {
        DateFormat[] dateFormatArray = new DateFormat[this._formats.length];
        System.arraycopy(this._formats, 0, dateFormatArray, 0, dateFormatArray.length);
        return dateFormatArray;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        Date date = null;
        ParseException parseException = null;
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        for (DateFormat dateFormat : this._formats) {
            try {
                date = dateFormat.parse(string);
                parseException = null;
                break;
            }
            catch (ParseException parseException2) {
                parseException = parseException2;
            }
        }
        if (parseException != null) {
            throw parseException;
        }
        return date;
    }

    @Override
    public String valueToString(Object object) throws ParseException {
        if (object != null && this._formats.length > 0) {
            return this._formats[0].format(object);
        }
        return null;
    }

    protected DateFormat[] createDefaultFormats(Locale locale) {
        ArrayList<DateFormat> arrayList = new ArrayList<DateFormat>();
        this.addFormat(arrayList, "JXDatePicker.longFormat", locale);
        this.addFormat(arrayList, "JXDatePicker.mediumFormat", locale);
        this.addFormat(arrayList, "JXDatePicker.shortFormat", locale);
        if (arrayList.size() == 0) {
            this.addSystemDefaultFormat(arrayList, locale);
        }
        return arrayList.toArray(new DateFormat[arrayList.size()]);
    }

    private void addSystemDefaultFormat(List<DateFormat> list, Locale locale) {
        list.add(DateFormat.getDateInstance(3, locale));
    }

    private void addFormat(List<DateFormat> list, String string, Locale locale) {
        String string2 = UIManagerExt.getString(string, locale);
        if (string2 == null) {
            return;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, locale);
            list.add(simpleDateFormat);
        }
        catch (RuntimeException runtimeException) {
            LOG.finer("creating date format failed for key/pattern: " + string + "/" + string2);
        }
    }

    public static class DatePickerFormatterUIResource
    extends DatePickerFormatter
    implements UIResource {
        public DatePickerFormatterUIResource(Locale locale) {
            super(locale);
        }

        public DatePickerFormatterUIResource() {
            this((Locale)null);
        }

        public DatePickerFormatterUIResource(DateFormat[] dateFormatArray, Locale locale) {
            super(dateFormatArray, locale);
        }
    }
}

