/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class ColorUtil {
    public static Color removeAlpha(Color color) {
        return ColorUtil.setAlpha(color, 255);
    }

    public static Color setAlpha(Color color, int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("invalid alpha value");
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static Color setSaturation(Color color, float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("invalid saturation value");
        }
        int n = color.getAlpha();
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        Color color2 = Color.getHSBColor(fArray[0], f, fArray[2]);
        return ColorUtil.setAlpha(color2, n);
    }

    public static Color setBrightness(Color color, float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("invalid brightness value");
        }
        int n = color.getAlpha();
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        Color color2 = Color.getHSBColor(fArray[0], fArray[1], f);
        return ColorUtil.setAlpha(color2, n);
    }

    public static String toHexString(Color color) {
        return "#" + Integer.toHexString(color.getRGB() | 0xFF000000).substring(2);
    }

    public static Color computeForeground(Color color) {
        float[] fArray = color.getRGBColorComponents(null);
        float f = 0.3f * fArray[0] + 0.59f * fArray[1] + 0.11f * fArray[2];
        return f > 0.5f ? Color.BLACK : Color.WHITE;
    }

    public static Color blend(Color color, Color color2) {
        if (color2 == null) {
            return color;
        }
        if (color == null) {
            return color2;
        }
        int n = color2.getAlpha();
        int n2 = (color2.getRGB() & 0xFF00FF) * n + (color.getRGB() & 0xFF00FF) * (255 - n) & 0xFF00FF00;
        int n3 = (color2.getRGB() & 0xFF00) * n + (color.getRGB() & 0xFF00) * (255 - n) & 0xFF0000;
        return new Color(color2.getRGB() & 0xFF000000 | (n2 | n3) >> 8);
    }

    public static Paint getCheckerPaint() {
        return ColorUtil.getCheckerPaint(Color.white, Color.gray, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Paint getCheckerPaint(Color color, Color color2, int n) {
        BufferedImage bufferedImage = new BufferedImage(n, n, 2);
        Graphics graphics = bufferedImage.getGraphics();
        try {
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n);
            graphics.setColor(color2);
            graphics.fillRect(0, 0, n / 2, n / 2);
            graphics.fillRect(n / 2, n / 2, n / 2, n / 2);
        }
        finally {
            graphics.dispose();
        }
        return new TexturePaint(bufferedImage, new Rectangle(0, 0, n, n));
    }

    public static void tileStretchPaint(Graphics graphics, JComponent jComponent, BufferedImage bufferedImage, Insets insets) {
        int n = insets.left;
        int n2 = insets.right;
        int n3 = insets.top;
        int n4 = insets.bottom;
        graphics.drawImage(bufferedImage, 0, 0, n, n3, 0, 0, n, n3, null);
        graphics.drawImage(bufferedImage, n, 0, jComponent.getWidth() - n2, n3, n, 0, bufferedImage.getWidth() - n2, n3, null);
        graphics.drawImage(bufferedImage, jComponent.getWidth() - n2, 0, jComponent.getWidth(), n3, bufferedImage.getWidth() - n2, 0, bufferedImage.getWidth(), n3, null);
        graphics.drawImage(bufferedImage, 0, n3, n, jComponent.getHeight() - n4, 0, n3, n, bufferedImage.getHeight() - n4, null);
        graphics.drawImage(bufferedImage, n, n3, jComponent.getWidth() - n2, jComponent.getHeight() - n4, n, n3, bufferedImage.getWidth() - n2, bufferedImage.getHeight() - n4, null);
        graphics.drawImage(bufferedImage, jComponent.getWidth() - n2, n3, jComponent.getWidth(), jComponent.getHeight() - n4, bufferedImage.getWidth() - n2, n3, bufferedImage.getWidth(), bufferedImage.getHeight() - n4, null);
        graphics.drawImage(bufferedImage, 0, jComponent.getHeight() - n4, n, jComponent.getHeight(), 0, bufferedImage.getHeight() - n4, n, bufferedImage.getHeight(), null);
        graphics.drawImage(bufferedImage, n, jComponent.getHeight() - n4, jComponent.getWidth() - n2, jComponent.getHeight(), n, bufferedImage.getHeight() - n4, bufferedImage.getWidth() - n2, bufferedImage.getHeight(), null);
        graphics.drawImage(bufferedImage, jComponent.getWidth() - n2, jComponent.getHeight() - n4, jComponent.getWidth(), jComponent.getHeight(), bufferedImage.getWidth() - n2, bufferedImage.getHeight() - n4, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
    }

    public static Color interpolate(Color color, Color color2, float f) {
        float[] fArray = color2.getRGBComponents(null);
        float[] fArray2 = color.getRGBComponents(null);
        float[] fArray3 = new float[4];
        for (int i = 0; i < 4; ++i) {
            fArray3[i] = fArray[i] + (fArray2[i] - fArray[i]) * f;
        }
        return new Color(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
    }
}

