/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.combobox;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.swingx.combobox.ListComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumComboBoxModel<E extends Enum<E>>
extends ListComboBoxModel<E> {
    private final Map<String, E> valueMap = new HashMap<String, E>();
    private final Class<E> enumClass;

    public EnumComboBoxModel(Class<E> clazz) {
        super(new ArrayList<E>(EnumSet.allOf(clazz)));
        this.enumClass = clazz;
        for (Enum enum_ : this.data) {
            String string = enum_.toString();
            if (this.valueMap.containsKey(string)) {
                throw new IllegalArgumentException("multiple constants map to one string value");
            }
            this.valueMap.put(string, enum_);
        }
    }

    @Override
    public void setSelectedItem(Object object) {
        Enum enum_ = null;
        enum_ = this.enumClass.isInstance(object) ? (Enum)object : (Enum)this.valueMap.get(object);
        if (enum_ != null || object == null) {
            this.selected = enum_;
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }
}

