/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.awt.Point;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.util.Contract;

public interface HighlightPredicate {
    public static final HighlightPredicate ALWAYS = new HighlightPredicate(){

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return true;
        }
    };
    public static final HighlightPredicate NEVER = new HighlightPredicate(){

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return false;
        }
    };
    public static final HighlightPredicate ROLLOVER_ROW = new HighlightPredicate(){

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            if (!componentAdapter.getComponent().isEnabled()) {
                return false;
            }
            Point point = (Point)componentAdapter.getComponent().getClientProperty("swingx.rollover");
            return point != null && point.y == componentAdapter.row;
        }
    };
    public static final HighlightPredicate EDITABLE = new HighlightPredicate(){

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.isEditable();
        }
    };
    public static final HighlightPredicate READ_ONLY = new HighlightPredicate(){

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return !componentAdapter.isEditable();
        }
    };
    public static final HighlightPredicate IS_LEAF = new HighlightPredicate(){

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.isLeaf();
        }
    };
    public static final HighlightPredicate IS_FOLDER = new HighlightPredicate(){

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return !componentAdapter.isLeaf();
        }
    };
    public static final HighlightPredicate HAS_FOCUS = new HighlightPredicate(){

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.hasFocus();
        }
    };
    public static final HighlightPredicate EVEN = new HighlightPredicate(){

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.row % 2 == 0;
        }
    };
    public static final HighlightPredicate ODD = new HighlightPredicate(){

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return !EVEN.isHighlighted(component, componentAdapter);
        }
    };
    public static final HighlightPredicate BIG_DECIMAL_NEGATIVE = new HighlightPredicate(){

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.getValue() instanceof BigDecimal && ((BigDecimal)componentAdapter.getValue()).compareTo(BigDecimal.ZERO) < 0;
        }
    };
    public static final HighlightPredicate INTEGER_NEGATIVE = new HighlightPredicate(){

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.getValue() instanceof Number && ((Number)componentAdapter.getValue()).intValue() < 0;
        }
    };
    public static final HighlightPredicate[] EMPTY_PREDICATE_ARRAY = new HighlightPredicate[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Integer[] EMPTY_INTEGER_ARRAY = new Integer[0];

    public boolean isHighlighted(Component var1, ComponentAdapter var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeHighlightPredicate
    implements HighlightPredicate {
        private Class<?> clazz;

        public TypeHighlightPredicate() {
            this(Object.class);
        }

        public TypeHighlightPredicate(Class clazz) {
            this.clazz = clazz;
        }

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.getValue() != null ? this.clazz.isAssignableFrom(componentAdapter.getValue().getClass()) : false;
        }

        public Class<?> getType() {
            return this.clazz;
        }
    }

    public static class EqualsHighlightPredicate
    implements HighlightPredicate {
        private Object compareValue;

        public EqualsHighlightPredicate() {
            this(null);
        }

        public EqualsHighlightPredicate(Object object) {
            this.compareValue = object;
        }

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            if (this.compareValue == null) {
                return componentAdapter.getValue() == null;
            }
            return this.compareValue.equals(componentAdapter.getValue());
        }

        public Object getCompareValue() {
            return this.compareValue;
        }
    }

    public static class DepthHighlightPredicate
    implements HighlightPredicate {
        private List<Integer> depthList = new ArrayList<Integer>();

        public DepthHighlightPredicate(int ... nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                this.depthList.add(nArray[i]);
            }
        }

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            int n = componentAdapter.getDepth();
            return this.depthList.contains(n);
        }

        public Integer[] getDepths() {
            if (this.depthList.isEmpty()) {
                return EMPTY_INTEGER_ARRAY;
            }
            return this.depthList.toArray(new Integer[this.depthList.size()]);
        }
    }

    public static class IdentifierHighlightPredicate
    implements HighlightPredicate {
        List<Object> columnList = new ArrayList<Object>();

        public IdentifierHighlightPredicate(Object ... objectArray) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.columnList.add(objectArray[i]);
            }
        }

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            int n = componentAdapter.viewToModel(componentAdapter.column);
            Object object = componentAdapter.getColumnIdentifierAt(n);
            return object != null ? this.columnList.contains(object) : false;
        }

        public Object[] getIdentifiers() {
            if (this.columnList.isEmpty()) {
                return EMPTY_OBJECT_ARRAY;
            }
            return this.columnList.toArray(new Object[0]);
        }
    }

    public static class ColumnHighlightPredicate
    implements HighlightPredicate {
        List<Integer> columnList = new ArrayList<Integer>();

        public ColumnHighlightPredicate(int ... nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                this.columnList.add(nArray[i]);
            }
        }

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            int n = componentAdapter.viewToModel(componentAdapter.column);
            return this.columnList.contains(n);
        }

        public Integer[] getColumns() {
            if (this.columnList.isEmpty()) {
                return EMPTY_INTEGER_ARRAY;
            }
            return this.columnList.toArray(new Integer[this.columnList.size()]);
        }
    }

    public static class RowGroupHighlightPredicate
    implements HighlightPredicate {
        private int linesPerGroup;

        public RowGroupHighlightPredicate(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("a group contain at least 1 row, was: " + n);
            }
            this.linesPerGroup = n;
        }

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.row / this.linesPerGroup % 2 == 1;
        }

        public int getLinesPerGroup() {
            return this.linesPerGroup;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrHighlightPredicate
    implements HighlightPredicate {
        private List<HighlightPredicate> predicate;

        public OrHighlightPredicate(HighlightPredicate ... highlightPredicateArray) {
            this.predicate = Arrays.asList((Object[])Contract.asNotNull(highlightPredicateArray, "predicate must not be null"));
        }

        public OrHighlightPredicate(Collection<HighlightPredicate> collection) {
            this.predicate = new ArrayList<HighlightPredicate>(Contract.asNotNull(collection, "predicate list must not be null"));
        }

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            for (HighlightPredicate highlightPredicate : this.predicate) {
                if (!highlightPredicate.isHighlighted(component, componentAdapter)) continue;
                return true;
            }
            return false;
        }

        public HighlightPredicate[] getHighlightPredicates() {
            if (this.predicate.isEmpty()) {
                return EMPTY_PREDICATE_ARRAY;
            }
            return this.predicate.toArray(new HighlightPredicate[this.predicate.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AndHighlightPredicate
    implements HighlightPredicate {
        private List<HighlightPredicate> predicate;

        public AndHighlightPredicate(HighlightPredicate ... highlightPredicateArray) {
            this.predicate = Arrays.asList((Object[])Contract.asNotNull(highlightPredicateArray, "predicate must not be null"));
        }

        public AndHighlightPredicate(Collection<HighlightPredicate> collection) {
            this.predicate = new ArrayList<HighlightPredicate>(Contract.asNotNull(collection, "predicate list must not be null"));
        }

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            for (HighlightPredicate highlightPredicate : this.predicate) {
                if (highlightPredicate.isHighlighted(component, componentAdapter)) continue;
                return false;
            }
            return !this.predicate.isEmpty();
        }

        public HighlightPredicate[] getHighlightPredicates() {
            if (this.predicate.isEmpty()) {
                return EMPTY_PREDICATE_ARRAY;
            }
            return this.predicate.toArray(new HighlightPredicate[this.predicate.size()]);
        }
    }

    public static class NotHighlightPredicate
    implements HighlightPredicate {
        private HighlightPredicate predicate;

        public NotHighlightPredicate(HighlightPredicate highlightPredicate) {
            if (highlightPredicate == null) {
                throw new NullPointerException("predicate must not be null");
            }
            this.predicate = highlightPredicate;
        }

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return !this.predicate.isHighlighted(component, componentAdapter);
        }

        public HighlightPredicate getHighlightPredicate() {
            return this.predicate;
        }
    }
}

