/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.error;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.error.ErrorEvent;
import org.jdesktop.swingx.error.ErrorListener;

public class ErrorSupport {
    private List<ErrorListener> listeners;
    private Object source;

    public ErrorSupport(Object object) {
        this.source = object;
        this.listeners = new ArrayList<ErrorListener>();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.listeners.add(errorListener);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.listeners.remove(errorListener);
    }

    public ErrorListener[] getErrorListeners() {
        return (ErrorListener[])this.listeners.toArray((T[])null);
    }

    public void fireErrorEvent(Throwable throwable) {
        final ErrorEvent errorEvent = new ErrorEvent(throwable, this.source);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (ErrorListener errorListener : ErrorSupport.this.listeners) {
                    errorListener.errorOccured(errorEvent);
                }
            }
        });
    }
}

