/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakEventListenerList
implements Serializable {
    protected transient List<WeakReference<? extends EventListener>> weakReferences;
    protected transient List<Class<? extends EventListener>> classes;

    public Object[] getListenerList() {
        List list = this.cleanReferences();
        Object[] objectArray = new Object[list.size() * 2];
        for (int i = 0; i < list.size(); ++i) {
            objectArray[2 * i + 1] = list.get(i);
            objectArray[2 * i] = this.getClasses().get(i);
        }
        return objectArray;
    }

    private synchronized <T extends EventListener> List<T> cleanReferences() {
        ArrayList<EventListener> arrayList = new ArrayList<EventListener>();
        for (int i = this.getReferences().size() - 1; i >= 0; --i) {
            Object t = this.getReferences().get(i).get();
            if (t == null) {
                this.getReferences().remove(i);
                this.getClasses().remove(i);
                continue;
            }
            arrayList.add(0, (EventListener)t);
        }
        return arrayList;
    }

    private List<WeakReference<? extends EventListener>> getReferences() {
        if (this.weakReferences == null) {
            this.weakReferences = new ArrayList<WeakReference<? extends EventListener>>();
        }
        return this.weakReferences;
    }

    private List<Class<? extends EventListener>> getClasses() {
        if (this.classes == null) {
            this.classes = new ArrayList<Class<? extends EventListener>>();
        }
        return this.classes;
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        List<T> list = this.cleanReferences();
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i = 0; i < list.size(); ++i) {
            if (this.getClasses().get(i) != clazz) continue;
            arrayList.add(list.get(i));
        }
        EventListener[] eventListenerArray = (EventListener[])Array.newInstance(clazz, arrayList.size());
        return arrayList.toArray(eventListenerArray);
    }

    public synchronized <T extends EventListener> void add(Class<T> clazz, T t) {
        if (t == null) {
            return;
        }
        if (!clazz.isInstance(t)) {
            throw new IllegalArgumentException("Listener " + t + " is not of type " + clazz);
        }
        this.cleanReferences();
        this.getReferences().add(new WeakReference<T>(t));
        this.getClasses().add(clazz);
    }

    public synchronized <T extends EventListener> void remove(Class<T> clazz, T t) {
        if (t == null) {
            return;
        }
        if (!clazz.isInstance(t)) {
            throw new IllegalArgumentException("Listener " + t + " is not of type " + clazz);
        }
        for (int i = 0; i < this.getReferences().size(); ++i) {
            if (!t.equals(this.getReferences().get(i).get()) || clazz != this.getClasses().get(i)) continue;
            this.getReferences().remove(i);
            this.getClasses().remove(i);
            break;
        }
    }
}

