/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Star2D
implements Shape {
    private Shape starShape;
    private double x;
    private double y;
    private double innerRadius;
    private double outerRadius;
    private int branchesCount;

    public Star2D(double d, double d2, double d3, double d4, int n) {
        if (n < 3) {
            throw new IllegalArgumentException("The number of branches must be >= 3.");
        }
        if (d3 >= d4) {
            throw new IllegalArgumentException("The inner radius must be < outer radius.");
        }
        this.x = d;
        this.y = d2;
        this.innerRadius = d3;
        this.outerRadius = d4;
        this.branchesCount = n;
        this.starShape = Star2D.generateStar(d, d2, d3, d4, n);
    }

    private static Shape generateStar(double d, double d2, double d3, double d4, int n) {
        GeneralPath generalPath = new GeneralPath();
        double d5 = Math.PI * 2 / (double)n;
        double d6 = n % 2 == 0 ? 0.0 : -1.5707963267948966;
        double d7 = d5 / 2.0 + d6;
        float f = (float)(Math.cos(d6) * d4 + d);
        float f2 = (float)(Math.sin(d6) * d4 + d2);
        float f3 = (float)(Math.cos(d7) * d3 + d);
        float f4 = (float)(Math.sin(d7) * d3 + d2);
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        d6 += d5;
        d7 += d5;
        for (int i = 1; i < n; ++i) {
            f = (float)(Math.cos(d6) * d4 + d);
            f2 = (float)(Math.sin(d6) * d4 + d2);
            generalPath.lineTo(f, f2);
            f3 = (float)(Math.cos(d7) * d3 + d);
            f4 = (float)(Math.sin(d7) * d3 + d2);
            generalPath.lineTo(f3, f4);
            d6 += d5;
            d7 += d5;
        }
        generalPath.closePath();
        return generalPath;
    }

    public void setInnerRadius(double d) {
        if (d >= this.outerRadius) {
            throw new IllegalArgumentException("The inner radius must be < outer radius.");
        }
        this.innerRadius = d;
        this.starShape = Star2D.generateStar(this.getX(), this.getY(), d, this.getOuterRadius(), this.getBranchesCount());
    }

    public void setX(double d) {
        this.x = d;
        this.starShape = Star2D.generateStar(d, this.getY(), this.getInnerRadius(), this.getOuterRadius(), this.getBranchesCount());
    }

    public void setY(double d) {
        this.y = d;
        this.starShape = Star2D.generateStar(this.getX(), d, this.getInnerRadius(), this.getOuterRadius(), this.getBranchesCount());
    }

    public void setOuterRadius(double d) {
        if (this.innerRadius >= d) {
            throw new IllegalArgumentException("The outer radius must be > inner radius.");
        }
        this.outerRadius = d;
        this.starShape = Star2D.generateStar(this.getX(), this.getY(), this.getInnerRadius(), d, this.getBranchesCount());
    }

    public void setBranchesCount(int n) {
        if (n <= 2) {
            throw new IllegalArgumentException("The number of branches must be >= 3.");
        }
        this.branchesCount = n;
        this.starShape = Star2D.generateStar(this.getX(), this.getY(), this.getInnerRadius(), this.getOuterRadius(), n);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public int getBranchesCount() {
        return this.branchesCount;
    }

    public Rectangle getBounds() {
        return this.starShape.getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.starShape.getBounds2D();
    }

    public boolean contains(double d, double d2) {
        return this.starShape.contains(d, d2);
    }

    public boolean contains(Point2D point2D) {
        return this.starShape.contains(point2D);
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.starShape.intersects(d, d2, d3, d4);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.starShape.intersects(rectangle2D);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.starShape.contains(d, d2, d3, d4);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.starShape.contains(rectangle2D);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.starShape.getPathIterator(affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.starShape.getPathIterator(affineTransform, d);
    }
}

