/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.image;

import java.awt.image.BufferedImage;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.image.AbstractFilter;

public class GaussianBlurFilter
extends AbstractFilter {
    private final int radius;

    public GaussianBlurFilter() {
        this(3);
    }

    public GaussianBlurFilter(int n) {
        if (n < 1) {
            n = 1;
        }
        this.radius = n;
    }

    public int getRadius() {
        return this.radius;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int[] nArray = new int[n * n2];
        int[] nArray2 = new int[n * n2];
        float[] fArray = GaussianBlurFilter.createGaussianKernel(this.radius);
        GraphicsUtilities.getPixels(bufferedImage, 0, 0, n, n2, nArray);
        GaussianBlurFilter.blur(nArray, nArray2, n, n2, fArray, this.radius);
        GaussianBlurFilter.blur(nArray2, nArray, n2, n, fArray, this.radius);
        GraphicsUtilities.setPixels(bufferedImage2, 0, 0, n, n2, nArray);
        return bufferedImage2;
    }

    static void blur(int[] nArray, int[] nArray2, int n, int n2, float[] fArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            int n4 = i;
            int n5 = i * n;
            for (int j = 0; j < n; ++j) {
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                for (int k = -n3; k <= n3; ++k) {
                    int n6 = j + k;
                    if (n6 < 0 || n6 >= n) {
                        n6 = (j + n) % n;
                    }
                    int n7 = nArray[n5 + n6];
                    float f5 = fArray[n3 + k];
                    f4 += f5 * (float)(n7 >> 24 & 0xFF);
                    f3 += f5 * (float)(n7 >> 16 & 0xFF);
                    f2 += f5 * (float)(n7 >> 8 & 0xFF);
                    f += f5 * (float)(n7 & 0xFF);
                }
                int n8 = (int)(f4 + 0.5f);
                int n9 = (int)(f3 + 0.5f);
                int n10 = (int)(f2 + 0.5f);
                int n11 = (int)(f + 0.5f);
                nArray2[n4] = (n8 > 255 ? 255 : n8) << 24 | (n9 > 255 ? 255 : n9) << 16 | (n10 > 255 ? 255 : n10) << 8 | (n11 > 255 ? 255 : n11);
                n4 += n2;
            }
        }
    }

    static float[] createGaussianKernel(int n) {
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        float[] fArray = new float[n * 2 + 1];
        float f = (float)n / 3.0f;
        float f2 = 2.0f * f * f;
        float f3 = (float)Math.sqrt((double)f2 * Math.PI);
        float f4 = 0.0f;
        for (n2 = -n; n2 <= n; ++n2) {
            float f5 = n2 * n2;
            int n3 = n2 + n;
            fArray[n3] = (float)Math.exp(-f5 / f2) / f3;
            f4 += fArray[n3];
        }
        n2 = 0;
        while (n2 < fArray.length) {
            int n4 = n2++;
            fArray[n4] = fArray[n4] / f4;
        }
        return fArray;
    }
}

