/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.multislider;

import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingx.multislider.MultiThumbModel;
import org.jdesktop.swingx.multislider.Thumb;
import org.jdesktop.swingx.multislider.ThumbDataEvent;
import org.jdesktop.swingx.multislider.ThumbDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultiThumbModel<E>
implements MultiThumbModel<E> {
    protected float maximumValue = 1.0f;
    protected float minimumValue = 0.0f;
    protected List<ThumbDataListener> thumbDataListeners = new ArrayList<ThumbDataListener>();

    @Override
    public float getMaximumValue() {
        return this.maximumValue;
    }

    @Override
    public float getMinimumValue() {
        return this.minimumValue;
    }

    @Override
    public void setMaximumValue(float f) {
        this.maximumValue = f;
    }

    @Override
    public void setMinimumValue(float f) {
        this.minimumValue = f;
    }

    @Override
    public void addThumbDataListener(ThumbDataListener thumbDataListener) {
        this.thumbDataListeners.add(thumbDataListener);
    }

    @Override
    public void removeThumbDataListener(ThumbDataListener thumbDataListener) {
        this.thumbDataListeners.remove(thumbDataListener);
    }

    @Override
    public void thumbPositionChanged(Thumb<E> thumb) {
        this.fireThumbPositionChanged(thumb);
    }

    protected void fireThumbPositionChanged(Thumb<E> thumb) {
        if (this.getThumbIndex(thumb) >= 0) {
            ThumbDataEvent thumbDataEvent = new ThumbDataEvent(this, -1, this.getThumbIndex(thumb), thumb);
            for (ThumbDataListener thumbDataListener : this.thumbDataListeners) {
                thumbDataListener.positionChanged(thumbDataEvent);
            }
        }
    }

    @Override
    public void thumbValueChanged(Thumb<E> thumb) {
        this.fireThumbValueChanged(thumb);
    }

    protected void fireThumbValueChanged(Thumb<E> thumb) {
        ThumbDataEvent thumbDataEvent = new ThumbDataEvent(this, -1, this.getThumbIndex(thumb), thumb);
        for (ThumbDataListener thumbDataListener : this.thumbDataListeners) {
            thumbDataListener.valueChanged(thumbDataEvent);
        }
    }
}

