/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundPainter<T>
extends AbstractPainter<T> {
    private Painter[] painters = new Painter[0];
    private AffineTransform transform;
    private boolean clipPreserved = false;
    private boolean checkForDirtyChildPainters = true;
    private boolean clearLocalCacheOnly = false;

    public CompoundPainter() {
    }

    public CompoundPainter(Painter ... painterArray) {
        this.painters = new Painter[painterArray == null ? 0 : painterArray.length];
        if (painterArray != null) {
            System.arraycopy(painterArray, 0, this.painters, 0, painterArray.length);
        }
    }

    public void setPainters(Painter ... painterArray) {
        Painter[] painterArray2 = this.getPainters();
        this.painters = new Painter[painterArray == null ? 0 : painterArray.length];
        if (painterArray != null) {
            System.arraycopy(painterArray, 0, this.painters, 0, this.painters.length);
        }
        this.setDirty(true);
        this.firePropertyChange("painters", painterArray2, this.getPainters());
    }

    public final Painter[] getPainters() {
        Painter[] painterArray = new Painter[this.painters.length];
        System.arraycopy(this.painters, 0, painterArray, 0, painterArray.length);
        return painterArray;
    }

    public boolean isClipPreserved() {
        return this.clipPreserved;
    }

    public void setClipPreserved(boolean bl) {
        boolean bl2 = this.isClipPreserved();
        this.clipPreserved = bl;
        this.setDirty(true);
        this.firePropertyChange("clipPreserved", bl2, bl);
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.getTransform();
        this.transform = affineTransform;
        this.setDirty(true);
        this.firePropertyChange("transform", affineTransform2, affineTransform);
    }

    @Override
    protected void validate(T t) {
        boolean bl = false;
        for (Painter painter : this.painters) {
            if (!(painter instanceof AbstractPainter)) continue;
            AbstractPainter abstractPainter = (AbstractPainter)painter;
            abstractPainter.validate(t);
            if (!abstractPainter.isDirty()) continue;
            bl = true;
            break;
        }
        this.clearLocalCacheOnly = true;
        this.setDirty(bl);
        this.clearLocalCacheOnly = false;
    }

    public boolean isCheckingDirtyChildPainters() {
        return this.checkForDirtyChildPainters;
    }

    public void setCheckingDirtyChildPainters(boolean bl) {
        boolean bl2 = this.isCheckingDirtyChildPainters();
        this.checkForDirtyChildPainters = bl;
        this.firePropertyChange("checkingDirtyChildPainters", bl2, this.isCheckingDirtyChildPainters());
    }

    @Override
    protected boolean isDirty() {
        boolean bl = super.isDirty();
        if (bl) {
            return true;
        }
        if (this.isCheckingDirtyChildPainters()) {
            for (Painter painter : this.painters) {
                AbstractPainter abstractPainter;
                if (!(painter instanceof AbstractPainter) || !(abstractPainter = (AbstractPainter)painter).isDirty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clearCache() {
        if (!this.clearLocalCacheOnly) {
            for (Painter painter : this.painters) {
                if (!(painter instanceof AbstractPainter)) continue;
                AbstractPainter abstractPainter = (AbstractPainter)painter;
                abstractPainter.clearCache();
            }
        }
        super.clearCache();
    }

    public void clearLocalCache() {
        super.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPaint(Graphics2D graphics2D, T t, int n, int n2) {
        for (Painter painter : this.getPainters()) {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            try {
                painter.paint(graphics2D2, t, n, n2);
                if (!this.isClipPreserved()) continue;
                graphics2D.setClip(graphics2D2.getClip());
            }
            finally {
                graphics2D2.dispose();
            }
        }
    }

    @Override
    protected void configureGraphics(Graphics2D graphics2D) {
        AffineTransform affineTransform = this.getTransform();
        if (affineTransform != null) {
            graphics2D.setTransform(affineTransform);
        }
    }

    @Override
    protected boolean shouldUseCache() {
        return this.isCacheable() && this.painters != null && this.painters.length > 0 || super.shouldUseCache();
    }
}

