/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import org.jdesktop.swingx.painter.AbstractPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlossPainter
extends AbstractPainter<Object> {
    private Paint paint;
    private GlossPosition position;

    public GlossPainter() {
        this(new Color(1.0f, 1.0f, 1.0f, 0.2f), GlossPosition.TOP);
    }

    public GlossPainter(Paint paint) {
        this(paint, GlossPosition.TOP);
    }

    public GlossPainter(GlossPosition glossPosition) {
        this(new Color(1.0f, 1.0f, 1.0f, 0.2f), glossPosition);
    }

    public GlossPainter(Paint paint, GlossPosition glossPosition) {
        this.setPaint(paint);
        this.setPosition(glossPosition);
    }

    @Override
    protected void doPaint(Graphics2D graphics2D, Object object, int n, int n2) {
        if (this.getPaint() != null) {
            Ellipse2D.Double double_ = new Ellipse2D.Double((double)(-n) / 2.0, (double)n2 / 2.7, (double)n * 2.0, (double)n2 * 2.0);
            Area area = new Area(double_);
            if (this.getPosition() == GlossPosition.TOP) {
                Area area2 = new Area(new Rectangle(0, 0, n, n2));
                area2.subtract(new Area(double_));
                area = area2;
            }
            graphics2D.setPaint(this.getPaint());
            graphics2D.fill(area);
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        Paint paint2 = this.paint;
        this.paint = paint;
        this.setDirty(true);
        this.firePropertyChange("paint", paint2, this.getPaint());
    }

    public GlossPosition getPosition() {
        return this.position;
    }

    public void setPosition(GlossPosition glossPosition) {
        GlossPosition glossPosition2 = this.position;
        this.position = glossPosition;
        this.setDirty(true);
        this.firePropertyChange("position", (Object)glossPosition2, (Object)this.getPosition());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GlossPosition {
        TOP,
        BOTTOM;

    }
}

