/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.AbstractLayoutPainter;
import org.jdesktop.swingx.painter.effects.AreaEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImagePainter
extends AbstractAreaPainter<Object> {
    private static final Logger LOG = Logger.getLogger(ImagePainter.class.getName());
    private transient BufferedImage img;
    private URL imageURL;
    private boolean horizontalRepeat;
    private boolean verticalRepeat;
    private boolean scaleToFit = false;
    private ScaleType scaleType = ScaleType.InsideFit;
    private double imageScale = 1.0;
    private Logger log = Logger.getLogger(ImagePainter.class.getName());
    private String imageString;

    public ImagePainter() {
        this((BufferedImage)null);
    }

    public ImagePainter(BufferedImage bufferedImage) {
        this(bufferedImage, AbstractLayoutPainter.HorizontalAlignment.CENTER, AbstractLayoutPainter.VerticalAlignment.CENTER);
    }

    public ImagePainter(BufferedImage bufferedImage, AbstractLayoutPainter.HorizontalAlignment horizontalAlignment, AbstractLayoutPainter.VerticalAlignment verticalAlignment) {
        this.setCacheable(true);
        this.img = bufferedImage;
        this.setVerticalAlignment(verticalAlignment);
        this.setHorizontalAlignment(horizontalAlignment);
        this.setFillPaint(null);
        this.setBorderPaint(null);
    }

    public ImagePainter(URL uRL) throws IOException {
        this(ImageIO.read(uRL));
    }

    public ImagePainter(URL uRL, AbstractLayoutPainter.HorizontalAlignment horizontalAlignment, AbstractLayoutPainter.VerticalAlignment verticalAlignment) throws IOException {
        this(ImageIO.read(uRL), horizontalAlignment, verticalAlignment);
    }

    public void setImage(BufferedImage bufferedImage) {
        if (bufferedImage != this.img) {
            BufferedImage bufferedImage2 = this.img;
            this.img = bufferedImage;
            this.setDirty(true);
            this.firePropertyChange("image", bufferedImage2, this.img);
        }
    }

    public BufferedImage getImage() {
        if (this.img == null && this.imageURL != null) {
            this.loadImage();
        }
        return this.img;
    }

    @Override
    protected void doPaint(Graphics2D graphics2D, Object object, int n, int n2) {
        if (this.img == null && this.imageURL != null) {
            this.loadImage();
        }
        Shape shape = this.provideShape(graphics2D, object, n, n2);
        switch (this.getStyle()) {
            case BOTH: {
                this.drawBackground(graphics2D, shape, n, n2);
                this.drawBorder(graphics2D, shape, n, n2);
                break;
            }
            case FILLED: {
                this.drawBackground(graphics2D, shape, n, n2);
                break;
            }
            case OUTLINE: {
                this.drawBorder(graphics2D, shape, n, n2);
                break;
            }
        }
    }

    private void drawBackground(Graphics2D graphics2D, Shape shape, int n, int n2) {
        Paint paint = this.getFillPaint();
        if (paint != null) {
            if (this.isPaintStretched()) {
                paint = this.calculateSnappedPaint(paint, n, n2);
            }
            graphics2D.setPaint(paint);
            graphics2D.fill(shape);
        }
        if (this.getAreaEffects() != null) {
            for (AreaEffect object : this.getAreaEffects()) {
                object.apply(graphics2D, shape, n, n2);
            }
        }
        if (this.img != null) {
            int n3 = this.img.getWidth(null);
            int n4 = this.img.getHeight(null);
            if (n3 != -1 && n4 != -1) {
                Rectangle rectangle = this.calculateLayout(n3, n4, n, n2);
                if (this.verticalRepeat || this.horizontalRepeat) {
                    Shape n5 = graphics2D.getClip();
                    Shape shape2 = graphics2D.getClip();
                    if (shape2 == null) {
                        shape2 = new Rectangle(0, 0, n, n2);
                    }
                    Area area = new Area(shape2);
                    TexturePaint texturePaint = new TexturePaint(this.img, rectangle);
                    if (this.verticalRepeat && this.horizontalRepeat) {
                        area.intersect(new Area(new Rectangle(0, 0, n, n2)));
                        graphics2D.setClip(area);
                    } else if (this.verticalRepeat) {
                        area.intersect(new Area(new Rectangle(rectangle.x, 0, rectangle.width, n2)));
                        graphics2D.setClip(area);
                    } else {
                        area.intersect(new Area(new Rectangle(0, rectangle.y, n, rectangle.height)));
                        graphics2D.setClip(area);
                    }
                    graphics2D.setPaint(texturePaint);
                    graphics2D.fillRect(0, 0, n, n2);
                    graphics2D.setClip(n5);
                } else if (this.scaleToFit) {
                    int n5;
                    int n6;
                    float f;
                    int n9 = n3;
                    int n7 = n4;
                    if (this.scaleType == ScaleType.InsideFit) {
                        int n8;
                        if (n9 > n) {
                            f = (float)n / (float)n9;
                            n8 = (int)((float)n9 * f);
                            n7 = (int)((float)n7 * f);
                        }
                        if (n7 > n2) {
                            f = (float)n2 / (float)n7;
                            n6 = (int)((float)n8 * f);
                            n7 = (int)((float)n7 * f);
                        }
                    }
                    if (this.scaleType == ScaleType.OutsideFit) {
                        int n10;
                        if (n6 > n) {
                            f = (float)n / (float)n6;
                            n10 = (int)((float)n6 * f);
                            n7 = (int)((float)n7 * f);
                        }
                        if (n7 < n2) {
                            f = (float)n2 / (float)n7;
                            int n11 = (int)((float)n10 * f);
                            n7 = (int)((float)n7 * f);
                        }
                    }
                    if (this.scaleType == ScaleType.Distort) {
                        n5 = n;
                        n7 = n2;
                    }
                    int n12 = 0;
                    int n13 = 0;
                    switch (this.getHorizontalAlignment()) {
                        case CENTER: {
                            n12 = n / 2 - n5 / 2;
                            break;
                        }
                        case RIGHT: {
                            n12 = n - n5;
                        }
                    }
                    switch (this.getVerticalAlignment()) {
                        case CENTER: {
                            n13 = n2 / 2 - n7 / 2;
                            break;
                        }
                        case BOTTOM: {
                            n13 = n2 - n7;
                        }
                    }
                    graphics2D.drawImage(this.img, n12, n13, n5, n7, null);
                } else {
                    int n14;
                    int n15 = rectangle.width;
                    int n16 = rectangle.height;
                    if (this.imageScale != 1.0) {
                        n14 = (int)((double)n15 * this.imageScale);
                        n16 = (int)((double)n16 * this.imageScale);
                    }
                    graphics2D.drawImage(this.img, rectangle.x, rectangle.y, n14, n16, null);
                }
            }
        }
    }

    private void drawBorder(Graphics2D graphics2D, Shape shape, int n, int n2) {
        if (this.getBorderPaint() != null) {
            graphics2D.setPaint(this.getBorderPaint());
            graphics2D.setStroke(new BasicStroke(this.getBorderWidth()));
            graphics2D.draw(shape);
        }
    }

    public void setScaleToFit(boolean bl) {
        boolean bl2 = this.isScaleToFit();
        this.scaleToFit = bl;
        this.setDirty(true);
        this.firePropertyChange("scaleToFit", bl2, this.isScaleToFit());
    }

    public boolean isScaleToFit() {
        return this.scaleToFit;
    }

    public void setImageScale(double d) {
        double d2 = this.getImageScale();
        this.imageScale = d;
        this.setDirty(true);
        this.firePropertyChange("imageScale", d2, this.imageScale);
    }

    public double getImageScale() {
        return this.imageScale;
    }

    private void loadImage() {
        try {
            String string = this.getImageString();
            if (string != null) {
                URL uRL = new URL(string);
                this.setImage(ImageIO.read(uRL));
            }
        }
        catch (IOException iOException) {
            this.log.severe("ex: " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    public String getImageString() {
        return this.imageString;
    }

    public void setImageString(String string) {
        this.log.fine("setting image string to: " + string);
        String string2 = this.getImageString();
        this.imageString = string;
        this.loadImage();
        this.setDirty(true);
        this.firePropertyChange("imageString", string2, string);
    }

    public boolean isHorizontalRepeat() {
        return this.horizontalRepeat;
    }

    public void setHorizontalRepeat(boolean bl) {
        boolean bl2 = this.isHorizontalRepeat();
        this.horizontalRepeat = bl;
        this.setDirty(true);
        this.firePropertyChange("horizontalRepeat", bl2, this.horizontalRepeat);
    }

    public boolean isVerticalRepeat() {
        return this.verticalRepeat;
    }

    public void setVerticalRepeat(boolean bl) {
        boolean bl2 = this.isVerticalRepeat();
        this.verticalRepeat = bl;
        this.setDirty(true);
        this.firePropertyChange("verticalRepeat", bl2, this.verticalRepeat);
    }

    @Override
    protected Shape provideShape(Graphics2D graphics2D, Object object, int n, int n2) {
        if (this.getImage() != null) {
            BufferedImage bufferedImage = this.getImage();
            int n3 = bufferedImage.getWidth();
            int n4 = bufferedImage.getHeight();
            return this.calculateLayout(n3, n4, n, n2);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public ScaleType getScaleType() {
        return this.scaleType;
    }

    public void setScaleType(ScaleType scaleType) {
        ScaleType scaleType2 = this.getScaleType();
        this.scaleType = scaleType;
        this.setDirty(true);
        this.firePropertyChange("scaleType", (Object)scaleType2, (Object)this.getScaleType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScaleType {
        InsideFit,
        OutsideFit,
        Distort;

    }
}

