/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.effects.AreaEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RectanglePainter<T>
extends AbstractAreaPainter<T> {
    private boolean rounded = false;
    private int roundWidth = 20;
    private int roundHeight = 20;
    private int width = -1;
    private int height = -1;

    public RectanglePainter() {
        this(0, 0, 0, 0, 0, 0, false, Color.RED, 1.0f, Color.BLACK);
    }

    public RectanglePainter(Color color, Color color2) {
        this(0, 0, 0, 0, 0, 0, false, color, 1.0f, color2);
    }

    public RectanglePainter(Paint paint, Paint paint2, float f, AbstractAreaPainter.Style style) {
        this();
        this.setFillPaint(paint);
        this.setBorderPaint(paint2);
        this.setBorderWidth(f);
        this.setStyle(style);
    }

    public RectanglePainter(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0, 0, false, Color.RED, 1.0f, Color.BLACK);
    }

    public RectanglePainter(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4, n5, n6, true, Color.RED, 1.0f, Color.BLACK);
    }

    public RectanglePainter(int n, int n2, int n3, Paint paint) {
        this(new Insets(0, 0, 0, 0), n, n2, n3, n3, true, paint, 1.0f, Color.BLACK);
    }

    public RectanglePainter(Insets insets, int n, int n2, int n3, int n4, boolean bl, Paint paint, float f, Paint paint2) {
        this.width = n;
        this.height = n2;
        this.setFillHorizontal(false);
        this.setFillVertical(false);
        this.setInsets(insets);
        this.roundWidth = n3;
        this.roundHeight = n4;
        this.rounded = bl;
        this.setFillPaint(paint);
        this.setBorderWidth(f);
        this.setBorderPaint(paint2);
    }

    public RectanglePainter(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, Paint paint, float f, Paint paint2) {
        this.setInsets(new Insets(n, n2, n3, n4));
        this.setFillVertical(true);
        this.setFillHorizontal(true);
        this.roundWidth = n5;
        this.roundHeight = n6;
        this.rounded = bl;
        this.setFillPaint(paint);
        this.setBorderWidth(f);
        this.setBorderPaint(paint2);
    }

    public boolean isRounded() {
        return this.rounded;
    }

    public void setRounded(boolean bl) {
        boolean bl2 = this.isRounded();
        this.rounded = bl;
        this.setDirty(true);
        this.firePropertyChange("rounded", bl2, bl);
    }

    public int getRoundWidth() {
        return this.roundWidth;
    }

    public void setRoundWidth(int n) {
        int n2 = this.getRoundWidth();
        this.roundWidth = n;
        this.setDirty(true);
        this.firePropertyChange("roundWidth", n2, n);
    }

    public int getRoundHeight() {
        return this.roundHeight;
    }

    public void setRoundHeight(int n) {
        int n2 = this.getRoundHeight();
        this.roundHeight = n;
        this.setDirty(true);
        this.firePropertyChange("roundHeight", n2, n);
    }

    protected RectangularShape calculateShape(int n, int n2) {
        Insets insets = this.getInsets();
        int n3 = insets.left;
        int n4 = insets.top;
        Rectangle rectangle = this.calculateLayout(this.width, this.height, n, n2);
        if (this.width != -1 && !this.isFillHorizontal()) {
            n = this.width;
            n3 = rectangle.x;
        }
        if (this.height != -1 && !this.isFillVertical()) {
            n2 = this.height;
            n4 = rectangle.y;
        }
        if (this.isFillHorizontal()) {
            n = n - insets.left - insets.right;
        }
        if (this.isFillVertical()) {
            n2 = n2 - insets.top - insets.bottom;
        }
        RectangularShape rectangularShape = new Rectangle2D.Double(n3, n4, n, n2);
        if (this.rounded) {
            rectangularShape = new RoundRectangle2D.Double(n3, n4, n, n2, this.roundWidth, this.roundHeight);
        }
        return rectangularShape;
    }

    @Override
    protected void doPaint(Graphics2D graphics2D, T t, int n, int n2) {
        RectangularShape rectangularShape = this.calculateShape(n, n2);
        switch (this.getStyle()) {
            case BOTH: {
                this.drawBackground(graphics2D, rectangularShape, n, n2);
                this.drawBorder(graphics2D, rectangularShape, n, n2);
                break;
            }
            case FILLED: {
                this.drawBackground(graphics2D, rectangularShape, n, n2);
                break;
            }
            case OUTLINE: {
                this.drawBorder(graphics2D, rectangularShape, n, n2);
                break;
            }
        }
        GraphicsUtilities.mergeClip(graphics2D, rectangularShape);
    }

    private void drawBorder(Graphics2D graphics2D, RectangularShape rectangularShape, int n, int n2) {
        Paint paint = this.getBorderPaint();
        if (this.isPaintStretched()) {
            paint = this.calculateSnappedPaint(paint, n, n2);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(new BasicStroke(this.getBorderWidth()));
        if (rectangularShape instanceof Rectangle2D) {
            graphics2D.draw(new Rectangle2D.Double(rectangularShape.getX(), rectangularShape.getY(), rectangularShape.getWidth() - 1.0, rectangularShape.getHeight() - 1.0));
        } else if (rectangularShape instanceof RoundRectangle2D) {
            graphics2D.draw(new RoundRectangle2D.Double(rectangularShape.getX(), rectangularShape.getY(), rectangularShape.getWidth() - 1.0, rectangularShape.getHeight() - 1.0, ((RoundRectangle2D)rectangularShape).getArcWidth(), ((RoundRectangle2D)rectangularShape).getArcHeight()));
        } else {
            graphics2D.draw(rectangularShape);
        }
    }

    private void drawBackground(Graphics2D graphics2D, Shape shape, int n, int n2) {
        Paint paint = this.getFillPaint();
        if (this.isPaintStretched()) {
            paint = this.calculateSnappedPaint(paint, n, n2);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(shape);
        if (this.getAreaEffects() != null) {
            for (AreaEffect areaEffect : this.getAreaEffects()) {
                areaEffect.apply(graphics2D, shape, n, n2);
            }
        }
    }

    @Override
    public Shape provideShape(Graphics2D graphics2D, T t, int n, int n2) {
        return this.calculateShape(n, n2);
    }
}

