/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter.effects;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import org.jdesktop.swingx.painter.effects.AbstractAreaEffect;

public class NeonBorderEffect
extends AbstractAreaEffect {
    private Color edgeColor;
    private Color centerColor;
    private BorderPosition borderPosition = BorderPosition.Outside;

    public NeonBorderEffect() {
        this(Color.GREEN, Color.WHITE, 10);
    }

    public NeonBorderEffect(Color color, Color color2, int n) {
        this.setEffectWidth(n);
        this.setEdgeColor(color);
        this.setCenterColor(color2);
        this.setRenderInsideShape(false);
        this.setShouldFillShape(false);
        this.setOffset(new Point(0, 0));
    }

    protected void paintBorderGlow(Graphics2D graphics2D, Shape shape, int n, int n2) {
        graphics2D.translate(this.getOffset().getX(), this.getOffset().getY());
        graphics2D.setComposite(AlphaComposite.SrcOver);
        int n3 = this.getEffectWidth();
        if (this.borderPosition == BorderPosition.Centered) {
            n3 /= 2;
        }
        for (int i = 0; i < n3; ++i) {
            float f = n3 + 1 - i;
            float f2 = n3 / 2;
            if (this.borderPosition == BorderPosition.Centered) {
                graphics2D.setPaint(this.interpolateColor((float)(n3 - i) / (float)n3, this.getEdgeColor(), this.getCenterColor()));
            } else if ((float)i < f2) {
                graphics2D.setPaint(this.interpolateColor((f2 - (float)i) / f2, this.getEdgeColor(), this.getCenterColor()));
            } else {
                graphics2D.setPaint(this.interpolateColor(((float)i - f2) / f2, this.getEdgeColor(), this.getCenterColor()));
            }
            graphics2D.setStroke(new BasicStroke(f, 1, 1));
            graphics2D.draw(shape);
        }
        graphics2D.translate(-this.getOffset().getX(), -this.getOffset().getY());
    }

    protected Color interpolateColor(float f, Color color, Color color2) {
        float[] fArray = color.getRGBComponents(null);
        float[] fArray2 = color2.getRGBComponents(null);
        float[] fArray3 = new float[4];
        for (int i = 0; i < 4; ++i) {
            fArray3[i] = (fArray[i] - fArray2[i]) * f + fArray2[i];
        }
        return new Color(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color color) {
        this.edgeColor = color;
    }

    public Color getCenterColor() {
        return this.centerColor;
    }

    public void setCenterColor(Color color) {
        this.centerColor = color;
    }

    public BorderPosition getBorderPosition() {
        return this.borderPosition;
    }

    public void setBorderPosition(BorderPosition borderPosition) {
        this.borderPosition = borderPosition;
        switch (borderPosition) {
            case Centered: {
                this.setShapeMasked(false);
                break;
            }
            case Inside: {
                this.setShapeMasked(true);
                this.setRenderInsideShape(true);
                break;
            }
            case Outside: {
                this.setShapeMasked(true);
                this.setRenderInsideShape(false);
            }
        }
        if (borderPosition == BorderPosition.Centered) {
            // empty if block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BorderPosition {
        Inside,
        Centered,
        Outside;

    }
}

