/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.PainterHighlighter;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.basic.CalendarAdapter;
import org.jdesktop.swingx.plaf.basic.CalendarCellContext;
import org.jdesktop.swingx.plaf.basic.CalendarRenderingHandler;
import org.jdesktop.swingx.plaf.basic.CalendarState;
import org.jdesktop.swingx.plaf.basic.TextCrossingPainter;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.FormatStringValue;
import org.jdesktop.swingx.renderer.LabelProvider;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;

class BasicCalendarRenderingHandler
implements CalendarRenderingHandler {
    private CalendarCellContext cellContext;
    private Map<CalendarState, ComponentProvider<?>> providers;
    private TextCrossingPainter textCross;
    private Color unselectableDayForeground;
    private CalendarAdapter calendarAdapter;
    private CompoundHighlighter highlighter;

    public BasicCalendarRenderingHandler() {
        this.install();
    }

    private void install() {
        this.unselectableDayForeground = UIManagerExt.getColor("JXMonthView.unselectableDayForeground");
        this.textCross = new TextCrossingPainter();
        this.cellContext = new CalendarCellContext();
        this.installProviders();
    }

    private void installProviders() {
        this.providers = new HashMap();
        StringValue stringValue = this.createDayStringValue(null);
        LabelProvider labelProvider = new LabelProvider(stringValue, 4);
        this.providers.put(CalendarState.IN_MONTH, labelProvider);
        this.providers.put(CalendarState.TODAY, labelProvider);
        this.providers.put(CalendarState.TRAILING, labelProvider);
        this.providers.put(CalendarState.LEADING, labelProvider);
        StringValue stringValue2 = this.createWeekOfYearStringValue(null);
        LabelProvider labelProvider2 = new LabelProvider(stringValue2, 4);
        this.providers.put(CalendarState.WEEK_OF_YEAR, labelProvider2);
        LabelProvider labelProvider3 = new LabelProvider(0){

            protected String getValueAsString(CellContext cellContext) {
                Object object = cellContext.getValue();
                if (object instanceof Calendar) {
                    int n = ((Calendar)object).get(7);
                    return ((JXMonthView)cellContext.getComponent()).getDayOfTheWeek(n);
                }
                return super.getValueAsString(cellContext);
            }
        };
        this.providers.put(CalendarState.DAY_OF_WEEK, labelProvider3);
        StringValue stringValue3 = this.createMonthHeaderStringValue(null);
        LabelProvider labelProvider4 = new LabelProvider(stringValue3, 0);
        this.providers.put(CalendarState.TITLE, labelProvider4);
    }

    protected StringValue createMonthHeaderStringValue(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        final String[] stringArray = new DateFormatSymbols(locale).getMonths();
        StringValue stringValue = new StringValue(){

            public String getString(Object object) {
                if (object instanceof Calendar) {
                    String string = stringArray[((Calendar)object).get(2)];
                    return string + " " + ((Calendar)object).get(1);
                }
                return StringValues.TO_STRING.getString(object);
            }
        };
        return stringValue;
    }

    protected StringValue createWeekOfYearStringValue(Locale locale) {
        StringValue stringValue = new StringValue(){

            public String getString(Object object) {
                if (object instanceof Calendar) {
                    object = ((Calendar)object).get(3);
                }
                return StringValues.TO_STRING.getString(object);
            }
        };
        return stringValue;
    }

    protected StringValue createDayStringValue(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        FormatStringValue formatStringValue = new FormatStringValue(new SimpleDateFormat("d", locale)){

            public String getString(Object object) {
                if (object instanceof Calendar) {
                    ((DateFormat)this.getFormat()).setTimeZone(((Calendar)object).getTimeZone());
                    object = ((Calendar)object).getTime();
                }
                return super.getString(object);
            }
        };
        return formatStringValue;
    }

    public void setLocale(Locale locale) {
        StringValue stringValue = this.createDayStringValue(locale);
        this.providers.get((Object)CalendarState.IN_MONTH).setStringValue(stringValue);
        this.providers.get((Object)CalendarState.TODAY).setStringValue(stringValue);
        this.providers.get((Object)CalendarState.TRAILING).setStringValue(stringValue);
        this.providers.get((Object)CalendarState.LEADING).setStringValue(stringValue);
        this.providers.get((Object)CalendarState.WEEK_OF_YEAR).setStringValue(this.createWeekOfYearStringValue(locale));
        this.providers.get((Object)CalendarState.TITLE).setStringValue(this.createMonthHeaderStringValue(locale));
    }

    public JComponent prepareRenderingComponent(JXMonthView jXMonthView, Calendar calendar, CalendarState calendarState) {
        this.cellContext.installContext(jXMonthView, calendar, this.isSelected(jXMonthView, calendar, calendarState), this.isFocused(jXMonthView, calendar, calendarState), calendarState);
        Object obj = this.providers.get((Object)calendarState).getRendererComponent(this.cellContext);
        return this.highlight((JComponent)obj, jXMonthView, calendar, calendarState);
    }

    private JComponent highlight(JComponent jComponent, JXMonthView jXMonthView, Calendar calendar, CalendarState calendarState) {
        CalendarAdapter calendarAdapter = this.getCalendarAdapter(jXMonthView, calendar, calendarState);
        return (JComponent)this.getHighlighter().highlight(jComponent, calendarAdapter);
    }

    private Highlighter getHighlighter() {
        if (this.highlighter == null) {
            this.highlighter = new CompoundHighlighter(new Highlighter[0]);
            this.installHighlighters();
        }
        return this.highlighter;
    }

    private void installHighlighters() {
        HighlightPredicate highlightPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
                if (!(componentAdapter instanceof CalendarAdapter)) {
                    return false;
                }
                CalendarAdapter calendarAdapter = (CalendarAdapter)componentAdapter;
                return CalendarState.DAY_OF_WEEK == calendarAdapter.getCalendarState() || CalendarState.TITLE == calendarAdapter.getCalendarState();
            }
        };
        AbstractHighlighter abstractHighlighter = new AbstractHighlighter(highlightPredicate){

            protected Component doHighlight(Component component, ComponentAdapter componentAdapter) {
                component.setFont(BasicCalendarRenderingHandler.this.getDerivedFont(component.getFont()));
                return component;
            }
        };
        this.highlighter.addHighlighter(abstractHighlighter);
        HighlightPredicate highlightPredicate2 = new HighlightPredicate(){

            public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
                if (!(componentAdapter instanceof CalendarAdapter)) {
                    return false;
                }
                return ((CalendarAdapter)componentAdapter).isUnselectable();
            }
        };
        this.textCross.setForeground(this.unselectableDayForeground);
        PainterHighlighter painterHighlighter = new PainterHighlighter(highlightPredicate2, this.textCross);
        this.highlighter.addHighlighter(painterHighlighter);
    }

    private CalendarAdapter getCalendarAdapter(JXMonthView jXMonthView, Calendar calendar, CalendarState calendarState) {
        if (this.calendarAdapter == null) {
            this.calendarAdapter = new CalendarAdapter(jXMonthView);
        }
        return this.calendarAdapter.install(calendar, calendarState);
    }

    private Font getDerivedFont(Font font) {
        return font.deriveFont(1);
    }

    private boolean isFocused(JXMonthView jXMonthView, Calendar calendar, CalendarState calendarState) {
        return false;
    }

    private boolean isSelected(JXMonthView jXMonthView, Calendar calendar, CalendarState calendarState) {
        if (!this.isSelectable(calendarState)) {
            return false;
        }
        return jXMonthView.isSelected(calendar.getTime());
    }

    private boolean isSelectable(CalendarState calendarState) {
        return CalendarState.IN_MONTH == calendarState || CalendarState.TODAY == calendarState;
    }
}

