/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.View;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.calendar.CalendarUtils;
import org.jdesktop.swingx.calendar.DatePickerFormatter;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;
import org.jdesktop.swingx.plaf.DatePickerUI;

public class BasicDatePickerUI
extends DatePickerUI {
    private static final Logger LOG = Logger.getLogger(BasicDatePickerUI.class.getName());
    protected JXDatePicker datePicker;
    private JButton popupButton;
    private BasicDatePickerPopup popup;
    private Handler handler;
    protected PropertyChangeListener propertyChangeListener;
    private FocusListener focusListener;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;
    private ActionListener editorActionListener;
    private EditorCancelAction editorCancelAction;
    private PropertyChangeListener editorPropertyListener;
    private DateSelectionListener monthViewSelectionListener;
    private ActionListener monthViewActionListener;
    private PropertyChangeListener monthViewPropertyListener;
    private PopupRemover popupRemover;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDatePickerUI();
    }

    public void installUI(JComponent jComponent) {
        this.datePicker = (JXDatePicker)jComponent;
        this.datePicker.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.datePicker.setLayout(null);
        this.datePicker = null;
    }

    protected void installComponents() {
        Object object;
        JFormattedTextField jFormattedTextField = this.datePicker.getEditor();
        if (SwingXUtilities.isUIInstallable(jFormattedTextField)) {
            object = this.getCustomFormats(jFormattedTextField);
            this.datePicker.setEditor(this.createEditor());
            if (object != null) {
                this.datePicker.setFormats((DateFormat[])object);
            }
        }
        this.updateFromEditorChanged(null, false);
        this.popupButton = this.createPopupButton();
        if (this.popupButton != null) {
            object = new JComboBox();
            Object object2 = ((JComponent)object).getClientProperty("doNotCancelPopup");
            this.popupButton.putClientProperty("doNotCancelPopup", object2);
            this.datePicker.add(this.popupButton);
        }
        this.updateChildLocale(this.datePicker.getLocale());
    }

    private DateFormat[] getCustomFormats(JFormattedTextField jFormattedTextField) {
        JFormattedTextField.AbstractFormatter abstractFormatter;
        JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory;
        DateFormat[] dateFormatArray = null;
        if (jFormattedTextField != null && (abstractFormatterFactory = jFormattedTextField.getFormatterFactory()) != null && (abstractFormatter = abstractFormatterFactory.getFormatter(jFormattedTextField)) instanceof DatePickerFormatter && !(abstractFormatter instanceof UIResource)) {
            dateFormatArray = ((DatePickerFormatter)abstractFormatter).getFormats();
        }
        return dateFormatArray;
    }

    protected void uninstallComponents() {
        JFormattedTextField jFormattedTextField = this.datePicker.getEditor();
        if (jFormattedTextField != null) {
            this.datePicker.remove(jFormattedTextField);
        }
        if (this.popupButton != null) {
            this.datePicker.remove(this.popupButton);
            this.popupButton = null;
        }
    }

    protected void installDefaults() {
        boolean bl = Boolean.TRUE.equals(UIManager.get("JXDatePicker.forceZoomable"));
        if (bl) {
            this.datePicker.getMonthView().setZoomable(true);
        }
    }

    protected void uninstallDefaults() {
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.datePicker.getActionMap();
        actionMap.put("datePickerCancel", this.createCancelAction());
        actionMap.put("datePickerCommit", this.createCommitAction());
        actionMap.put("navigateHome", this.createHomeAction(false));
        actionMap.put("commitHome", this.createHomeAction(true));
        TogglePopupAction togglePopupAction = this.createTogglePopupAction();
        actionMap.put("TOGGLE_POPUP", togglePopupAction);
        InputMap inputMap = this.datePicker.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "datePickerCommit");
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "datePickerCancel");
        inputMap.put(KeyStroke.getKeyStroke("F5"), "commitHome");
        inputMap.put(KeyStroke.getKeyStroke("shift F5"), "navigateHome");
        inputMap.put(KeyStroke.getKeyStroke("alt DOWN"), "TOGGLE_POPUP");
        this.installLinkPanelKeyboardActions();
    }

    protected void uninstallKeyboardActions() {
        this.uninstallLinkPanelKeyboardActions(this.datePicker.getLinkPanel());
    }

    protected void installLinkPanelKeyboardActions() {
        if (this.datePicker.getLinkPanel() == null) {
            return;
        }
        ActionMap actionMap = this.datePicker.getLinkPanel().getActionMap();
        actionMap.put("commitHome", this.datePicker.getActionMap().get("commitHome"));
        actionMap.put("navigateHome", this.datePicker.getActionMap().get("navigateHome"));
        InputMap inputMap = this.datePicker.getLinkPanel().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("F5"), "commitHome");
        inputMap.put(KeyStroke.getKeyStroke("shift F5"), "navigateHome");
    }

    protected void uninstallLinkPanelKeyboardActions(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        ActionMap actionMap = jComponent.getActionMap();
        actionMap.remove("commitHome");
        actionMap.remove("navigateHome");
        InputMap inputMap = jComponent.getInputMap(2);
        inputMap.remove(KeyStroke.getKeyStroke("F5"));
        inputMap.remove(KeyStroke.getKeyStroke("shift F5"));
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.mouseListener = this.createMouseListener();
        this.mouseMotionListener = this.createMouseMotionListener();
        this.focusListener = this.createFocusListener();
        this.editorActionListener = this.createEditorActionListener();
        this.editorPropertyListener = this.createEditorPropertyListener();
        this.monthViewSelectionListener = this.createMonthViewSelectionListener();
        this.monthViewActionListener = this.createMonthViewActionListener();
        this.monthViewPropertyListener = this.createMonthViewPropertyListener();
        this.popupRemover = new PopupRemover();
        this.datePicker.addPropertyChangeListener(this.propertyChangeListener);
        this.datePicker.addFocusListener(this.focusListener);
        if (this.popupButton != null) {
            this.popupButton.addPropertyChangeListener(this.propertyChangeListener);
            this.popupButton.addMouseListener(this.mouseListener);
            this.popupButton.addMouseMotionListener(this.mouseMotionListener);
        }
        this.updateEditorListeners(null);
        this.updateFromMonthViewChanged(null);
    }

    protected void uninstallListeners() {
        this.datePicker.removePropertyChangeListener(this.propertyChangeListener);
        this.datePicker.removeFocusListener(this.focusListener);
        this.datePicker.getMonthView().getSelectionModel().removeDateSelectionListener(this.monthViewSelectionListener);
        this.datePicker.getMonthView().removeActionListener(this.monthViewActionListener);
        this.datePicker.getMonthView().removePropertyChangeListener(this.propertyChangeListener);
        if (this.datePicker.getEditor() != null) {
            this.uninstallEditorListeners(this.datePicker.getEditor());
        }
        if (this.popupButton != null) {
            this.popupButton.removePropertyChangeListener(this.propertyChangeListener);
            this.popupButton.removeMouseListener(this.mouseListener);
            this.popupButton.removeMouseMotionListener(this.mouseMotionListener);
        }
        this.popupRemover.unload();
        this.popupRemover = null;
        this.propertyChangeListener = null;
        this.mouseListener = null;
        this.mouseMotionListener = null;
        this.editorActionListener = null;
        this.editorPropertyListener = null;
        this.monthViewSelectionListener = null;
        this.monthViewActionListener = null;
        this.monthViewPropertyListener = null;
        this.handler = null;
    }

    protected void updateMonthViewListeners(JXMonthView jXMonthView) {
        DateSelectionModel dateSelectionModel = null;
        if (jXMonthView != null) {
            jXMonthView.removePropertyChangeListener(this.monthViewPropertyListener);
            jXMonthView.removeActionListener(this.monthViewActionListener);
            dateSelectionModel = jXMonthView.getSelectionModel();
        }
        this.datePicker.getMonthView().addPropertyChangeListener(this.monthViewPropertyListener);
        this.datePicker.getMonthView().addActionListener(this.monthViewActionListener);
        this.updateSelectionModelListeners(dateSelectionModel);
    }

    protected void updateEditorListeners(JFormattedTextField jFormattedTextField) {
        if (jFormattedTextField != null) {
            this.uninstallEditorListeners(jFormattedTextField);
        }
        this.datePicker.getEditor().addPropertyChangeListener(this.editorPropertyListener);
        this.datePicker.getEditor().addActionListener(this.editorActionListener);
        this.datePicker.getEditor().addFocusListener(this.focusListener);
        this.editorCancelAction = new EditorCancelAction(this.datePicker.getEditor());
    }

    private void uninstallEditorListeners(JFormattedTextField jFormattedTextField) {
        jFormattedTextField.removePropertyChangeListener(this.editorPropertyListener);
        jFormattedTextField.removeActionListener(this.editorActionListener);
        jFormattedTextField.removeFocusListener(this.focusListener);
        if (this.editorCancelAction != null) {
            this.editorCancelAction.uninstall();
            this.editorCancelAction = null;
        }
    }

    protected void updateSelectionModelListeners(DateSelectionModel dateSelectionModel) {
        if (dateSelectionModel != null) {
            dateSelectionModel.removeDateSelectionListener(this.monthViewSelectionListener);
        }
        this.datePicker.getMonthView().getSelectionModel().addDateSelectionListener(this.monthViewSelectionListener);
    }

    protected JFormattedTextField createEditor() {
        DefaultEditor defaultEditor = new DefaultEditor(new DatePickerFormatter.DatePickerFormatterUIResource(this.datePicker.getLocale()));
        defaultEditor.setName("dateField");
        Border border = UIManager.getBorder("JXDatePicker.border");
        if (border != null) {
            defaultEditor.setBorder(border);
        }
        return defaultEditor;
    }

    protected JButton createPopupButton() {
        JButton jButton = new JButton();
        jButton.setName("popupButton");
        jButton.setRolloverEnabled(false);
        jButton.setMargin(new Insets(0, 3, 0, 3));
        Icon icon = UIManager.getIcon("JXDatePicker.arrowIcon");
        if (icon == null) {
            icon = (Icon)UIManager.get("Tree.expandedIcon");
        }
        jButton.setIcon(icon);
        jButton.setFocusable(false);
        return jButton;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this.getEditorPreferredSize();
        if (this.popupButton != null) {
            dimension.width += this.popupButton.getPreferredSize().width;
        }
        Insets insets = this.datePicker.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return (Dimension)dimension.clone();
    }

    private Dimension getEditorPreferredSize() {
        Dimension dimension = this.datePicker.getEditor().getPreferredSize();
        if (this.datePicker.getDate() == null) {
            // empty if block
        }
        return dimension;
    }

    public int getBaseline(int n, int n2) {
        JFormattedTextField jFormattedTextField = this.datePicker.getEditor();
        View view = jFormattedTextField.getUI().getRootView(jFormattedTextField);
        if (view.getViewCount() > 0) {
            Insets insets = jFormattedTextField.getInsets();
            Insets insets2 = this.datePicker.getInsets();
            int n3 = n2 - insets.top - insets.bottom - insets2.top - insets2.bottom;
            int n4 = insets.top + insets2.top;
            View view2 = view.getView(0);
            int n5 = (int)view2.getPreferredSpan(1);
            if (n3 != n5) {
                int n6 = n3 - n5;
                n4 += n6 / 2;
            }
            FontMetrics fontMetrics = jFormattedTextField.getFontMetrics(jFormattedTextField.getFont());
            return n4 += fontMetrics.getAscent();
        }
        return -1;
    }

    public Date getSelectableDate(Date date) throws PropertyVetoException {
        Date date2;
        Date date3 = date2 = date == null ? null : this.datePicker.getMonthView().getSelectionModel().getNormalizedDate(date);
        if (CalendarUtils.areEqual(date2, this.datePicker.getDate())) {
            throw new PropertyVetoException("date not selectable", null);
        }
        if (date2 == null) {
            return date2;
        }
        if (this.datePicker.getMonthView().isUnselectableDate(date2)) {
            throw new PropertyVetoException("date not selectable", null);
        }
        return date2;
    }

    protected void updateFromDateChanged() {
        Date date = this.datePicker.getDate() != null ? this.datePicker.getDate() : this.datePicker.getLinkDay();
        this.datePicker.getMonthView().ensureDateVisible(date);
        this.datePicker.getEditor().setValue(this.datePicker.getDate());
    }

    protected void updateFromValueChanged(Date date, Date date2) {
        if (date2 != null && this.datePicker.getMonthView().isUnselectableDate(date2)) {
            this.revertValue(date);
            return;
        }
        if (!CalendarUtils.areEqual(date2, this.datePicker.getMonthView().getSelectionDate())) {
            this.datePicker.getMonthView().setSelectionDate(date2);
        }
        this.datePicker.setDate(date2);
    }

    private void revertValue(Date date) {
        this.datePicker.getEditor().setValue(date);
    }

    protected void updateFromSelectionChanged(DateSelectionEvent.EventType eventType, boolean bl) {
        if (bl) {
            return;
        }
        this.updateEditorValue();
    }

    protected void updateFromMonthViewChanged(JXMonthView jXMonthView) {
        this.popup = null;
        this.updateMonthViewListeners(jXMonthView);
        TimeZone timeZone = null;
        if (jXMonthView != null) {
            jXMonthView.setComponentInputMapEnabled(false);
            timeZone = jXMonthView.getTimeZone();
        }
        this.datePicker.getMonthView().setComponentInputMapEnabled(true);
        this.updateTimeZone(timeZone);
        this.updateEditorValue();
    }

    protected void updateFromEditorChanged(JFormattedTextField jFormattedTextField, boolean bl) {
        if (jFormattedTextField != null) {
            this.datePicker.remove(jFormattedTextField);
            jFormattedTextField.putClientProperty("doNotCancelPopup", null);
        }
        this.datePicker.add(this.datePicker.getEditor());
        JComboBox jComboBox = new JComboBox();
        Object object = jComboBox.getClientProperty("doNotCancelPopup");
        this.datePicker.getEditor().putClientProperty("doNotCancelPopup", object);
        this.updateEditorValue();
        if (bl) {
            this.updateEditorListeners(jFormattedTextField);
            this.datePicker.revalidate();
        }
    }

    protected void updateFromSelectionModelChanged(DateSelectionModel dateSelectionModel) {
        this.updateSelectionModelListeners(dateSelectionModel);
        this.updateEditorValue();
    }

    private void updateEditorValue() {
        this.datePicker.getEditor().setValue(this.datePicker.getMonthView().getSelectionDate());
    }

    protected void updateFromEditableChanged() {
        boolean bl = this.datePicker.isEditable();
        this.datePicker.getMonthView().setEnabled(bl);
        this.datePicker.getEditor().setEditable(bl);
        this.setActionEnabled("commitHome", bl);
        this.setActionEnabled("navigateHome", bl);
    }

    private void setActionEnabled(String string, boolean bl) {
        Action action = this.datePicker.getActionMap().get(string);
        if (action != null) {
            action.setEnabled(bl);
        }
    }

    protected void updateFormatsFromTimeZone(TimeZone timeZone) {
        for (DateFormat dateFormat : this.datePicker.getFormats()) {
            dateFormat.setTimeZone(timeZone);
        }
    }

    protected void updateTimeZone(TimeZone timeZone) {
        this.updateFormatsFromTimeZone(this.datePicker.getTimeZone());
        this.updateLinkDate();
    }

    protected void updateLinkDate() {
        this.datePicker.setLinkDay(this.datePicker.getMonthView().getToday());
    }

    protected void updateLocale() {
        Locale locale = this.datePicker.getLocale();
        this.updateFormatLocale(locale);
        this.updateChildLocale(locale);
    }

    private void updateFormatLocale(Locale locale) {
        if (locale != null && this.getCustomFormats(this.datePicker.getEditor()) == null) {
            this.datePicker.getEditor().setFormatterFactory(new DefaultFormatterFactory(new DatePickerFormatter.DatePickerFormatterUIResource(locale)));
        }
    }

    private void updateChildLocale(Locale locale) {
        if (locale != null) {
            this.datePicker.getEditor().setLocale(locale);
            this.datePicker.getLinkPanel().setLocale(locale);
            this.datePicker.getMonthView().setLocale(locale);
        }
    }

    protected void updateLinkPanel(JComponent jComponent) {
        if (jComponent != null) {
            this.uninstallLinkPanelKeyboardActions(jComponent);
        }
        this.installLinkPanelKeyboardActions();
        if (this.popup != null) {
            this.popup.updateLinkPanel(jComponent);
        }
    }

    protected void commit() {
        this.hidePopup();
        try {
            this.datePicker.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    protected void cancel() {
        this.hidePopup();
        this.datePicker.cancelEdit();
    }

    public void hidePopup() {
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
    }

    public boolean isPopupVisible() {
        if (this.popup != null) {
            return this.popup.isVisible();
        }
        return false;
    }

    protected void home(boolean bl) {
        if (bl) {
            Calendar calendar = this.datePicker.getMonthView().getCalendar();
            calendar.setTime(this.datePicker.getLinkDay());
            this.datePicker.getMonthView().setSelectionDate(calendar.getTime());
            this.datePicker.getMonthView().commitSelection();
        } else {
            this.datePicker.getMonthView().ensureDateVisible(this.datePicker.getLinkDay());
        }
    }

    private Action createCommitAction() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicDatePickerUI.this.commit();
            }
        };
        return abstractAction;
    }

    private Action createCancelAction() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicDatePickerUI.this.cancel();
            }
        };
        return abstractAction;
    }

    private Action createHomeAction(final boolean bl) {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicDatePickerUI.this.home(bl);
            }
        };
        return abstractAction;
    }

    protected TogglePopupAction createTogglePopupAction() {
        return new TogglePopupAction();
    }

    public void toggleShowPopup() {
        if (this.popup == null) {
            this.popup = this.createMonthViewPopup();
        }
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        } else {
            this.datePicker.getEditor().requestFocusInWindow();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BasicDatePickerUI.this.popup.show(BasicDatePickerUI.this.datePicker, 0, BasicDatePickerUI.this.datePicker.getHeight());
                }
            });
        }
    }

    private BasicDatePickerPopup createMonthViewPopup() {
        BasicDatePickerPopup basicDatePickerPopup = new BasicDatePickerPopup();
        basicDatePickerPopup.setLightWeightPopupEnabled(this.datePicker.isLightWeightPopupEnabled());
        return basicDatePickerPopup;
    }

    protected PropertyChangeListener createMonthViewPropertyListener() {
        return this.getHandler();
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    protected ActionListener createEditorActionListener() {
        return this.getHandler();
    }

    protected ActionListener createMonthViewActionListener() {
        return this.getHandler();
    }

    protected DateSelectionListener createMonthViewSelectionListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createEditorPropertyListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected LayoutManager createLayoutManager() {
        return this.getHandler();
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.getHandler();
    }

    public class PopupRemover
    implements PropertyChangeListener {
        private KeyboardFocusManager manager;
        private boolean loaded;

        public void load() {
            if (this.manager != KeyboardFocusManager.getCurrentKeyboardFocusManager()) {
                this.unload();
                this.manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            }
            if (!this.loaded) {
                this.manager.addPropertyChangeListener("permanentFocusOwner", this);
                this.loaded = true;
            }
        }

        private void unload(boolean bl) {
            if (this.manager != null) {
                this.manager.removePropertyChangeListener("permanentFocusOwner", this);
                if (bl) {
                    this.manager = null;
                }
            }
            this.loaded = false;
        }

        public void unload() {
            this.unload(true);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!BasicDatePickerUI.this.isPopupVisible()) {
                this.unload(false);
                return;
            }
            Component component = this.manager.getPermanentFocusOwner();
            if (component != null && !SwingXUtilities.isDescendingFrom(component, BasicDatePickerUI.this.datePicker)) {
                this.unload(false);
                BasicDatePickerUI.this.hidePopup();
                component.requestFocusInWindow();
            }
        }
    }

    private class Handler
    implements LayoutManager,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    DateSelectionListener,
    ActionListener,
    FocusListener {
        private boolean _forwardReleaseEvent = false;

        private Handler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicDatePickerUI.this.datePicker.isEnabled()) {
                return;
            }
            BasicDatePickerUI.this.toggleShowPopup();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!BasicDatePickerUI.this.datePicker.isEnabled() || !BasicDatePickerUI.this.datePicker.isEditable()) {
                return;
            }
            if (this._forwardReleaseEvent) {
                JXMonthView jXMonthView = BasicDatePickerUI.this.datePicker.getMonthView();
                mouseEvent = SwingUtilities.convertMouseEvent(BasicDatePickerUI.this.popupButton, mouseEvent, jXMonthView);
                jXMonthView.dispatchEvent(mouseEvent);
                this._forwardReleaseEvent = false;
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!BasicDatePickerUI.this.datePicker.isEnabled() || !BasicDatePickerUI.this.datePicker.isEditable()) {
                return;
            }
            this._forwardReleaseEvent = true;
            if (!BasicDatePickerUI.this.popup.isShowing()) {
                return;
            }
            JXMonthView jXMonthView = BasicDatePickerUI.this.datePicker.getMonthView();
            mouseEvent = SwingUtilities.convertMouseEvent(BasicDatePickerUI.this.popupButton, mouseEvent, jXMonthView);
            jXMonthView.dispatchEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void valueChanged(DateSelectionEvent dateSelectionEvent) {
            BasicDatePickerUI.this.updateFromSelectionChanged(dateSelectionEvent.getEventType(), dateSelectionEvent.isAdjusting());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BasicDatePickerUI.this.datePicker) {
                this.datePickerPropertyChange(propertyChangeEvent);
            } else if (propertyChangeEvent.getSource() == BasicDatePickerUI.this.datePicker.getEditor()) {
                this.editorPropertyChange(propertyChangeEvent);
            } else if (propertyChangeEvent.getSource() == BasicDatePickerUI.this.datePicker.getMonthView()) {
                this.monthViewPropertyChange(propertyChangeEvent);
            } else if (propertyChangeEvent.getSource() == BasicDatePickerUI.this.popupButton) {
                this.buttonPropertyChange(propertyChangeEvent);
            } else if ("value".equals(propertyChangeEvent.getPropertyName())) {
                throw new IllegalStateException("editor listening is moved to dedicated propertyChangeLisener");
            }
        }

        private void editorPropertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("value".equals(propertyChangeEvent.getPropertyName())) {
                BasicDatePickerUI.this.updateFromValueChanged((Date)propertyChangeEvent.getOldValue(), (Date)propertyChangeEvent.getNewValue());
            }
        }

        private void datePickerPropertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("date".equals(string)) {
                BasicDatePickerUI.this.updateFromDateChanged();
            } else if ("enabled".equals(string)) {
                boolean bl = BasicDatePickerUI.this.datePicker.isEnabled();
                BasicDatePickerUI.this.popupButton.setEnabled(bl);
                BasicDatePickerUI.this.datePicker.getEditor().setEnabled(bl);
            } else if ("editable".equals(string)) {
                BasicDatePickerUI.this.updateFromEditableChanged();
            } else if ("ToolTipText".equals(string)) {
                String string2 = BasicDatePickerUI.this.datePicker.getToolTipText();
                BasicDatePickerUI.this.datePicker.getEditor().setToolTipText(string2);
                BasicDatePickerUI.this.popupButton.setToolTipText(string2);
            } else if ("monthView".equals(string)) {
                BasicDatePickerUI.this.updateFromMonthViewChanged((JXMonthView)propertyChangeEvent.getOldValue());
            } else if ("linkPanel".equals(string)) {
                BasicDatePickerUI.this.updateLinkPanel((JComponent)propertyChangeEvent.getOldValue());
            } else if ("editor".equals(string)) {
                BasicDatePickerUI.this.updateFromEditorChanged((JFormattedTextField)propertyChangeEvent.getOldValue(), true);
            } else if ("componentOrientation".equals(string)) {
                BasicDatePickerUI.this.datePicker.revalidate();
            } else if ("lightWeightPopupEnabled".equals(string)) {
                if (BasicDatePickerUI.this.popup != null) {
                    BasicDatePickerUI.this.popup.setVisible(false);
                }
                BasicDatePickerUI.this.popup = null;
            } else if ("formats".equals(string)) {
                BasicDatePickerUI.this.updateFormatsFromTimeZone(BasicDatePickerUI.this.datePicker.getTimeZone());
            } else if ("locale".equals(string)) {
                BasicDatePickerUI.this.updateLocale();
            }
        }

        private void monthViewPropertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
                BasicDatePickerUI.this.updateFromSelectionModelChanged((DateSelectionModel)propertyChangeEvent.getOldValue());
            } else if ("timeZone".equals(propertyChangeEvent.getPropertyName())) {
                BasicDatePickerUI.this.updateTimeZone((TimeZone)propertyChangeEvent.getOldValue());
            } else if ("today".equals(propertyChangeEvent.getPropertyName())) {
                BasicDatePickerUI.this.updateLinkDate();
            }
        }

        private void buttonPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return container.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return container.getMinimumSize();
        }

        public void layoutContainer(Container container) {
            Insets insets = BasicDatePickerUI.this.datePicker.getInsets();
            int n = BasicDatePickerUI.this.datePicker.getWidth() - insets.left - insets.right;
            int n2 = BasicDatePickerUI.this.datePicker.getHeight() - insets.top - insets.bottom;
            int n3 = BasicDatePickerUI.this.popupButton != null ? ((BasicDatePickerUI)BasicDatePickerUI.this).popupButton.getPreferredSize().width : 0;
            boolean bl = BasicDatePickerUI.this.datePicker.getComponentOrientation().isLeftToRight();
            BasicDatePickerUI.this.datePicker.getEditor().setBounds(bl ? insets.left : insets.left + n3, insets.top, n - n3, n2);
            if (BasicDatePickerUI.this.popupButton != null) {
                BasicDatePickerUI.this.popupButton.setBounds(bl ? n - n3 + insets.left : insets.left, insets.top, n3, n2);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent == null) {
                return;
            }
            if (actionEvent.getSource() == BasicDatePickerUI.this.datePicker.getMonthView()) {
                this.monthViewActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == BasicDatePickerUI.this.datePicker.getEditor()) {
                this.editorActionPerformed(actionEvent);
            }
        }

        private void editorActionPerformed(ActionEvent actionEvent) {
            BasicDatePickerUI.this.commit();
        }

        private void monthViewActionPerformed(ActionEvent actionEvent) {
            if ("monthViewCancel".equals(actionEvent.getActionCommand())) {
                BasicDatePickerUI.this.cancel();
            } else if ("monthViewCommit".equals(actionEvent.getActionCommand())) {
                BasicDatePickerUI.this.commit();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.isTemporary()) {
                return;
            }
            BasicDatePickerUI.this.popupRemover.load();
            if (focusEvent.getSource() == BasicDatePickerUI.this.datePicker) {
                BasicDatePickerUI.this.datePicker.getEditor().requestFocusInWindow();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    protected class BasicDatePickerPopup
    extends JPopupMenu {
        public BasicDatePickerPopup() {
            this.setLayout(new BorderLayout());
            this.add((Component)BasicDatePickerUI.this.datePicker.getMonthView(), "Center");
            this.updateLinkPanel(null);
        }

        public void updateLinkPanel(JComponent jComponent) {
            if (jComponent != null) {
                this.remove(jComponent);
            }
            if (BasicDatePickerUI.this.datePicker.getLinkPanel() != null) {
                this.add((Component)BasicDatePickerUI.this.datePicker.getLinkPanel(), "South");
            }
        }
    }

    private class TogglePopupAction
    extends AbstractAction {
        public TogglePopupAction() {
            super("TogglePopup");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicDatePickerUI.this.toggleShowPopup();
        }
    }

    public class EditorCancelAction
    extends AbstractAction {
        private JFormattedTextField editor;
        private Action cancelAction;
        public static final String TEXT_CANCEL_KEY = "reset-field-edit";

        public EditorCancelAction(JFormattedTextField jFormattedTextField) {
            this.install(jFormattedTextField);
        }

        public void uninstall() {
            this.editor.getActionMap().remove(TEXT_CANCEL_KEY);
            this.cancelAction = null;
            this.editor = null;
        }

        private void install(JFormattedTextField jFormattedTextField) {
            this.editor = jFormattedTextField;
            this.cancelAction = jFormattedTextField.getActionMap().get(TEXT_CANCEL_KEY);
            jFormattedTextField.getActionMap().put(TEXT_CANCEL_KEY, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.cancelAction.actionPerformed(null);
            BasicDatePickerUI.this.cancel();
        }
    }

    private class DefaultEditor
    extends JFormattedTextField
    implements UIResource {
        private Dimension prefSizeCache;
        private int prefEmptyInset;

        public DefaultEditor(JFormattedTextField.AbstractFormatter abstractFormatter) {
            super(abstractFormatter);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this.getColumns() <= 0) {
                if (this.getValue() == null) {
                    if (this.prefSizeCache != null) {
                        dimension.width = this.prefSizeCache.width;
                        dimension.height = this.prefSizeCache.height;
                    } else {
                        this.prefEmptyInset = dimension.width;
                        dimension.width = this.prefEmptyInset + this.getNullWidth();
                    }
                } else {
                    dimension.width += Math.max(this.prefEmptyInset, 4);
                    this.prefSizeCache = new Dimension(dimension);
                }
            }
            return dimension;
        }

        private int getNullWidth() {
            JFormattedTextField jFormattedTextField = new JFormattedTextField(this.getFormatter());
            jFormattedTextField.setMargin(this.getMargin());
            jFormattedTextField.setBorder(this.getBorder());
            jFormattedTextField.setFont(this.getFont());
            jFormattedTextField.setValue(new Date());
            return jFormattedTextField.getPreferredSize().width;
        }
    }
}

