/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.macosx;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorLevel;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.basic.BasicErrorPaneUI;

public class MacOSXErrorPaneUI
extends BasicErrorPaneUI {
    private JLabel titleLabel;
    private JEditorPane disclaimerText;

    protected void configureDetailsButton(boolean bl) {
        if (bl) {
            this.detailButton.setText(UIManagerExt.getString("JXErrorPane.details_contract_text", this.detailButton.getLocale()));
            this.detailButton.setIcon(UIManager.getIcon("Tree.expandedIcon"));
        } else {
            this.detailButton.setText(UIManagerExt.getString("JXErrorPane.details_expand_text", this.detailButton.getLocale()));
            this.detailButton.setIcon(UIManager.getIcon("Tree.collapsedIcon"));
        }
    }

    protected void configureReportAction(AbstractActionExt abstractActionExt) {
        abstractActionExt.setName(UIManagerExt.getString("JXErrorPane.report_button_text", this.pane.getLocale()));
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MacOSXErrorPaneUI();
    }

    public JFrame getErrorFrame(Component component) {
        JFrame jFrame = super.getErrorFrame(component);
        jFrame.setTitle(" ");
        return jFrame;
    }

    public JDialog getErrorDialog(Component component) {
        JDialog jDialog = super.getErrorDialog(component);
        jDialog.setTitle(" ");
        return jDialog;
    }

    public JInternalFrame getErrorInternalFrame(Component component) {
        JInternalFrame jInternalFrame = super.getErrorInternalFrame(component);
        jInternalFrame.setTitle(" ");
        return jInternalFrame;
    }

    protected LayoutManager createErrorPaneLayout() {
        this.createExtraComponents();
        GridBagLayout gridBagLayout = new GridBagLayout();
        try {
            gridBagLayout.addLayoutComponent(this.iconLabel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 17), 0, 0));
            gridBagLayout.addLayoutComponent(this.titleLabel, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 12, 0), 0, 0));
            gridBagLayout.addLayoutComponent(this.errorScrollPane, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 10, 0), 0, 0));
            gridBagLayout.addLayoutComponent(this.detailButton, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 6, 0), 0, 0));
            gridBagLayout.addLayoutComponent(this.detailsPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 6, 0), 0, 0));
            gridBagLayout.addLayoutComponent(this.disclaimerText, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 6, 0), 0, 0));
            gridBagLayout.addLayoutComponent(this.closeButton, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
            gridBagLayout.addLayoutComponent(this.reportButton, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return gridBagLayout;
    }

    protected LayoutManager createDetailPanelLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.addLayoutComponent(this.detailsScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.copyToClipboardButton.setVisible(false);
        return gridBagLayout;
    }

    protected void reinit() {
        super.reinit();
        ErrorInfo errorInfo = this.pane == null ? null : this.pane.getErrorInfo();
        this.titleLabel.setText(errorInfo == null ? "Unknown Error" : errorInfo.getTitle());
        Object object = this.pane.getClientProperty("fine-print");
        String string = object == null ? null : object.toString();
        this.disclaimerText.setText(string);
        this.disclaimerText.setVisible(string != null);
        if (errorInfo != null && errorInfo.getErrorLevel() == ErrorLevel.FATAL) {
            this.closeButton.setText(UIManagerExt.getString("JXErrorPane.fatal_button_text", this.closeButton.getLocale()));
        } else {
            this.closeButton.setText(UIManagerExt.getString("JXErrorPane.ok_button_text", this.closeButton.getLocale()));
        }
    }

    protected int getDetailsHeight() {
        return 150;
    }

    private void createExtraComponents() {
        this.titleLabel = new JLabel("Unknown Error");
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.pane.add(this.titleLabel);
        Font font = this.errorMessage.getFont();
        if (font != null) {
            this.errorMessage.setFont(font.deriveFont((float)font.getSize() - 2.0f));
        }
        this.disclaimerText = new JEditorPane();
        this.disclaimerText.setContentType("text/html");
        this.disclaimerText.setVisible(false);
        this.disclaimerText.setEditable(false);
        this.disclaimerText.setOpaque(false);
        this.disclaimerText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        if (font != null) {
            this.disclaimerText.setFont(font.deriveFont((float)font.getSize() - 2.0f));
        }
        this.pane.add(this.disclaimerText);
        this.detailButton.setBorderPainted(false);
        this.detailButton.setContentAreaFilled(false);
        this.detailButton.setBorder(BorderFactory.createEmptyBorder());
        this.detailButton.setMargin(new Insets(0, 0, 0, 0));
        this.detailButton.setIcon(UIManager.getIcon("Tree.collapsedIcon"));
        this.detailButton.setText(UIManagerExt.getString("JXErrorPane.details_expand_text", this.detailButton.getLocale()));
        this.closeButton.setText(UIManagerExt.getString("JXErrorPane.ok_button_text", this.closeButton.getLocale()));
    }
}

