/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.DefaultVisuals;
import org.jdesktop.swingx.renderer.IconValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentProvider<T extends JComponent>
implements Serializable {
    protected T rendererComponent;
    protected DefaultVisuals<T> defaultVisuals;
    protected int alignment;
    protected StringValue formatter;

    public ComponentProvider() {
        this(null, 10);
    }

    public ComponentProvider(StringValue stringValue) {
        this(stringValue, 10);
    }

    public ComponentProvider(StringValue stringValue, int n) {
        this.setHorizontalAlignment(n);
        this.setStringValue(stringValue);
        this.rendererComponent = this.createRendererComponent();
        this.defaultVisuals = this.createDefaultVisuals();
    }

    public T getRendererComponent(CellContext cellContext) {
        if (cellContext != null) {
            this.configureVisuals(cellContext);
            this.configureContent(cellContext);
        }
        return this.rendererComponent;
    }

    public void setHorizontalAlignment(int n) {
        this.alignment = n;
    }

    public int getHorizontalAlignment() {
        return this.alignment;
    }

    public void setStringValue(StringValue stringValue) {
        if (stringValue == null) {
            stringValue = StringValues.TO_STRING;
        }
        this.formatter = stringValue;
    }

    public StringValue getStringValue() {
        return this.formatter;
    }

    public String getString(Object object) {
        return this.formatter.getString(object);
    }

    protected String getValueAsString(CellContext cellContext) {
        Object object = cellContext.getValue();
        return this.formatter.getString(object);
    }

    protected Icon getValueAsIcon(CellContext cellContext) {
        Object object = cellContext.getValue();
        if (this.formatter instanceof IconValue) {
            return ((IconValue)((Object)this.formatter)).getIcon(object);
        }
        return null;
    }

    protected void configureVisuals(CellContext cellContext) {
        this.defaultVisuals.configureVisuals(this.rendererComponent, cellContext);
    }

    protected void configureContent(CellContext cellContext) {
        this.configureState(cellContext);
        this.format(cellContext);
    }

    protected abstract void format(CellContext var1);

    protected abstract void configureState(CellContext var1);

    protected abstract T createRendererComponent();

    protected DefaultVisuals<T> createDefaultVisuals() {
        return new DefaultVisuals();
    }

    protected DefaultVisuals<T> getDefaultVisuals() {
        return this.defaultVisuals;
    }
}

