/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.IconValue;
import org.jdesktop.swingx.renderer.LabelProvider;
import org.jdesktop.swingx.renderer.MappedValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.renderer.WrappingIconPanel;
import org.jdesktop.swingx.rollover.RolloverRenderer;
import org.jdesktop.swingx.treetable.TreeTableNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappingProvider
extends ComponentProvider<WrappingIconPanel>
implements RolloverRenderer {
    protected ComponentProvider wrappee;
    private boolean unwrapUserObject;

    public WrappingProvider() {
        this((ComponentProvider)null);
    }

    public WrappingProvider(IconValue iconValue, StringValue stringValue) {
        this(iconValue, stringValue, true);
    }

    public WrappingProvider(IconValue iconValue) {
        this(iconValue, null);
    }

    public WrappingProvider(StringValue stringValue) {
        this(null, stringValue);
    }

    public WrappingProvider(ComponentProvider componentProvider) {
        this(componentProvider, true);
    }

    public WrappingProvider(ComponentProvider componentProvider, boolean bl) {
        this(null, componentProvider, bl);
    }

    public WrappingProvider(IconValue iconValue, ComponentProvider componentProvider, boolean bl) {
        super(iconValue != null ? new MappedValue(null, iconValue) : StringValues.EMPTY);
        this.setWrappee(componentProvider);
        this.setUnwrapUserObject(bl);
    }

    public WrappingProvider(IconValue iconValue, StringValue stringValue, boolean bl) {
        this(iconValue, (ComponentProvider)null, bl);
        this.getWrappee().setStringValue(stringValue);
    }

    public void setWrappee(ComponentProvider componentProvider) {
        if (componentProvider == null) {
            componentProvider = new LabelProvider();
        }
        this.wrappee = componentProvider;
    }

    public ComponentProvider getWrappee() {
        return this.wrappee;
    }

    public void setUnwrapUserObject(boolean bl) {
        this.unwrapUserObject = bl;
    }

    public boolean getUnwrapUserObject() {
        return this.unwrapUserObject;
    }

    @Override
    public String getString(Object object) {
        object = this.getUnwrappedValue(object);
        return this.wrappee.getString(object);
    }

    protected Object getUnwrappedValue(Object object) {
        if (!this.getUnwrapUserObject()) {
            return object;
        }
        if (object instanceof DefaultMutableTreeNode) {
            object = ((DefaultMutableTreeNode)object).getUserObject();
        } else if (object instanceof TreeTableNode) {
            TreeTableNode treeTableNode = (TreeTableNode)object;
            object = treeTableNode.getUserObject();
        }
        return object;
    }

    @Override
    public WrappingIconPanel getRendererComponent(CellContext cellContext) {
        if (cellContext != null) {
            ((WrappingIconPanel)this.rendererComponent).setComponent((JComponent)this.wrappee.rendererComponent);
            Object object = this.adjustContextValue(cellContext);
            super.getRendererComponent(cellContext);
            this.wrappee.getRendererComponent(cellContext);
            this.restoreContextValue(cellContext, object);
            return (WrappingIconPanel)this.rendererComponent;
        }
        return (WrappingIconPanel)super.getRendererComponent(cellContext);
    }

    protected void restoreContextValue(CellContext cellContext, Object object) {
        cellContext.replaceValue(object);
    }

    protected Object adjustContextValue(CellContext cellContext) {
        Object object = cellContext.getValue();
        if (this.getUnwrapUserObject()) {
            cellContext.replaceValue(this.getUnwrappedValue(object));
        }
        return object;
    }

    @Override
    protected void configureState(CellContext cellContext) {
        ((WrappingIconPanel)this.rendererComponent).setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    protected WrappingIconPanel createRendererComponent() {
        return new WrappingIconPanel();
    }

    @Override
    protected void format(CellContext cellContext) {
        ((WrappingIconPanel)this.rendererComponent).setIcon(this.getValueAsIcon(cellContext));
    }

    @Override
    protected Icon getValueAsIcon(CellContext cellContext) {
        Icon icon = super.getValueAsIcon(cellContext);
        if (icon == null) {
            return cellContext.getIcon();
        }
        return IconValue.NULL_ICON == icon ? null : icon;
    }

    @Override
    public void doClick() {
        if (this.isEnabled()) {
            ((RolloverRenderer)((Object)this.wrappee)).doClick();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.wrappee instanceof RolloverRenderer && ((RolloverRenderer)((Object)this.wrappee)).isEnabled();
    }
}

