/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.rollover;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jdesktop.swingx.rollover.RolloverController;
import org.jdesktop.swingx.rollover.RolloverRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListRolloverController<T extends JList>
extends RolloverController<T> {
    private Cursor oldCursor;

    @Override
    protected void rollover(Point point, Point point2) {
        Rectangle rectangle;
        if (point != null && (rectangle = ((JList)this.component).getCellBounds(point.y, point.y)) != null) {
            ((JList)this.component).repaint(rectangle);
        }
        if (point2 != null && (rectangle = ((JList)this.component).getCellBounds(point2.y, point2.y)) != null) {
            ((JList)this.component).repaint(rectangle);
        }
        this.setRolloverCursor(point2);
    }

    private void setRolloverCursor(Point point) {
        if (this.hasRollover(point)) {
            if (this.oldCursor == null) {
                this.oldCursor = ((JList)this.component).getCursor();
                ((JList)this.component).setCursor(Cursor.getPredefinedCursor(12));
            }
        } else if (this.oldCursor != null) {
            ((JList)this.component).setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    @Override
    protected RolloverRenderer getRolloverRenderer(Point point, boolean bl) {
        RolloverRenderer rolloverRenderer;
        ListCellRenderer listCellRenderer = ((JList)this.component).getCellRenderer();
        RolloverRenderer rolloverRenderer2 = rolloverRenderer = listCellRenderer instanceof RolloverRenderer ? (RolloverRenderer)((Object)listCellRenderer) : null;
        if (rolloverRenderer != null && !rolloverRenderer.isEnabled()) {
            rolloverRenderer = null;
        }
        if (rolloverRenderer != null && bl) {
            Object e = ((JList)this.component).getModel().getElementAt(point.y);
            listCellRenderer.getListCellRendererComponent((JList)this.component, e, point.y, false, true);
        }
        return rolloverRenderer;
    }

    @Override
    protected Point getFocusedCell() {
        int n = ((JList)this.component).getLeadSelectionIndex();
        if (n < 0) {
            return null;
        }
        return new Point(0, n);
    }
}

