/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.rollover;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.rollover.RolloverController;
import org.jdesktop.swingx.rollover.RolloverRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeRolloverController<T extends JTree>
extends RolloverController<T> {
    private Cursor oldCursor;

    @Override
    protected void rollover(Point point, Point point2) {
        Rectangle rectangle;
        if (point != null && (rectangle = ((JTree)this.component).getRowBounds(point.y)) != null) {
            rectangle.x = 0;
            rectangle.width = ((JTree)this.component).getWidth();
            ((JTree)this.component).repaint(rectangle);
        }
        if (point2 != null && (rectangle = ((JTree)this.component).getRowBounds(point2.y)) != null) {
            rectangle.x = 0;
            rectangle.width = ((JTree)this.component).getWidth();
            ((JTree)this.component).repaint(rectangle);
        }
        this.setRolloverCursor(point2);
    }

    private void setRolloverCursor(Point point) {
        if (this.hasRollover(point)) {
            if (this.oldCursor == null) {
                this.oldCursor = ((JTree)this.component).getCursor();
                ((JTree)this.component).setCursor(Cursor.getPredefinedCursor(12));
            }
        } else if (this.oldCursor != null) {
            ((JTree)this.component).setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    @Override
    protected RolloverRenderer getRolloverRenderer(Point point, boolean bl) {
        RolloverRenderer rolloverRenderer;
        TreeCellRenderer treeCellRenderer = ((JTree)this.component).getCellRenderer();
        RolloverRenderer rolloverRenderer2 = rolloverRenderer = treeCellRenderer instanceof RolloverRenderer ? (RolloverRenderer)((Object)treeCellRenderer) : null;
        if (rolloverRenderer != null && !rolloverRenderer.isEnabled()) {
            rolloverRenderer = null;
        }
        if (rolloverRenderer != null && bl) {
            TreePath treePath = ((JTree)this.component).getPathForRow(point.y);
            Object object = treePath != null ? treePath.getLastPathComponent() : null;
            treeCellRenderer.getTreeCellRendererComponent((JTree)this.component, object, false, false, false, point.y, false);
        }
        return rolloverRenderer;
    }

    @Override
    protected Point getFocusedCell() {
        return null;
    }
}

