/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.sort;

import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortUtils {
    public static RowSorter.SortKey getFirstSortingKey(List<? extends RowSorter.SortKey> list) {
        for (RowSorter.SortKey sortKey : list) {
            if (!SortUtils.isSorted(sortKey.getSortOrder())) continue;
            return sortKey;
        }
        return null;
    }

    public static RowSorter.SortKey getFirstSortKeyForColumn(List<? extends RowSorter.SortKey> list, int n) {
        for (RowSorter.SortKey sortKey : list) {
            if (sortKey.getColumn() != n) continue;
            return sortKey;
        }
        return null;
    }

    public static RowSorter.SortKey removeFirstSortKeyForColumn(List<? extends RowSorter.SortKey> list, int n) {
        for (RowSorter.SortKey sortKey : list) {
            if (sortKey.getColumn() != n) continue;
            list.remove(sortKey);
            return sortKey;
        }
        return null;
    }

    public static boolean isSorted(SortOrder sortOrder) {
        return sortOrder != null && SortOrder.UNSORTED != sortOrder;
    }

    public static boolean isAscending(SortOrder sortOrder) {
        return sortOrder == SortOrder.ASCENDING;
    }

    public static boolean isSorted(SortOrder sortOrder, boolean bl) {
        return SortUtils.isSorted(sortOrder) && bl == SortUtils.isAscending(sortOrder);
    }
}

