/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTableColumnModelExt
extends DefaultTableColumnModel
implements TableColumnModelExt {
    private boolean isVisibilityChange;
    private List<TableColumn> initialColumns = new ArrayList<TableColumn>();
    private List<TableColumn> currentColumns = new ArrayList<TableColumn>();
    private VisibilityListener visibilityListener = new VisibilityListener();

    @Override
    public List<TableColumn> getColumns(boolean bl) {
        if (bl) {
            return new ArrayList<TableColumn>(this.initialColumns);
        }
        return Collections.list(this.getColumns());
    }

    @Override
    public int getColumnCount(boolean bl) {
        if (bl) {
            return this.initialColumns.size();
        }
        return this.getColumnCount();
    }

    @Override
    public TableColumnExt getColumnExt(Object object) {
        for (TableColumn tableColumn : this.initialColumns) {
            if (!(tableColumn instanceof TableColumnExt) || !object.equals(tableColumn.getIdentifier())) continue;
            return (TableColumnExt)tableColumn;
        }
        return null;
    }

    @Override
    public TableColumnExt getColumnExt(int n) {
        TableColumn tableColumn = this.getColumn(n);
        if (tableColumn instanceof TableColumnExt) {
            return (TableColumnExt)tableColumn;
        }
        return null;
    }

    public boolean isRemovedToInvisibleEvent(int n) {
        return this.isVisibilityChange;
    }

    public boolean isAddedFromInvisibleEvent(int n) {
        return this.isVisibilityChange;
    }

    @Override
    public void removeColumn(TableColumn tableColumn) {
        if (tableColumn instanceof TableColumnExt) {
            ((TableColumnExt)tableColumn).removePropertyChangeListener(this.visibilityListener);
        }
        this.currentColumns.remove(tableColumn);
        this.initialColumns.remove(tableColumn);
        super.removeColumn(tableColumn);
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        boolean bl = true;
        if (tableColumn instanceof TableColumnExt) {
            TableColumnExt tableColumnExt = (TableColumnExt)tableColumn;
            bl = tableColumnExt.isVisible();
            tableColumnExt.setVisible(true);
            tableColumnExt.addPropertyChangeListener(this.visibilityListener);
        }
        this.currentColumns.add(tableColumn);
        this.initialColumns.add(tableColumn);
        super.addColumn(tableColumn);
        if (tableColumn instanceof TableColumnExt) {
            ((TableColumnExt)tableColumn).setVisible(bl);
        }
    }

    @Override
    public void moveColumn(int n, int n2) {
        if (n != n2) {
            this.updateCurrentColumns(n, n2);
        }
        super.moveColumn(n, n2);
    }

    private void updateCurrentColumns(int n, int n2) {
        TableColumn tableColumn = (TableColumn)this.tableColumns.elementAt(n);
        int n3 = this.currentColumns.indexOf(tableColumn);
        TableColumn tableColumn2 = (TableColumn)this.tableColumns.elementAt(n2);
        int n4 = this.currentColumns.indexOf(tableColumn2);
        this.currentColumns.remove(n3);
        this.currentColumns.add(n4, tableColumn);
    }

    protected void moveToInvisible(TableColumnExt tableColumnExt) {
        this.isVisibilityChange = true;
        super.removeColumn(tableColumnExt);
        this.isVisibilityChange = false;
    }

    protected void moveToVisible(TableColumnExt tableColumnExt) {
        this.isVisibilityChange = true;
        super.addColumn(tableColumnExt);
        Integer n = this.currentColumns.indexOf(tableColumnExt);
        for (int i = 0; i < this.getColumnCount() - 1; ++i) {
            TableColumn tableColumn = this.getColumn(i);
            int n2 = this.currentColumns.indexOf(tableColumn);
            if (n2 <= n) continue;
            super.moveColumn(this.getColumnCount() - 1, i);
            break;
        }
        this.isVisibilityChange = false;
    }

    protected EventListenerList getEventListenerList() {
        return this.listenerList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        this.fireColumnPropertyChange(propertyChangeEvent);
    }

    protected void fireColumnPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableColumnModelExtListener.class) continue;
            ((TableColumnModelExtListener)objectArray[i + 1]).columnPropertyChange(propertyChangeEvent);
        }
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        super.addColumnModelListener(tableColumnModelListener);
        if (tableColumnModelListener instanceof TableColumnModelExtListener) {
            this.listenerList.add(TableColumnModelExtListener.class, (TableColumnModelExtListener)tableColumnModelListener);
        }
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        super.removeColumnModelListener(tableColumnModelListener);
        if (tableColumnModelListener instanceof TableColumnModelExtListener) {
            this.listenerList.remove(TableColumnModelExtListener.class, (TableColumnModelExtListener)tableColumnModelListener);
        }
    }

    public TableColumnModelExtListener[] getTableColumnModelExtListeners() {
        return (TableColumnModelExtListener[])this.listenerList.getListeners(TableColumnModelExtListener.class);
    }

    private class VisibilityListener
    implements PropertyChangeListener,
    Serializable {
        private VisibilityListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("visible".equals(propertyChangeEvent.getPropertyName())) {
                TableColumnExt tableColumnExt = (TableColumnExt)propertyChangeEvent.getSource();
                if (tableColumnExt.isVisible()) {
                    DefaultTableColumnModelExt.this.moveToVisible(tableColumnExt);
                    DefaultTableColumnModelExt.this.fireColumnPropertyChange(propertyChangeEvent);
                } else {
                    DefaultTableColumnModelExt.this.moveToInvisible(tableColumnExt);
                }
            } else if (!((TableColumnExt)propertyChangeEvent.getSource()).isVisible()) {
                DefaultTableColumnModelExt.this.fireColumnPropertyChange(propertyChangeEvent);
            }
        }
    }
}

