/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.tree;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import org.jdesktop.swingx.decorator.UIDependent;

public class DefaultXTreeCellEditor
extends DefaultTreeCellEditor
implements UIDependent {
    public DefaultXTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
        super(jTree, defaultTreeCellRenderer);
    }

    public DefaultXTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer, TreeCellEditor treeCellEditor) {
        super(jTree, defaultTreeCellRenderer, treeCellEditor);
    }

    public void setRenderer(DefaultTreeCellRenderer defaultTreeCellRenderer) {
        this.renderer = defaultTreeCellRenderer;
    }

    public DefaultTreeCellRenderer getRenderer() {
        return this.renderer;
    }

    protected Container createContainer() {
        return new XEditorContainer();
    }

    protected void prepareForEditing() {
        super.prepareForEditing();
        this.applyComponentOrientation();
    }

    protected void applyComponentOrientation() {
        if (this.tree != null) {
            this.editingContainer.applyComponentOrientation(this.tree.getComponentOrientation());
        }
    }

    private boolean isRightToLeft() {
        return this.tree != null && !this.tree.getComponentOrientation().isLeftToRight();
    }

    public void updateUI() {
        if (this.getRenderer() != null) {
            SwingUtilities.updateComponentTreeUI(this.getRenderer());
        }
        if (this.realEditor instanceof JComponent) {
            SwingUtilities.updateComponentTreeUI((JComponent)((Object)this.realEditor));
        } else if (this.realEditor instanceof UIDependent) {
            ((UIDependent)((Object)this.realEditor)).updateUI();
        }
    }

    public class XEditorContainer
    extends DefaultTreeCellEditor.EditorContainer {
        public XEditorContainer() {
            super(DefaultXTreeCellEditor.this);
        }

        public Dimension getPreferredSize() {
            if (DefaultXTreeCellEditor.this.isRightToLeft()) {
                if (DefaultXTreeCellEditor.this.editingComponent != null) {
                    Dimension dimension;
                    Dimension dimension2 = DefaultXTreeCellEditor.this.editingComponent.getPreferredSize();
                    dimension2.width += DefaultXTreeCellEditor.this.offset + 5;
                    Dimension dimension3 = dimension = DefaultXTreeCellEditor.this.renderer != null ? DefaultXTreeCellEditor.this.renderer.getPreferredSize() : null;
                    if (dimension != null) {
                        dimension2.height = Math.max(dimension2.height, dimension.height);
                    }
                    if (DefaultXTreeCellEditor.this.editingIcon != null) {
                        dimension2.height = Math.max(dimension2.height, DefaultXTreeCellEditor.this.editingIcon.getIconHeight());
                    }
                    return dimension2;
                }
                return new Dimension(0, 0);
            }
            return super.getPreferredSize();
        }

        public void doLayout() {
            if (DefaultXTreeCellEditor.this.isRightToLeft()) {
                Dimension dimension = this.getSize();
                DefaultXTreeCellEditor.this.editingComponent.getPreferredSize();
                DefaultXTreeCellEditor.this.editingComponent.setLocation(0, 0);
                DefaultXTreeCellEditor.this.editingComponent.setBounds(0, 0, dimension.width - DefaultXTreeCellEditor.this.offset, dimension.height);
            } else {
                super.doLayout();
            }
        }

        public void paint(Graphics graphics) {
            if (DefaultXTreeCellEditor.this.isRightToLeft()) {
                Dimension dimension = this.getSize();
                if (DefaultXTreeCellEditor.this.editingIcon != null) {
                    int n = Math.max(0, (dimension.height - DefaultXTreeCellEditor.this.editingIcon.getIconHeight()) / 2);
                    int n2 = Math.max(0, dimension.width - DefaultXTreeCellEditor.this.offset);
                    DefaultXTreeCellEditor.this.editingIcon.paintIcon(this, graphics, n2, n);
                }
                Icon icon = DefaultXTreeCellEditor.this.editingIcon;
                DefaultXTreeCellEditor.this.editingIcon = null;
                super.paint(graphics);
                DefaultXTreeCellEditor.this.editingIcon = icon;
            } else {
                super.paint(graphics);
            }
        }
    }
}

