/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableTreeTableNode
implements MutableTreeTableNode {
    protected MutableTreeTableNode parent;
    protected final List<MutableTreeTableNode> children;
    protected transient Object userObject;
    protected boolean allowsChildren;

    public AbstractMutableTreeTableNode() {
        this(null);
    }

    public AbstractMutableTreeTableNode(Object object) {
        this(object, true);
    }

    public AbstractMutableTreeTableNode(Object object, boolean bl) {
        this.userObject = object;
        this.allowsChildren = bl;
        this.children = this.createChildrenList();
    }

    protected List<MutableTreeTableNode> createChildrenList() {
        return new ArrayList<MutableTreeTableNode>();
    }

    public void add(MutableTreeTableNode mutableTreeTableNode) {
        this.insert(mutableTreeTableNode, this.getChildCount());
    }

    @Override
    public void insert(MutableTreeTableNode mutableTreeTableNode, int n) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("this node cannot accept children");
        }
        if (this.children.contains(mutableTreeTableNode)) {
            this.children.remove(mutableTreeTableNode);
            --n;
        }
        this.children.add(n, mutableTreeTableNode);
        if (mutableTreeTableNode.getParent() != this) {
            mutableTreeTableNode.setParent(this);
        }
    }

    @Override
    public void remove(int n) {
        this.children.remove(n).setParent(null);
    }

    @Override
    public void remove(MutableTreeTableNode mutableTreeTableNode) {
        this.children.remove(mutableTreeTableNode);
        mutableTreeTableNode.setParent(null);
    }

    @Override
    public void removeFromParent() {
        this.parent.remove(this);
    }

    @Override
    public void setParent(MutableTreeTableNode mutableTreeTableNode) {
        if (mutableTreeTableNode == null || mutableTreeTableNode.getAllowsChildren()) {
            if (this.parent != null && this.parent.getIndex(this) != -1) {
                this.parent.remove(this);
            }
        } else {
            throw new IllegalArgumentException("newParent does not allow children");
        }
        this.parent = mutableTreeTableNode;
        if (this.parent != null && this.parent.getIndex(this) == -1) {
            this.parent.insert(this, this.parent.getChildCount());
        }
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object object) {
        this.userObject = object;
    }

    @Override
    public TreeTableNode getChildAt(int n) {
        return this.children.get(n);
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.children.indexOf(treeNode);
    }

    @Override
    public TreeTableNode getParent() {
        return this.parent;
    }

    @Override
    public Enumeration<? extends MutableTreeTableNode> children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public void setAllowsChildren(boolean bl) {
        this.allowsChildren = bl;
        if (!this.allowsChildren) {
            this.children.clear();
        }
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public boolean isEditable(int n) {
        return false;
    }

    @Override
    public void setValueAt(Object object, int n) {
    }

    public String toString() {
        if (this.userObject == null) {
            return "";
        }
        return this.userObject.toString();
    }
}

