/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.io.File;
import java.util.Date;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.TreeTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFileSystemModel
implements TreeTableModel {
    protected EventListenerList listenerList;
    private static final Long ZERO = 0L;
    private File root;

    public SimpleFileSystemModel() {
        this(new File(File.separator));
    }

    public SimpleFileSystemModel(File file) {
        this.root = file;
        this.listenerList = new EventListenerList();
    }

    @Override
    public File getChild(Object object, int n) {
        File file;
        File[] fileArray;
        if (object instanceof File && (fileArray = (file = (File)object).listFiles()) != null) {
            return fileArray[n];
        }
        return null;
    }

    @Override
    public int getChildCount(Object object) {
        String[] stringArray;
        if (object instanceof File && (stringArray = ((File)object).list()) != null) {
            return stringArray.length;
        }
        return 0;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Long.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return Date.class;
            }
        }
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Size";
            }
            case 2: {
                return "Directory";
            }
            case 3: {
                return "Modification Date";
            }
        }
        return "Column " + n;
    }

    @Override
    public Object getValueAt(Object object, int n) {
        if (object instanceof File) {
            File file = (File)object;
            switch (n) {
                case 0: {
                    return file.getName();
                }
                case 1: {
                    return file.isFile() ? file.length() : ZERO.longValue();
                }
                case 2: {
                    return file.isDirectory();
                }
                case 3: {
                    return new Date(file.lastModified());
                }
            }
        }
        return null;
    }

    @Override
    public int getHierarchicalColumn() {
        return 0;
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        return false;
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object instanceof File && object2 instanceof File) {
            File file = (File)object;
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                if (!fileArray[i].equals(object2)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public File getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        if (object instanceof File) {
            return ((File)object).list() == null;
        }
        return true;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }
}

