/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import javax.swing.UIManager;

public class JVM {
    public static final int JDK1_0 = 10;
    public static final int JDK1_1 = 11;
    public static final int JDK1_2 = 12;
    public static final int JDK1_3 = 13;
    public static final int JDK1_4 = 14;
    public static final int JDK1_5 = 15;
    public static final int JDK1_6 = 16;
    public static final int JDK1_6N = 1610;
    public static final int JDK1_7 = 17;
    private static JVM current = new JVM();
    private int jdkVersion;

    public static JVM current() {
        return current;
    }

    public JVM() {
        this(System.getProperty("java.version"));
    }

    public JVM(String string) {
        if (string.startsWith("1.7.")) {
            this.jdkVersion = 17;
        } else if (string.startsWith("1.6.")) {
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                if (!"com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel".equals(lookAndFeelInfo.getClassName())) continue;
                this.jdkVersion = 1610;
                break;
            }
            this.jdkVersion = this.jdkVersion == 0 ? 16 : this.jdkVersion;
        } else {
            this.jdkVersion = string.startsWith("1.5.") ? 15 : (string.startsWith("1.4.") ? 14 : (string.startsWith("1.3.") ? 13 : (string.startsWith("1.2.") ? 12 : (string.startsWith("1.1.") ? 11 : (string.startsWith("1.0.") ? 10 : 13)))));
        }
    }

    public boolean isOrLater(int n) {
        return this.jdkVersion >= n;
    }

    public boolean isOneDotOne() {
        return this.jdkVersion == 11;
    }

    public boolean isOneDotTwo() {
        return this.jdkVersion == 12;
    }

    public boolean isOneDotThree() {
        return this.jdkVersion == 13;
    }

    public boolean isOneDotFour() {
        return this.jdkVersion == 14;
    }

    public boolean isOneDotFive() {
        return this.jdkVersion == 15;
    }

    public boolean isOneDotSix() {
        return this.jdkVersion == 16;
    }

    public boolean isOneDotSixUpdateN() {
        return this.jdkVersion == 1610;
    }

    public boolean isOneDotSeven() {
        return this.jdkVersion == 17;
    }
}

