/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseMenuItemUI;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class BaseCheckBoxMenuItemUI
extends BaseMenuItemUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseCheckBoxMenuItemUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(false);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.setOpaque(true);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.checkIcon = UIManager.getIcon("CheckBoxMenuItem.checkIcon");
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paintBackground(graphics, jComponent, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(graphics, jComponent);
    }

    protected void paintBackground(Graphics graphics, JComponent jComponent, int n, int n2, int n3, int n4) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
            graphics.setColor(AbstractLookAndFeel.getMenuSelectionBackgroundColor());
            graphics.fillRect(n, n2, n3, n4);
        } else if (!AbstractLookAndFeel.getTheme().isMenuOpaque()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, AbstractLookAndFeel.getTheme().getMenuAlpha());
            graphics2D.setComposite(alphaComposite);
            graphics.setColor(AbstractLookAndFeel.getMenuBackgroundColor());
            graphics.fillRect(n, n2, n3, n4);
            graphics2D.setComposite(composite);
        } else {
            graphics.setColor(AbstractLookAndFeel.getMenuBackgroundColor());
            graphics.fillRect(n, n2, n3, n4);
        }
        graphics.setColor(AbstractLookAndFeel.getMenuForegroundColor());
    }
}

