/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aero;

import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import com.jtattoo.plaf.aero.AeroLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.plaf.UIResource;

public class AeroIcons
extends BaseIcons {
    private static Icon iconIcon = null;
    private static Icon maxIcon = null;
    private static Icon minIcon = null;
    private static Icon closeIcon = null;
    private static Icon radioButtonIcon = null;
    private static Icon checkBoxIcon = null;

    public static Icon getIconIcon() {
        if (iconIcon == null) {
            iconIcon = new BaseIcons.IconSymbol(Color.black, Color.white, null, new Insets(2, 2, 2, 2));
        }
        return iconIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            minIcon = new BaseIcons.MinSymbol(Color.black, Color.white, null, new Insets(2, 2, 2, 2));
        }
        return minIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            maxIcon = new BaseIcons.MaxSymbol(Color.black, Color.white, null, new Insets(2, 2, 2, 2));
        }
        return maxIcon;
    }

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            closeIcon = new BaseIcons.CloseSymbol(Color.black, Color.white, null, new Insets(2, 2, 2, 2));
        }
        return closeIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static Icon radioIcon = new LazyImageIcon("icons/RadioSymbol.gif");
        private static final int WIDTH = 14;
        private static final int HEIGHT = 14;

        private RadioButtonIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 3;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            JRadioButton jRadioButton = (JRadioButton)component;
            ButtonModel buttonModel = jRadioButton.getModel();
            Color[] colorArray = null;
            colorArray = jRadioButton.isEnabled() ? (jRadioButton.isRolloverEnabled() && buttonModel.isRollover() ? AeroLookAndFeel.getTheme().getRolloverColors() : (JTattooUtilities.isFrameActive(jRadioButton) ? AeroLookAndFeel.getTheme().getButtonColors() : AeroLookAndFeel.getTheme().getInActiveColors())) : AeroLookAndFeel.getTheme().getDisabledColors();
            Shape shape = graphics.getClip();
            Area area = new Area(shape);
            Area area2 = new Area(new Ellipse2D.Double(n, n2, 15.0, 15.0));
            area2.intersect(area);
            graphics2D.setClip(area2);
            JTattooUtilities.fillHorGradient(graphics, colorArray, n, n2, 14, 14);
            graphics2D.setClip(shape);
            if (jRadioButton.isEnabled()) {
                graphics.setColor(AeroLookAndFeel.getFrameColor());
            } else {
                graphics.setColor(ColorHelper.brighter(AeroLookAndFeel.getFrameColor(), 20.0));
            }
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawOval(n, n2, 14, 14);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            if (buttonModel.isSelected()) {
                int n3 = n + (14 - radioIcon.getIconWidth()) / 2 + 1;
                int n4 = n2 + (14 - radioIcon.getIconHeight()) / 2 + 1;
                radioIcon.paintIcon(component, graphics, n3, n4);
            }
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 14;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static Icon checkIcon = new LazyImageIcon("icons/CheckSymbol.gif");
        private static Icon checkPressedIcon = new LazyImageIcon("icons/CheckPressedSymbol.gif");
        private static final int WIDTH = 15;
        private static final int HEIGHT = 15;

        private CheckBoxIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 3;
            }
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            Color[] colorArray = null;
            colorArray = jCheckBox.isEnabled() ? (jCheckBox.isRolloverEnabled() && buttonModel.isRollover() && !buttonModel.isArmed() ? AeroLookAndFeel.getTheme().getRolloverColors() : (JTattooUtilities.isFrameActive(jCheckBox) ? (buttonModel.isArmed() && buttonModel.isPressed() ? new Color[]{AeroLookAndFeel.getBackgroundColor()} : AeroLookAndFeel.getTheme().getButtonColors()) : AeroLookAndFeel.getTheme().getInActiveColors())) : AeroLookAndFeel.getTheme().getDisabledColors();
            JTattooUtilities.fillHorGradient(graphics, colorArray, n + 1, n2 + 1, 14, 14);
            if (jCheckBox.isEnabled()) {
                graphics.setColor(AeroLookAndFeel.getFrameColor());
            } else {
                graphics.setColor(ColorHelper.brighter(AeroLookAndFeel.getFrameColor(), 20.0));
            }
            graphics.drawRect(n, n2, 15, 15);
            if (jCheckBox.isEnabled() && !buttonModel.isRollover() && !buttonModel.isPressed()) {
                graphics.setColor(Color.white);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 15 - 2);
                graphics.drawLine(n + 15 - 1, n2 + 1, n + 15 - 1, n2 + 15 - 2);
            }
            int n3 = n + (15 - checkIcon.getIconWidth()) / 2 + 1;
            int n4 = n2 + (15 - checkIcon.getIconHeight()) / 2 + 1;
            if (buttonModel.isPressed()) {
                checkPressedIcon.paintIcon(component, graphics, n3, n4);
            } else if (buttonModel.isSelected()) {
                checkIcon.paintIcon(component, graphics, n3, n4);
            }
        }

        public int getIconWidth() {
            return 19;
        }

        public int getIconHeight() {
            return 15;
        }
    }
}

