/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aluminium;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class AluminiumTabbedPaneUI
extends BaseTabbedPaneUI {
    private static final Color[] TOP_SELECTED_TAB_COLORS = ColorHelper.createColorArr(new Color(204, 206, 202), new Color(220, 222, 218), 20);
    private static final Color[] BOTTOM_SELECTED_TAB_COLORS = ColorHelper.createColorArr(new Color(220, 222, 218), new Color(204, 206, 202), 20);

    public static ComponentUI createUI(JComponent jComponent) {
        return new AluminiumTabbedPaneUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.tabAreaInsets = new Insets(2, 6, 2, 6);
        this.contentBorderInsets = new Insets(2, 2, 2, 2);
    }

    protected Font getTabFont(boolean bl) {
        if (bl) {
            return super.getTabFont(bl).deriveFont(1);
        }
        return super.getTabFont(bl);
    }

    protected Color[] getTabColors(int n, boolean bl) {
        if (bl) {
            if (this.tabPane.getTabPlacement() == 3) {
                return BOTTOM_SELECTED_TAB_COLORS;
            }
            return TOP_SELECTED_TAB_COLORS;
        }
        return super.getTabColors(n, bl);
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = bl ? 1 : 0;
        super.paintTabBackground(graphics, n, n2, n3, n4, n5, n6 + n7, bl);
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        ColorUIResource colorUIResource = AbstractLookAndFeel.getControlDarkShadow();
        ColorUIResource colorUIResource2 = AbstractLookAndFeel.getControlHighlight();
        graphics.setColor(colorUIResource);
        switch (n) {
            case 1: {
                int n7 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                graphics.drawRect(n3, n4 + n7 - 1, n3 + n5 - 1, n6 - n7);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3 + 1, n4 + n7, n5 - 2, n4 + n7);
                graphics.drawLine(n3 + 1, n4 + n7, n3 + 1, n6 - 2);
                break;
            }
            case 2: {
                int n8 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                graphics.drawRect(n3 + n8 - 1, n4, n5 - n8, n4 + n6 - 1);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3 + n8, n4 + 1, n3 + n8, n6 - 2);
                graphics.drawLine(n3 + n8, n4 + 1, n5 - 2, n4 + 1);
                break;
            }
            case 3: {
                int n9 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                graphics.drawRect(n3, n4, n3 + n5 - 1, n6 - n9);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3 + 1, n4 + 1, n5 - 2, n4 + 1);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n6 - n9 - 1);
                break;
            }
            case 4: {
                int n10 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                graphics.drawRect(n3, n4, n5 - n10, n4 + n6 - 1);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n6 - 2);
                graphics.drawLine(n3 + 1, n4 + 1, n5 - n10 - 1, n4 + 1);
                break;
            }
        }
    }

    protected void paintScrollContentBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Insets insets = this.tabPane.getBorder().getBorderInsets(this.tabPane);
        ColorUIResource colorUIResource = AbstractLookAndFeel.getControlDarkShadow();
        ColorUIResource colorUIResource2 = AbstractLookAndFeel.getControlHighlight();
        graphics.setColor(colorUIResource);
        switch (n) {
            case 1: {
                int n7 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                graphics.drawLine(n3, n4 + n7 - 1 - insets.top, n5, n4 + n7 - 1 - insets.top);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3, n4 + n7 - insets.top, n5 - 1, n4 + n7 - insets.top);
                break;
            }
            case 2: {
                int n8 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                graphics.drawLine(n3 + n8 - 1 - insets.left, n4, n3 + n8 - 1 - insets.left, n6);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3 + n8 - insets.left, n4, n3 + n8 - insets.left, n6);
                break;
            }
            case 3: {
                int n9 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                graphics.drawLine(n3, n6 - n9 + insets.bottom, n5, n6 - n9 + insets.bottom);
                break;
            }
            case 4: {
                int n10 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                graphics.drawLine(n5 - n10 + insets.right, n4, n5 - n10 + insets.right, n6);
                break;
            }
        }
    }

    protected void paintRoundedTopTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = AbstractLookAndFeel.getControlDarkShadow();
        int n6 = 10;
        if (bl) {
            color = ColorHelper.darker(color, 20.0);
            graphics.setColor(ColorHelper.brighter(color, 20.0));
            graphics.drawLine(n2 + 5, n3, n4 - 5, n3);
            graphics.setColor(ColorHelper.brighter(color, 10.0));
            graphics.drawArc(n2, n3, n6, n6, 90, 90);
            graphics.setColor(ColorHelper.brighter(color, 10.0));
            graphics.drawArc(n4 - n6, n3, n6, n6, 0, 90);
            graphics.setColor(color);
            graphics.drawLine(n2, n3 + 5 + 1, n2, n5);
            graphics.setColor(color);
            graphics.drawLine(n4, n3 + 5 + 1, n4, n5);
        } else {
            graphics.setColor(color);
            graphics.drawLine(n2 + 5, n3, n4 - 5, n3);
            graphics.drawArc(n2, n3, n6, n6, 90, 90);
            graphics.drawArc(n4 - n6, n3, n6, n6, 0, 90);
            graphics.drawLine(n2, n3 + 5 + 1, n2, n5);
            graphics.drawLine(n4, n3 + 5 + 1, n4, n5);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    protected void paintRoundedBottomTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = AbstractLookAndFeel.getControlDarkShadow();
        if (bl) {
            color = ColorHelper.darker(color, 20.0);
        }
        int n6 = 10;
        graphics.setColor(color);
        graphics.drawLine(n2 + 5, n5, n4 - 5, n5);
        graphics.drawArc(n2, n5 - n6, n6, n6, 180, 90);
        graphics.drawArc(n4 - n6, n5 - n6, n6, n6, -90, 90);
        graphics.drawLine(n2, n3, n2, n5 - 5 - 1);
        graphics.drawLine(n4, n3, n4, n5 - 5 - 1);
        graphics.setColor(this.tabAreaBackground);
        graphics.drawLine(n2 + 1, n5 - 1, n2 + 1, n5 - 1);
        graphics.drawLine(n4 - 1, n5 - 1, n4 - 1, n5 - 1);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }
}

