/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.fast;

import com.jtattoo.plaf.BaseScrollBarUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.fast.FastLookAndFeel;
import com.jtattoo.plaf.fast.FastScrollButton;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class FastScrollBarUI
extends BaseScrollBarUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new FastScrollBarUI();
    }

    protected JButton createDecreaseButton(int n) {
        return new FastScrollButton(n, this.scrollBarWidth);
    }

    protected JButton createIncreaseButton(int n) {
        return new FastScrollButton(n, this.scrollBarWidth);
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.setColor(FastLookAndFeel.getControlColorLight());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (!jComponent.isEnabled()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        Color color = FastLookAndFeel.getTheme().getControlBackgroundColor();
        if (!JTattooUtilities.isActive(jComponent)) {
            color = ColorHelper.brighter(color, 50.0);
        }
        Color color2 = ColorHelper.brighter(color, 40.0);
        Color color3 = ColorHelper.darker(color, 30.0);
        if (this.scrollbar.getOrientation() == 1) {
            graphics.setColor(color);
            graphics.fillRect(1, 1, rectangle.width - 1, rectangle.height - 1);
            JTattooUtilities.draw3DBorder(graphics, ColorHelper.brighter(color3, 20.0), color3, 0, 0, rectangle.width, rectangle.height);
            JTattooUtilities.draw3DBorder(graphics, color2, color3, 1, 1, rectangle.width - 1, rectangle.height - 1);
        } else {
            graphics.setColor(color);
            graphics.fillRect(1, 1, rectangle.width - 1, rectangle.height - 1);
            JTattooUtilities.draw3DBorder(graphics, ColorHelper.brighter(color3, 20.0), color3, 0, 0, rectangle.width, rectangle.height);
            JTattooUtilities.draw3DBorder(graphics, color2, color3, 1, 1, rectangle.width - 1, rectangle.height - 1);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }
}

