/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.util.LayoutStyle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class ButtonBarBuilder
extends PanelBuilder {
    private static final ColumnSpec[] COL_SPECS = new ColumnSpec[0];
    private static final RowSpec[] ROW_SPECS = new RowSpec[]{RowSpec.decode("center:pref")};
    private static final String NARROW_KEY = "jgoodies.isNarrow";
    private boolean leftToRight = LayoutStyle.getCurrent().isLeftToRightButtonOrder();

    public ButtonBarBuilder() {
        this(new JPanel(null));
    }

    public ButtonBarBuilder(JPanel jPanel) {
        super(new FormLayout(COL_SPECS, ROW_SPECS), jPanel);
    }

    public static ButtonBarBuilder createLeftToRightBuilder() {
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.setLeftToRightButtonOrder(true);
        return buttonBarBuilder;
    }

    public boolean isLeftToRightButtonOrder() {
        return this.leftToRight;
    }

    public void setLeftToRightButtonOrder(boolean bl) {
        this.leftToRight = bl;
    }

    public void setDefaultButtonBarGapBorder() {
        this.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
    }

    public void addGriddedButtons(JButton[] jButtonArray) {
        int n = jButtonArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.leftToRight ? i : n - 1 - i;
            this.addGridded(jButtonArray[n2]);
            if (i >= jButtonArray.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addGriddedGrowingButtons(JButton[] jButtonArray) {
        int n = jButtonArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.leftToRight ? i : n - 1 - i;
            this.addGriddedGrowing(jButtonArray[n2]);
            if (i >= jButtonArray.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addFixed(JComponent jComponent) {
        this.getLayout().appendColumn(FormFactory.PREF_COLSPEC);
        this.add(jComponent);
        this.nextColumn();
    }

    public void addFixedNarrow(JComponent jComponent) {
        jComponent.putClientProperty(NARROW_KEY, Boolean.TRUE);
        this.addFixed(jComponent);
    }

    public void addGridded(JComponent jComponent) {
        this.getLayout().appendColumn(FormFactory.BUTTON_COLSPEC);
        this.getLayout().addGroupedColumn(this.getColumn());
        jComponent.putClientProperty(NARROW_KEY, Boolean.TRUE);
        this.add(jComponent);
        this.nextColumn();
    }

    public void addGriddedGrowing(JComponent jComponent) {
        this.getLayout().appendColumn(FormFactory.GROWING_BUTTON_COLSPEC);
        this.getLayout().addGroupedColumn(this.getColumn());
        jComponent.putClientProperty(NARROW_KEY, Boolean.TRUE);
        this.add(jComponent);
        this.nextColumn();
    }

    public void addGlue() {
        this.appendGlueColumn();
        this.nextColumn();
    }

    public void addRelatedGap() {
        this.appendRelatedComponentsGapColumn();
        this.nextColumn();
    }

    public void addUnrelatedGap() {
        this.appendUnrelatedComponentsGapColumn();
        this.nextColumn();
    }

    public void addStrut(ConstantSize constantSize) {
        this.getLayout().appendColumn(ColumnSpec.createGap(constantSize));
        this.nextColumn();
    }
}

