/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceTextUtilities;

public class SubstanceEditorPaneUI
extends BasicEditorPaneUI {
    protected FadeStateListener substanceFadeStateListener;
    protected JEditorPane editorPane;
    protected PropertyChangeListener substancePropertyChangeListener;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceEditorPaneUI(comp);
    }

    public SubstanceEditorPaneUI(JComponent c) {
        this.editorPane = (JEditorPane)c;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        super.installListeners();
        this.substanceFadeStateListener = new FadeStateListener(this.editorPane, null, null);
        this.substanceFadeStateListener.registerListeners(false);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int caretPos = SubstanceEditorPaneUI.this.editorPane.getCaretPosition();
                            SubstanceEditorPaneUI.this.editorPane.updateUI();
                            SubstanceEditorPaneUI.this.editorPane.setCaretPosition(caretPos);
                        }
                    });
                }
            }
        };
        this.editorPane.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.editorPane.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        Color foregr;
        super.installDefaults();
        Border b = this.editorPane.getBorder();
        if (b == null || b instanceof UIResource) {
            BorderUIResource.CompoundBorderUIResource newB = new BorderUIResource.CompoundBorderUIResource(new EmptyBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.editorPane))), new BasicBorders.MarginBorder());
            this.editorPane.setBorder(newB);
        }
        if ((foregr = this.editorPane.getForeground()) == null || foregr instanceof UIResource) {
            this.editorPane.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceLookAndFeel.getCurrentSkin(this.editorPane).getMainDefaultColorScheme()));
        }
    }

    @Override
    protected void paintBackground(Graphics g) {
        SubstanceTextUtilities.paintTextCompBackground(g, this.editorPane);
    }
}

