/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.painter.utils.SeparatorPainterUtils;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.menu.MenuUtilities;
import org.jvnet.substance.utils.menu.SubstanceMenuBackgroundDelegate;

public class SubstanceSeparatorUI
extends BasicSeparatorUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceSeparatorUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Container parent = c.getParent();
        if (!(parent instanceof JPopupMenu)) {
            SeparatorPainterUtils.paintSeparator(c, g, c.getWidth(), c.getHeight(), ((JSeparator)c).getOrientation());
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        int xOffset = MenuUtilities.getTextOffset(c, parent);
        SubstanceMenuBackgroundDelegate.paintBackground(graphics, c, xOffset);
        Dimension s = c.getSize();
        int startX = 0;
        int width = s.width;
        if (parent.getComponentOrientation().isLeftToRight()) {
            startX = xOffset - 2;
            width = s.width - startX;
        } else {
            startX = 0;
            width = xOffset - 4;
        }
        graphics.translate(startX, 0);
        graphics.setComposite(TransitionLayout.getAlphaComposite(parent));
        SeparatorPainterUtils.paintSeparator(c, graphics, width, s.height, ((JSeparator)c).getOrientation(), true, 2);
        graphics.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(c));
        int prefSize = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(prefSize, 0);
        }
        return new Dimension(0, prefSize);
    }
}

