/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.shaper.SubstanceButtonShaper;
import org.jvnet.substance.utils.ButtonBackgroundDelegate;
import org.jvnet.substance.utils.ButtonVisualStateTracker;
import org.jvnet.substance.utils.PulseTracker;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceTextUtilities;
import org.jvnet.substance.utils.border.SubstanceButtonBorder;
import org.jvnet.substance.utils.icon.GlowingIcon;

public class SubstanceToggleButtonUI
extends BasicToggleButtonUI {
    private ButtonBackgroundDelegate delegate = new ButtonBackgroundDelegate();
    protected GlowingIcon glowingIcon;
    protected PropertyChangeListener substancePropertyListener;
    protected ButtonVisualStateTracker substanceVisualStateTracker;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceToggleButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (b.getClientProperty("substancelaf.buttonborderoriginal") == null) {
            b.putClientProperty("substancelaf.buttonborderoriginal", b.getBorder());
        }
        if (b.getClientProperty("substancelaf.buttonborderoriginal") == null) {
            b.putClientProperty("substancelaf.buttonborderoriginal", b.getBorder());
        }
        this.trackGlowingIcon(b);
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(b);
        if (b.getClientProperty("substancelaf.buttonbordercomputed") == null) {
            b.setBorder(shaper.getButtonBorder(b));
        } else {
            Border currBorder = b.getBorder();
            if (!(currBorder instanceof SubstanceButtonBorder)) {
                b.setBorder(shaper.getButtonBorder(b));
            } else {
                SubstanceButtonBorder sbCurrBorder = (SubstanceButtonBorder)currBorder;
                if (shaper.getClass() != sbCurrBorder.getButtonShaperClass()) {
                    b.setBorder(shaper.getButtonBorder(b));
                }
            }
        }
        b.putClientProperty("substancelaf.buttonopacityoriginal", b.isOpaque());
        b.setOpaque(false);
        b.setRolloverEnabled(true);
        LookAndFeel.installProperty(b, "iconTextGap", SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(b)));
    }

    @Override
    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setBorder((Border)b.getClientProperty("substancelaf.buttonborderoriginal"));
        b.setOpaque((Boolean)b.getClientProperty("substancelaf.buttonopacityoriginal"));
        b.putClientProperty("substancelaf.buttonopacityoriginal", null);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return null;
    }

    @Override
    protected void installListeners(final AbstractButton b) {
        super.installListeners(b);
        this.substanceVisualStateTracker = new ButtonVisualStateTracker();
        this.substanceVisualStateTracker.installListeners(b, true);
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("icon".equals(evt.getPropertyName())) {
                    SubstanceToggleButtonUI.this.trackGlowingIcon(b);
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        this.substanceVisualStateTracker.uninstallListeners(b);
        this.substanceVisualStateTracker = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners(b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JButton jb;
        AbstractButton b = (AbstractButton)c;
        if (b instanceof JButton && PulseTracker.isPulsating(jb = (JButton)b)) {
            PulseTracker.update(jb);
        }
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        Font f = c.getFont();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g.create();
        View v = (View)c.getClientProperty("html");
        g2d.setFont(f);
        this.delegate.updateBackground(g2d, b);
        if (v != null) {
            v.paint(g2d, textRect);
        } else {
            this.paintButtonText(g2d, b, textRect, text);
        }
        if (b.getIcon() != null) {
            this.paintIcon((Graphics)g2d, b, iconRect);
        }
        if (b.isFocusPainted() && (b.hasFocus() || FadeTracker.getInstance().isTracked(c, FadeKind.FOCUS))) {
            this.paintFocus(g2d, b, viewRect, textRect, iconRect);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton button = (AbstractButton)c;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        Dimension superPref = super.getPreferredSize(button);
        if (superPref == null) {
            return null;
        }
        if (shaper == null) {
            return superPref;
        }
        return shaper.getPreferredSize(button, superPref);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return ButtonBackgroundDelegate.contains((JToggleButton)c, x, y);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!b.isFocusPainted()) {
            return;
        }
        SubstanceCoreUtilities.paintFocus(g, b, b, null, textRect, 1.0f, SubstanceSizeUtils.getFocusRingPadding(SubstanceSizeUtils.getComponentFontSize(b)));
    }

    @Override
    protected void paintIcon(Graphics g, AbstractButton b, Rectangle iconRect) {
        Graphics2D graphics = (Graphics2D)g.create();
        FadeTracker fadeTracker = FadeTracker.getInstance();
        Icon icon = SubstanceCoreUtilities.getIcon(b, null, this.glowingIcon, false);
        graphics.setComposite(TransitionLayout.getAlphaComposite((Component)b, g));
        if (fadeTracker.isTracked(b, FadeKind.ROLLOVER)) {
            ComponentState state = ComponentState.getState(b);
            if (state.isKindActive(FadeKind.ROLLOVER)) {
                SubstanceCoreUtilities.getIcon(b, null, this.glowingIcon, true).paintIcon(b, graphics, iconRect.x, iconRect.y);
                graphics.setComposite(TransitionLayout.getAlphaComposite(b, fadeTracker.getFade(b, FadeKind.ROLLOVER), g));
                icon.paintIcon(b, graphics, iconRect.x, iconRect.y);
            } else {
                icon.paintIcon(b, graphics, iconRect.x, iconRect.y);
                graphics.setComposite(TransitionLayout.getAlphaComposite(b, fadeTracker.getFade(b, FadeKind.ROLLOVER), g));
                b.getIcon().paintIcon(b, graphics, iconRect.x, iconRect.y);
            }
        } else {
            icon.paintIcon(b, graphics, iconRect.x, iconRect.y);
        }
        graphics.dispose();
    }

    protected void paintButtonText(Graphics g, AbstractButton button, Rectangle textRect, String text) {
        SubstanceTextUtilities.paintText(g, button, textRect, text, button.getDisplayedMnemonicIndex());
    }

    protected void trackGlowingIcon(AbstractButton b) {
        Icon currIcon = b.getIcon();
        if (currIcon instanceof GlowingIcon) {
            return;
        }
        if (currIcon == null) {
            return;
        }
        this.glowingIcon = new GlowingIcon(currIcon, b);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }
}

