/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.api;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.UIDefaults;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ColorSchemeTransform;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceApi;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceColorSchemeBundle;
import org.jvnet.substance.api.painter.overlay.SubstanceOverlayPainter;
import org.jvnet.substance.api.painter.overlay.TopShadowOverlayPainter;
import org.jvnet.substance.api.trait.SubstanceTrait;
import org.jvnet.substance.painter.border.SubstanceBorderPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationPainter;
import org.jvnet.substance.painter.gradient.SubstanceGradientPainter;
import org.jvnet.substance.painter.highlight.SubstanceHighlightPainter;
import org.jvnet.substance.shaper.SubstanceButtonShaper;
import org.jvnet.substance.utils.SkinUtilities;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.watermark.SubstanceWatermark;

@SubstanceApi
public abstract class SubstanceSkin
implements SubstanceTrait,
Cloneable {
    protected Map<DecorationAreaType, SubstanceColorSchemeBundle> colorSchemeBundleMap = new EnumMap<DecorationAreaType, SubstanceColorSchemeBundle>(DecorationAreaType.class);
    protected Map<DecorationAreaType, SubstanceColorScheme> backgroundColorSchemeMap = new EnumMap<DecorationAreaType, SubstanceColorScheme>(DecorationAreaType.class);
    protected Map<DecorationAreaType, List<SubstanceOverlayPainter>> overlayPaintersMap = new EnumMap<DecorationAreaType, List<SubstanceOverlayPainter>>(DecorationAreaType.class);
    protected SubstanceWatermark watermark;
    protected SubstanceButtonShaper buttonShaper;
    protected SubstanceGradientPainter gradientPainter;
    protected SubstanceBorderPainter borderPainter;
    protected SubstanceBorderPainter highlightBorderPainter;
    protected SubstanceHighlightPainter highlightPainter;
    protected SubstanceDecorationPainter decorationPainter;
    protected Set<DecorationAreaType> decoratedAreaSet = EnumSet.of(DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE);
    protected double selectedTabFadeStart = 0.1;
    protected double selectedTabFadeEnd = 0.3;
    protected SubstanceColorScheme watermarkScheme;
    Set<ComponentState> statesWithAlpha = EnumSet.noneOf(ComponentState.class);

    protected SubstanceSkin() {
    }

    public final SubstanceColorScheme getMainActiveColorScheme() {
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getActiveColorScheme();
    }

    public final SubstanceColorScheme getMainDefaultColorScheme() {
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getDefaultColorScheme();
    }

    public final SubstanceColorScheme getMainDisabledColorScheme() {
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getDisabledColorScheme();
    }

    public final SubstanceWatermark getWatermark() {
        return this.watermark;
    }

    public final SubstanceBorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    public final SubstanceBorderPainter getHighlightBorderPainter() {
        return this.highlightBorderPainter;
    }

    public final SubstanceButtonShaper getButtonShaper() {
        return this.buttonShaper;
    }

    public final SubstanceGradientPainter getGradientPainter() {
        return this.gradientPainter;
    }

    public final SubstanceHighlightPainter getHighlightPainter() {
        return this.highlightPainter;
    }

    public final SubstanceDecorationPainter getDecorationPainter() {
        return this.decorationPainter;
    }

    public void addCustomEntriesToTable(UIDefaults table) {
        if (table == null) {
            return;
        }
        SkinUtilities.addCustomEntriesToTable(table, this);
    }

    public final SubstanceColorScheme getColorScheme(Component comp, ComponentState componentState) {
        SubstanceColorScheme registered;
        DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey((Object)(decorationAreaType = SubstanceLookAndFeel.getDecorationType(comp))) && (registered = this.colorSchemeBundleMap.get((Object)decorationAreaType).getColorScheme(componentState)) != null) {
            return registered;
        }
        SubstanceColorScheme registered2 = this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getColorScheme(componentState);
        if (registered2 != null) {
            return registered2;
        }
        if (componentState == ComponentState.DEFAULT) {
            return this.getMainDefaultColorScheme();
        }
        if (componentState.getColorSchemeKind() == ComponentState.ColorSchemeKind.DISABLED) {
            return this.getMainDisabledColorScheme();
        }
        return this.getMainActiveColorScheme();
    }

    @Deprecated
    public SubstanceColorScheme getHighlightColorScheme(Component comp, ComponentState componentState) {
        return this.getColorScheme(comp, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
    }

    public final float getHighlightAlpha(Component comp, ComponentState componentState) {
        Float registered;
        DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey((Object)(decorationAreaType = SubstanceLookAndFeel.getDecorationType(comp))) && (double)(registered = Float.valueOf(this.colorSchemeBundleMap.get((Object)decorationAreaType).getHighlightAlpha(comp, componentState))).floatValue() >= 0.0) {
            return registered.floatValue();
        }
        Float registered2 = Float.valueOf(this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getHighlightAlpha(comp, componentState));
        if ((double)registered2.floatValue() >= 0.0) {
            return registered2.floatValue();
        }
        boolean isRollover = componentState.isKindActive(FadeKind.ROLLOVER);
        boolean isSelected = componentState.isKindActive(FadeKind.SELECTION);
        boolean isArmed = componentState.isKindActive(FadeKind.ARM);
        if (isRollover && isSelected) {
            return 0.9f;
        }
        if (isRollover && isArmed) {
            return 0.8f;
        }
        if (isSelected) {
            return 0.7f;
        }
        if (isArmed) {
            return 0.6f;
        }
        if (isRollover) {
            return 0.4f;
        }
        return 0.0f;
    }

    public final float getAlpha(Component comp, ComponentState componentState) {
        Float registered;
        DecorationAreaType decorationAreaType;
        if (!this.statesWithAlpha.contains((Object)componentState)) {
            return 1.0f;
        }
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey((Object)(decorationAreaType = SubstanceLookAndFeel.getDecorationType(comp))) && (double)(registered = Float.valueOf(this.colorSchemeBundleMap.get((Object)decorationAreaType).getAlpha(comp, componentState))).floatValue() >= 0.0) {
            return registered.floatValue();
        }
        Float registered2 = Float.valueOf(this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getAlpha(comp, componentState));
        if ((double)registered2.floatValue() >= 0.0) {
            return registered2.floatValue();
        }
        return 1.0f;
    }

    public void registerDecorationAreaSchemeBundle(SubstanceColorSchemeBundle bundle, SubstanceColorScheme backgroundColorScheme, DecorationAreaType ... areaTypes) {
        if (bundle == null) {
            return;
        }
        if (backgroundColorScheme == null) {
            throw new IllegalArgumentException("Cannot pass null background color scheme");
        }
        for (DecorationAreaType areaType : areaTypes) {
            this.decoratedAreaSet.add(areaType);
            this.colorSchemeBundleMap.put(areaType, bundle);
            this.backgroundColorSchemeMap.put(areaType, backgroundColorScheme);
        }
        this.statesWithAlpha.addAll(bundle.getStatesWithAlpha());
    }

    public void registerDecorationAreaSchemeBundle(SubstanceColorSchemeBundle bundle, DecorationAreaType ... areaTypes) {
        this.registerDecorationAreaSchemeBundle(bundle, bundle.getDefaultColorScheme(), areaTypes);
    }

    public void registerAsDecorationArea(SubstanceColorScheme backgroundColorScheme, DecorationAreaType ... areaTypes) {
        if (backgroundColorScheme == null) {
            throw new IllegalArgumentException("Cannot pass null background color scheme");
        }
        for (DecorationAreaType areaType : areaTypes) {
            this.decoratedAreaSet.add(areaType);
            this.backgroundColorSchemeMap.put(areaType, backgroundColorScheme);
        }
    }

    public boolean isRegisteredAsDecorationArea(DecorationAreaType decorationType) {
        return this.decoratedAreaSet.contains((Object)decorationType);
    }

    public SubstanceColorScheme getWatermarkColorScheme() {
        if (this.watermarkScheme != null) {
            return this.watermarkScheme;
        }
        return this.getMainDefaultColorScheme();
    }

    public final SubstanceColorScheme getMainActiveColorScheme(DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey((Object)decorationAreaType)) {
            return this.colorSchemeBundleMap.get((Object)decorationAreaType).getActiveColorScheme();
        }
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getActiveColorScheme();
    }

    public final SubstanceColorScheme getMainDefaultColorScheme(DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey((Object)decorationAreaType)) {
            return this.colorSchemeBundleMap.get((Object)decorationAreaType).getDefaultColorScheme();
        }
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getDefaultColorScheme();
    }

    public final SubstanceColorScheme getMainDisabledColorScheme(DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey((Object)decorationAreaType)) {
            return this.colorSchemeBundleMap.get((Object)decorationAreaType).getDisabledColorScheme();
        }
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getDisabledColorScheme();
    }

    public final double getSelectedTabFadeStart() {
        return this.selectedTabFadeStart;
    }

    public final double getSelectedTabFadeEnd() {
        return this.selectedTabFadeEnd;
    }

    public void setSelectedTabFadeEnd(double selectedTabFadeEnd) {
        if (selectedTabFadeEnd < 0.0 || selectedTabFadeEnd > 1.0) {
            throw new IllegalArgumentException("Value for selected tab fade end should be in 0.0-1.0 range");
        }
        this.selectedTabFadeEnd = selectedTabFadeEnd;
    }

    public void setSelectedTabFadeStart(double selectedTabFadeStart) {
        if (selectedTabFadeStart < 0.0 || selectedTabFadeStart > 1.0) {
            throw new IllegalArgumentException("Value for selected tab fade start should be in 0.0-1.0 range");
        }
        this.selectedTabFadeStart = selectedTabFadeStart;
    }

    public void addOverlayPainter(SubstanceOverlayPainter overlayPainter, DecorationAreaType ... areaTypes) {
        for (DecorationAreaType areaType : areaTypes) {
            if (!this.overlayPaintersMap.containsKey((Object)areaType)) {
                this.overlayPaintersMap.put(areaType, new ArrayList());
            }
            this.overlayPaintersMap.get((Object)areaType).add(overlayPainter);
        }
    }

    public void removeOverlayPainter(SubstanceOverlayPainter overlayPainter, DecorationAreaType ... areaTypes) {
        for (DecorationAreaType areaType : areaTypes) {
            if (!this.overlayPaintersMap.containsKey((Object)areaType)) {
                return;
            }
            this.overlayPaintersMap.get((Object)areaType).remove(overlayPainter);
            if (this.overlayPaintersMap.get((Object)areaType).size() != 0) continue;
            this.overlayPaintersMap.remove((Object)areaType);
        }
    }

    public List<SubstanceOverlayPainter> getOverlayPainters(DecorationAreaType decorationAreaType) {
        if (!this.overlayPaintersMap.containsKey((Object)decorationAreaType)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.overlayPaintersMap.get((Object)decorationAreaType));
    }

    @Deprecated
    public boolean isPaintingDropShadows(DecorationAreaType decorationAreaType) {
        List<SubstanceOverlayPainter> overlayPainters = this.getOverlayPainters(decorationAreaType);
        return overlayPainters.contains(TopShadowOverlayPainter.getInstance());
    }

    @Deprecated
    public void setPaintingDropShadows(DecorationAreaType decorationAreaType) {
        this.addOverlayPainter(TopShadowOverlayPainter.getInstance(), decorationAreaType);
    }

    @Deprecated
    public void unsetPaintingDropShadows(DecorationAreaType decorationAreaType) {
        this.removeOverlayPainter(TopShadowOverlayPainter.getInstance(), decorationAreaType);
    }

    public final SubstanceColorScheme getColorScheme(DecorationAreaType decorationAreaType, ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey((Object)decorationAreaType)) {
            return this.colorSchemeBundleMap.get((Object)decorationAreaType).getColorScheme(associationKind, componentState);
        }
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getColorScheme(associationKind, componentState);
    }

    public final SubstanceColorScheme getColorScheme(Component comp, ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey((Object)(decorationAreaType = SubstanceLookAndFeel.getDecorationType(comp)))) {
            return this.colorSchemeBundleMap.get((Object)decorationAreaType).getColorScheme(associationKind, componentState);
        }
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getColorScheme(associationKind, componentState);
    }

    @Deprecated
    public SubstanceColorScheme getBorderColorScheme(Component comp, ComponentState componentState) {
        DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey((Object)(decorationAreaType = SubstanceLookAndFeel.getDecorationType(comp)))) {
            return this.colorSchemeBundleMap.get((Object)decorationAreaType).getColorScheme(ColorSchemeAssociationKind.BORDER, componentState);
        }
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getColorScheme(ColorSchemeAssociationKind.BORDER, componentState);
    }

    protected Object clone() throws CloneNotSupportedException {
        final String myName = this.getDisplayName();
        SubstanceSkin clone = new SubstanceSkin(){

            @Override
            public String getDisplayName() {
                return "Clone " + myName;
            }
        };
        clone.borderPainter = this.borderPainter;
        clone.buttonShaper = this.buttonShaper;
        clone.decorationPainter = this.decorationPainter;
        clone.gradientPainter = this.gradientPainter;
        clone.highlightBorderPainter = this.highlightBorderPainter;
        clone.highlightPainter = this.highlightPainter;
        clone.watermark = this.watermark;
        clone.watermarkScheme = this.watermarkScheme;
        clone.selectedTabFadeEnd = this.selectedTabFadeEnd;
        clone.selectedTabFadeStart = this.selectedTabFadeStart;
        if (this.colorSchemeBundleMap != null) {
            clone.colorSchemeBundleMap = new EnumMap<DecorationAreaType, SubstanceColorSchemeBundle>(DecorationAreaType.class);
            for (Map.Entry<DecorationAreaType, SubstanceColorSchemeBundle> bundleEntry : this.colorSchemeBundleMap.entrySet()) {
                clone.colorSchemeBundleMap.put(bundleEntry.getKey(), (SubstanceColorSchemeBundle)bundleEntry.getValue().clone());
            }
        }
        if (this.decoratedAreaSet != null) {
            clone.decoratedAreaSet = EnumSet.copyOf(this.decoratedAreaSet);
        }
        if (this.backgroundColorSchemeMap != null) {
            clone.backgroundColorSchemeMap = new EnumMap<DecorationAreaType, SubstanceColorScheme>(this.backgroundColorSchemeMap);
        }
        if (this.overlayPaintersMap != null) {
            clone.overlayPaintersMap = new EnumMap<DecorationAreaType, List<SubstanceOverlayPainter>>(this.overlayPaintersMap);
        }
        return clone;
    }

    @SubstanceApi
    public SubstanceSkin transform(ColorSchemeTransform transform, final String name) {
        SubstanceSkin result = new SubstanceSkin(){

            @Override
            public String getDisplayName() {
                return name;
            }
        };
        result.borderPainter = this.borderPainter;
        result.buttonShaper = this.buttonShaper;
        result.decorationPainter = this.decorationPainter;
        result.gradientPainter = this.gradientPainter;
        result.highlightPainter = this.highlightPainter;
        result.highlightBorderPainter = this.highlightBorderPainter;
        result.watermark = this.watermark;
        if (this.watermarkScheme != null) {
            result.watermarkScheme = transform.transform(this.watermarkScheme);
        }
        result.selectedTabFadeEnd = this.selectedTabFadeEnd;
        result.selectedTabFadeStart = this.selectedTabFadeStart;
        if (this.colorSchemeBundleMap != null) {
            result.colorSchemeBundleMap = new EnumMap<DecorationAreaType, SubstanceColorSchemeBundle>(DecorationAreaType.class);
            for (Map.Entry<DecorationAreaType, SubstanceColorSchemeBundle> entry : this.colorSchemeBundleMap.entrySet()) {
                result.colorSchemeBundleMap.put(entry.getKey(), entry.getValue().transform(transform));
            }
        }
        if (this.decoratedAreaSet != null) {
            result.decoratedAreaSet = EnumSet.copyOf(this.decoratedAreaSet);
        }
        if (this.backgroundColorSchemeMap != null) {
            result.backgroundColorSchemeMap = new EnumMap<DecorationAreaType, SubstanceColorScheme>(DecorationAreaType.class);
            for (Map.Entry<DecorationAreaType, Object> entry : this.backgroundColorSchemeMap.entrySet()) {
                result.backgroundColorSchemeMap.put(entry.getKey(), transform.transform((SubstanceColorScheme)entry.getValue()));
            }
        }
        result.overlayPaintersMap = new EnumMap<DecorationAreaType, List<SubstanceOverlayPainter>>(this.overlayPaintersMap);
        return result;
    }

    @SubstanceApi
    public SubstanceSkin withWatermark(SubstanceWatermark watermark) {
        try {
            SubstanceSkin clone = (SubstanceSkin)this.clone();
            clone.watermark = watermark;
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public final SubstanceColorScheme getBackgroundColorScheme(DecorationAreaType decorationAreaType) {
        SubstanceColorScheme registered;
        if (this.backgroundColorSchemeMap.containsKey((Object)decorationAreaType)) {
            return this.backgroundColorSchemeMap.get((Object)decorationAreaType);
        }
        if (this.colorSchemeBundleMap.containsKey((Object)decorationAreaType) && (registered = this.colorSchemeBundleMap.get((Object)decorationAreaType).getDefaultColorScheme()) != null) {
            return registered;
        }
        return this.backgroundColorSchemeMap.get((Object)DecorationAreaType.NONE);
    }

    public boolean isValid() {
        if (!this.colorSchemeBundleMap.containsKey((Object)DecorationAreaType.NONE)) {
            return false;
        }
        if (this.getButtonShaper() == null) {
            return false;
        }
        if (this.getGradientPainter() == null) {
            return false;
        }
        if (this.getBorderPainter() == null) {
            return false;
        }
        if (this.getHighlightPainter() == null) {
            return false;
        }
        return this.getDecorationPainter() != null;
    }

    public static ColorSchemes getColorSchemes(URL url) {
        return SubstanceColorSchemeUtilities.getColorSchemes(url);
    }

    public static class ColorSchemes {
        private List<SubstanceColorScheme> schemes = new ArrayList<SubstanceColorScheme>();

        public ColorSchemes() {
        }

        public ColorSchemes(List<SubstanceColorScheme> schemes) {
            this();
            this.schemes.addAll(schemes);
        }

        public int size() {
            return this.schemes.size();
        }

        public SubstanceColorScheme get(int index) {
            return this.schemes.get(index);
        }

        public SubstanceColorScheme get(String displayName) {
            for (SubstanceColorScheme scheme : this.schemes) {
                if (!scheme.getDisplayName().equals(displayName)) continue;
                return scheme;
            }
            return null;
        }

        private int indexOf(String displayName) {
            for (int i = 0; i < this.schemes.size(); ++i) {
                SubstanceColorScheme curr = this.schemes.get(i);
                if (!curr.getDisplayName().equals(displayName)) continue;
                return i;
            }
            return -1;
        }

        public void replace(String displayName, SubstanceColorScheme scheme) {
            int index = this.indexOf(displayName);
            if (index >= 0) {
                this.schemes.remove(index);
                this.schemes.add(index, scheme);
            }
        }

        public void delete(String displayName) {
            int index = this.indexOf(displayName);
            if (index >= 0) {
                this.schemes.remove(index);
            }
        }

        public void add(SubstanceColorScheme scheme) {
            this.schemes.add(scheme);
        }

        public void switchWithPrevious(String displayName) {
            int index = this.indexOf(displayName);
            if (index >= 0) {
                SubstanceColorScheme scheme = this.schemes.remove(index);
                this.schemes.add(index - 1, scheme);
            }
        }

        public void switchWithNext(String displayName) {
            int index = this.indexOf(displayName);
            if (index >= 0) {
                SubstanceColorScheme scheme = this.schemes.remove(index);
                this.schemes.add(index + 1, scheme);
            }
        }
    }
}

