/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.utils;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.CellRendererPane;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.painter.border.SubstanceBorderPainter;
import org.jvnet.substance.painter.highlight.SubstanceHighlightPainter;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceOutlineUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class HighlightPainterUtils {
    protected static final LazyResettableHashMap<BufferedImage> smallCache = new LazyResettableHashMap("SubstanceHighlightUtils");

    public static void paintHighlight(Graphics g, CellRendererPane rendererPane, Component c, Rectangle rect, float borderAlpha, Set<SubstanceConstants.Side> openSides, ComponentState currState, ComponentState prevState, float cyclePos) {
        if (rect.width <= 0 || rect.height <= 0) {
            return;
        }
        Component compForQuerying = rendererPane != null ? rendererPane : c;
        SubstanceColorScheme currScheme = SubstanceColorSchemeUtilities.getColorScheme(compForQuerying, ColorSchemeAssociationKind.HIGHLIGHT, currState);
        SubstanceColorScheme prevScheme = cyclePos > 0.0f ? SubstanceColorSchemeUtilities.getColorScheme(compForQuerying, ColorSchemeAssociationKind.HIGHLIGHT, prevState) : currScheme;
        SubstanceColorScheme currBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(compForQuerying, ColorSchemeAssociationKind.HIGHLIGHT_BORDER, currState);
        SubstanceColorScheme prevBorderScheme = cyclePos > 0.0f ? SubstanceColorSchemeUtilities.getColorScheme(compForQuerying, ColorSchemeAssociationKind.HIGHLIGHT_BORDER, prevState) : currBorderScheme;
        HighlightPainterUtils.paintHighlight(g, rendererPane, c, rect, borderAlpha, openSides, currScheme, prevScheme, currBorderScheme, prevBorderScheme, cyclePos);
    }

    public static void paintHighlight(Graphics g, CellRendererPane rendererPane, Component c, Rectangle rect, float borderAlpha, Set<SubstanceConstants.Side> openSides, SubstanceColorScheme currScheme, SubstanceColorScheme prevScheme, SubstanceColorScheme currBorderScheme, SubstanceColorScheme prevBorderScheme, float cyclePos) {
        if (rect.width <= 0 || rect.height <= 0) {
            return;
        }
        Component compForQuerying = rendererPane != null ? rendererPane : c;
        SubstanceHighlightPainter highlightPainter = SubstanceCoreUtilities.getSkin(compForQuerying).getHighlightPainter();
        SubstanceBorderPainter highlightBorderPainter = SubstanceCoreUtilities.getHighlightBorderPainter(compForQuerying);
        Graphics2D g2d = (Graphics2D)g.create(rect.x, rect.y, rect.width, rect.height);
        if (openSides == null) {
            openSides = EnumSet.noneOf(SubstanceConstants.Side.class);
        }
        if (rect.width * rect.height < 100000) {
            String openKey = "";
            for (SubstanceConstants.Side oSide : openSides) {
                openKey = openKey + oSide.name() + "-";
            }
            HashMapKey key = SubstanceCoreUtilities.getHashKey(highlightPainter.getDisplayName(), highlightBorderPainter.getDisplayName(), rect.width, rect.height, currScheme.getDisplayName(), prevScheme.getDisplayName(), currBorderScheme.getDisplayName(), prevBorderScheme.getDisplayName(), Float.valueOf(cyclePos), Float.valueOf(borderAlpha), openKey);
            BufferedImage result = smallCache.get(key);
            if (result == null) {
                result = SubstanceCoreUtilities.getBlankImage(rect.width, rect.height);
                Graphics2D resGraphics = result.createGraphics();
                highlightPainter.paintHighlight(resGraphics, c, rect.width, rect.height, openSides, currScheme, prevScheme, cyclePos);
                HighlightPainterUtils.paintHighlightBorder(resGraphics, c, rect.width, rect.height, borderAlpha, openSides, highlightBorderPainter, currBorderScheme, prevBorderScheme, cyclePos);
                resGraphics.dispose();
                smallCache.put(key, result);
            }
            g2d.drawImage((Image)result, 0, 0, null);
            return;
        }
        highlightPainter.paintHighlight(g2d, c, rect.width, rect.height, openSides, currScheme, prevScheme, cyclePos);
        HighlightPainterUtils.paintHighlightBorder(g2d, c, rect.width, rect.height, borderAlpha, openSides, highlightBorderPainter, currBorderScheme, prevBorderScheme, cyclePos);
        g2d.dispose();
    }

    private static void paintHighlightBorder(Graphics2D graphics, Component comp, int width, int height, float borderAlpha, Set<SubstanceConstants.Side> openSides, SubstanceBorderPainter highlightBorderPainter, SubstanceColorScheme borderColorScheme1, SubstanceColorScheme borderColorScheme2, float cyclePos) {
        if (borderAlpha <= 0.0f) {
            return;
        }
        int openDelta = 3 + (int)Math.ceil(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(comp)));
        int deltaLeft = openSides.contains((Object)SubstanceConstants.Side.LEFT) ? openDelta : 0;
        int deltaRight = openSides.contains((Object)SubstanceConstants.Side.RIGHT) ? openDelta : 0;
        int deltaTop = openSides.contains((Object)SubstanceConstants.Side.TOP) ? openDelta : 0;
        int deltaBottom = openSides.contains((Object)SubstanceConstants.Side.BOTTOM) ? openDelta : 0;
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(comp)) / 2.0);
        GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, 0.0f, null, borderDelta);
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(-deltaLeft, -deltaTop);
        g2d.setComposite(TransitionLayout.getAlphaComposite(null, borderAlpha, graphics));
        int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(comp));
        GeneralPath contourInner = SubstanceOutlineUtilities.getBaseOutline(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, 0.0f, null, borderDelta + borderThickness);
        highlightBorderPainter.paintBorder(g2d, comp, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, contourInner, borderColorScheme1, borderColorScheme2, cyclePos, true);
        g2d.dispose();
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceHighlightUtils: \n");
        sb.append("\t" + smallCache.size() + " smalls");
        return sb.toString();
    }
}

