/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SchemeBaseColors;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceColorSchemeBundle;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.colorscheme.BaseDarkColorScheme;
import org.jvnet.substance.colorscheme.BaseLightColorScheme;
import org.jvnet.substance.colorscheme.BottleGreenColorScheme;
import org.jvnet.substance.colorscheme.LightGrayColorScheme;
import org.jvnet.substance.colorscheme.MetallicColorScheme;
import org.jvnet.substance.colorscheme.ShiftColorScheme;
import org.jvnet.substance.colorscheme.SunGlareColorScheme;
import org.jvnet.substance.colorscheme.SunfireRedColorScheme;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSpinnerButton;
import org.jvnet.substance.utils.SubstanceTitleButton;
import org.jvnet.substance.utils.combo.SubstanceComboBoxButton;
import org.jvnet.substance.utils.scroll.SubstanceScrollButton;

public class SubstanceColorSchemeUtilities {
    public static final SubstanceSkin METALLIC_SKIN = SubstanceColorSchemeUtilities.getMetallicSkin();
    public static final SubstanceColorScheme YELLOW = new SunGlareColorScheme();
    public static final SubstanceColorScheme ORANGE = new SunfireRedColorScheme();
    public static final SubstanceColorScheme GREEN = new BottleGreenColorScheme();

    private static SubstanceSkin getMetallicSkin() {
        SubstanceSkin res = new SubstanceSkin(){

            @Override
            public String getDisplayName() {
                return "Metallic Skin";
            }
        };
        res.registerDecorationAreaSchemeBundle(new SubstanceColorSchemeBundle(new MetallicColorScheme(), new MetallicColorScheme(), new LightGrayColorScheme()), DecorationAreaType.NONE);
        return res;
    }

    private static SubstanceColorScheme getColorizedScheme(Component component, SubstanceColorScheme scheme, boolean isEnabled) {
        ColorizationSupport support = new ColorizationSupport(){

            private boolean toTakeFromParent(Component component) {
                return component.getParent() != null && (component instanceof SubstanceScrollButton || component instanceof SubstanceSpinnerButton || component instanceof SubstanceComboBoxButton || component instanceof SubstanceTitleButton);
            }

            @Override
            public Color getBackground(Component component) {
                return this.toTakeFromParent(component) ? component.getParent().getBackground() : component.getBackground();
            }

            @Override
            public Color getForeground(Component component) {
                return this.toTakeFromParent(component) ? component.getParent().getForeground() : component.getForeground();
            }
        };
        return SubstanceColorSchemeUtilities.getColorizedScheme(component, scheme, support, isEnabled);
    }

    private static SubstanceColorScheme getColorizedScheme(Component component, SubstanceColorScheme scheme, ColorizationSupport support, boolean isEnabled) {
        if (component != null) {
            Color bk = support.getBackground(component);
            Color fg = support.getForeground(component);
            if (bk instanceof UIResource) {
                bk = null;
            }
            if (fg instanceof UIResource) {
                fg = null;
            }
            if (bk != null || fg != null) {
                double colorization = SubstanceCoreUtilities.getColorizationFactor(component);
                if (!isEnabled) {
                    colorization /= 2.0;
                }
                if (colorization > 0.0) {
                    return ShiftColorScheme.getShiftedScheme(scheme, bk, colorization, fg, colorization);
                }
            }
        }
        return scheme;
    }

    public static SubstanceColorScheme getColorScheme(final JTabbedPane jtp, final int tabIndex, ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(jtp);
        if (skin == null) {
            SubstanceCoreUtilities.traceSubstanceApiUsage(jtp, "Substance delegate used when Substance is not the current LAF");
        }
        SubstanceColorScheme nonColorized = skin.getColorScheme(jtp, associationKind, componentState);
        if (tabIndex >= 0) {
            Component component = jtp.getComponentAt(tabIndex);
            SubstanceColorScheme colorized = SubstanceColorSchemeUtilities.getColorizedScheme(component, nonColorized, new ColorizationSupport(){

                @Override
                public Color getBackground(Component component) {
                    return jtp.getBackgroundAt(tabIndex);
                }

                @Override
                public Color getForeground(Component component) {
                    return jtp.getForegroundAt(tabIndex);
                }
            }, componentState.isKindActive(FadeKind.ENABLE));
            return colorized;
        }
        return SubstanceColorSchemeUtilities.getColorizedScheme(jtp, nonColorized, componentState.isKindActive(FadeKind.ENABLE));
    }

    public static SubstanceColorScheme getColorScheme(Component component, ComponentState componentState) {
        SubstanceSkin skin;
        boolean isButtonThatIsNeverPainted;
        Component orig = component;
        boolean bl = isButtonThatIsNeverPainted = component instanceof AbstractButton && SubstanceCoreUtilities.isButtonNeverPainted((AbstractButton)component);
        if (isButtonThatIsNeverPainted || SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.DEFAULT) {
            component = component.getParent();
        }
        if ((skin = SubstanceCoreUtilities.getSkin(component)) == null) {
            SubstanceCoreUtilities.traceSubstanceApiUsage(component, "Substance delegate used when Substance is not the current LAF");
        }
        SubstanceColorScheme nonColorized = skin.getColorScheme(component, componentState);
        return SubstanceColorSchemeUtilities.getColorizedScheme(orig, nonColorized, componentState.isKindActive(FadeKind.ENABLE));
    }

    public static SubstanceColorScheme getColorScheme(Component component, ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        if (!(component instanceof JToolBar) && SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.DEFAULT) {
            component = component.getParent();
        }
        SubstanceColorScheme nonColorized = SubstanceCoreUtilities.getSkin(component).getColorScheme(component, associationKind, componentState);
        return SubstanceColorSchemeUtilities.getColorizedScheme(component, nonColorized, componentState.isKindActive(FadeKind.ENABLE));
    }

    public static float getHighlightAlpha(Component component, ComponentState componentState) {
        return SubstanceCoreUtilities.getSkin(component).getHighlightAlpha(component, componentState);
    }

    public static float getAlpha(Component component, ComponentState componentState) {
        return SubstanceCoreUtilities.getSkin(component).getAlpha(component, componentState);
    }

    public static SubstanceColorScheme getColorScheme(URL url) {
        SubstanceColorScheme substanceColorScheme;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String name = null;
            ColorSchemeKind kind = null;
            Color ultraLight = null;
            Color extraLight = null;
            Color light = null;
            Color mid = null;
            Color dark = null;
            Color ultraDark = null;
            Color foreground = null;
            SchemeBaseColors base = null;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("=");
                if (split.length != 2) {
                    throw new IllegalArgumentException("Unsupported format in line " + line);
                }
                String key = split[0];
                String value = split[1];
                if ("name".equals(key)) {
                    if (name == null) {
                        name = value;
                        continue;
                    }
                    throw new IllegalArgumentException("'name' should only be defined once");
                }
                if ("extends".equals(key)) {
                    if (base == null) {
                        base = SubstanceColorSchemeUtilities.getBaseColorScheme(new URL(url, value).openStream());
                        continue;
                    }
                    throw new IllegalArgumentException("'extends' should only be defined once");
                }
                if ("kind".equals(key)) {
                    if (kind == null) {
                        if ("Light".equals(value)) {
                            kind = ColorSchemeKind.LIGHT;
                            continue;
                        }
                        if ("Dark".equals(value)) {
                            kind = ColorSchemeKind.DARK;
                            continue;
                        }
                        throw new IllegalArgumentException("Unsupported format in line " + line);
                    }
                    throw new IllegalArgumentException("'name' should only be defined once");
                }
                if ("colorUltraLight".equals(key)) {
                    if (ultraLight == null) {
                        ultraLight = Color.decode(value);
                        continue;
                    }
                    throw new IllegalArgumentException("'ultraLight' should only be defined once");
                }
                if ("colorExtraLight".equals(key)) {
                    if (extraLight == null) {
                        extraLight = Color.decode(value);
                        continue;
                    }
                    throw new IllegalArgumentException("'extraLight' should only be defined once");
                }
                if ("colorLight".equals(key)) {
                    if (light == null) {
                        light = Color.decode(value);
                        continue;
                    }
                    throw new IllegalArgumentException("'light' should only be defined once");
                }
                if ("colorMid".equals(key)) {
                    if (mid == null) {
                        mid = Color.decode(value);
                        continue;
                    }
                    throw new IllegalArgumentException("'mid' should only be defined once");
                }
                if ("colorDark".equals(key)) {
                    if (dark == null) {
                        dark = Color.decode(value);
                        continue;
                    }
                    throw new IllegalArgumentException("'dark' should only be defined once");
                }
                if ("colorUltraDark".equals(key)) {
                    if (ultraDark == null) {
                        ultraDark = Color.decode(value);
                        continue;
                    }
                    throw new IllegalArgumentException("'ultraDark' should only be defined once");
                }
                if ("colorForeground".equals(key)) {
                    if (foreground == null) {
                        foreground = Color.decode(value);
                        continue;
                    }
                    throw new IllegalArgumentException("'foreground' should only be defined once");
                }
                throw new IllegalArgumentException("Unsupported format in line " + line);
            }
            if (base != null) {
                if (ultraLight == null) {
                    ultraLight = base.getUltraLightColor();
                }
                if (extraLight == null) {
                    extraLight = base.getExtraLightColor();
                }
                if (light == null) {
                    light = base.getLightColor();
                }
                if (mid == null) {
                    mid = base.getMidColor();
                }
                if (dark == null) {
                    dark = base.getDarkColor();
                }
                if (ultraDark == null) {
                    ultraDark = base.getUltraDarkColor();
                }
                if (foreground == null) {
                    foreground = base.getForegroundColor();
                }
            }
            if (name == null || kind == null || ultraLight == null || extraLight == null || light == null || mid == null || dark == null || ultraDark == null || foreground == null) {
                throw new IllegalArgumentException("Incomplete specification");
            }
            Color[] colors = new Color[]{ultraLight, extraLight, light, mid, dark, ultraDark, foreground};
            switch (kind) {
                case LIGHT: {
                    substanceColorScheme = SubstanceColorSchemeUtilities.getLightColorScheme(name, colors);
                    return substanceColorScheme;
                }
            }
            substanceColorScheme = SubstanceColorSchemeUtilities.getDarkColorScheme(name, colors);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {}
            }
        }
        return substanceColorScheme;
    }

    public static SchemeBaseColors getBaseColorScheme(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        Color ultraLight = null;
        Color extraLight = null;
        Color light = null;
        Color mid = null;
        Color dark = null;
        Color ultraDark = null;
        Color foreground = null;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("=");
                if (split.length != 2) {
                    throw new IllegalArgumentException("Unsupported format in line " + line);
                }
                String key = split[0];
                String value = split[1];
                if ("colorUltraLight".equals(key)) {
                    if (ultraLight == null) {
                        ultraLight = Color.decode(value);
                        continue;
                    }
                    throw new IllegalArgumentException("'ultraLight' should only be defined once");
                }
                if ("colorExtraLight".equals(key)) {
                    if (extraLight == null) {
                        extraLight = Color.decode(value);
                        continue;
                    }
                    throw new IllegalArgumentException("'extraLight' should only be defined once");
                }
                if ("colorLight".equals(key)) {
                    if (light == null) {
                        light = Color.decode(value);
                        continue;
                    }
                    throw new IllegalArgumentException("'light' should only be defined once");
                }
                if ("colorMid".equals(key)) {
                    if (mid == null) {
                        mid = Color.decode(value);
                        continue;
                    }
                    throw new IllegalArgumentException("'mid' should only be defined once");
                }
                if ("colorDark".equals(key)) {
                    if (dark == null) {
                        dark = Color.decode(value);
                        continue;
                    }
                    throw new IllegalArgumentException("'dark' should only be defined once");
                }
                if ("colorUltraDark".equals(key)) {
                    if (ultraDark == null) {
                        ultraDark = Color.decode(value);
                        continue;
                    }
                    throw new IllegalArgumentException("'ultraDark' should only be defined once");
                }
                if ("colorForeground".equals(key)) {
                    if (foreground == null) {
                        foreground = Color.decode(value);
                        continue;
                    }
                    throw new IllegalArgumentException("'foreground' should only be defined once");
                }
                throw new IllegalArgumentException("Unsupported format in line " + line);
            }
            final Color[] colors = new Color[]{ultraLight, extraLight, light, mid, dark, ultraDark, foreground};
            SchemeBaseColors schemeBaseColors = new SchemeBaseColors(){

                @Override
                public String getDisplayName() {
                    return null;
                }

                @Override
                public Color getUltraLightColor() {
                    return colors[0];
                }

                @Override
                public Color getExtraLightColor() {
                    return colors[1];
                }

                @Override
                public Color getLightColor() {
                    return colors[2];
                }

                @Override
                public Color getMidColor() {
                    return colors[3];
                }

                @Override
                public Color getDarkColor() {
                    return colors[4];
                }

                @Override
                public Color getUltraDarkColor() {
                    return colors[5];
                }

                @Override
                public Color getForegroundColor() {
                    return colors[6];
                }
            };
            return schemeBaseColors;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static SubstanceColorScheme getLightColorScheme(String name, final Color[] colors) {
        if (colors == null) {
            throw new IllegalArgumentException("Color encoding cannot be null");
        }
        if (colors.length != 7) {
            throw new IllegalArgumentException("Color encoding must have 7 components");
        }
        return new BaseLightColorScheme(name){

            @Override
            public Color getUltraLightColor() {
                return colors[0];
            }

            @Override
            public Color getExtraLightColor() {
                return colors[1];
            }

            @Override
            public Color getLightColor() {
                return colors[2];
            }

            @Override
            public Color getMidColor() {
                return colors[3];
            }

            @Override
            public Color getDarkColor() {
                return colors[4];
            }

            @Override
            public Color getUltraDarkColor() {
                return colors[5];
            }

            @Override
            public Color getForegroundColor() {
                return colors[6];
            }
        };
    }

    public static SubstanceColorScheme getDarkColorScheme(String name, final Color[] colors) {
        if (colors == null) {
            throw new IllegalArgumentException("Color encoding cannot be null");
        }
        if (colors.length != 7) {
            throw new IllegalArgumentException("Color encoding must have 7 components");
        }
        return new BaseDarkColorScheme(name){

            @Override
            public Color getUltraLightColor() {
                return colors[0];
            }

            @Override
            public Color getExtraLightColor() {
                return colors[1];
            }

            @Override
            public Color getLightColor() {
                return colors[2];
            }

            @Override
            public Color getMidColor() {
                return colors[3];
            }

            @Override
            public Color getDarkColor() {
                return colors[4];
            }

            @Override
            public Color getUltraDarkColor() {
                return colors[5];
            }

            @Override
            public Color getForegroundColor() {
                return colors[6];
            }
        };
    }

    public static SubstanceSkin.ColorSchemes getColorSchemes(URL url) {
        ArrayList<SubstanceColorScheme> schemes;
        block36: {
            schemes = new ArrayList<SubstanceColorScheme>();
            BufferedReader reader = null;
            Color ultraLight = null;
            Color extraLight = null;
            Color light = null;
            Color mid = null;
            Color dark = null;
            Color ultraDark = null;
            Color foreground = null;
            String name = null;
            ColorSchemeKind kind = null;
            boolean inColorSchemeBlock = false;
            try {
                String line;
                block37: {
                    reader = new BufferedReader(new InputStreamReader(url.openStream()));
                    while (true) {
                        if ((line = reader.readLine()) == null) {
                            break block36;
                        }
                        if (line.trim().length() == 0) continue;
                        if (line.indexOf("{") >= 0) {
                            if (inColorSchemeBlock) {
                                throw new IllegalArgumentException("Already in color scheme definition");
                            }
                            inColorSchemeBlock = true;
                            name = line.substring(0, line.indexOf("{")).trim();
                            continue;
                        }
                        if (line.indexOf("}") >= 0) {
                            if (!inColorSchemeBlock) {
                                throw new IllegalArgumentException("Not in color scheme definition");
                            }
                            inColorSchemeBlock = false;
                            if (name == null || kind == null || ultraLight == null || extraLight == null || light == null || mid == null || dark == null || ultraDark == null || foreground == null) {
                                throw new IllegalArgumentException("Incomplete specification");
                            }
                            Color[] colors = new Color[]{ultraLight, extraLight, light, mid, dark, ultraDark, foreground};
                            if (kind == ColorSchemeKind.LIGHT) {
                                schemes.add(SubstanceColorSchemeUtilities.getLightColorScheme(name, colors));
                            } else {
                                schemes.add(SubstanceColorSchemeUtilities.getDarkColorScheme(name, colors));
                            }
                            name = null;
                            kind = null;
                            ultraLight = null;
                            extraLight = null;
                            light = null;
                            mid = null;
                            dark = null;
                            ultraDark = null;
                            foreground = null;
                            continue;
                        }
                        String[] split = line.split("=");
                        if (split.length != 2) {
                            throw new IllegalArgumentException("Unsupported format in line " + line);
                        }
                        String key = split[0].trim();
                        String value = split[1].trim();
                        if ("kind".equals(key)) {
                            if (kind == null) {
                                if ("Light".equals(value)) {
                                    kind = ColorSchemeKind.LIGHT;
                                    continue;
                                }
                                if ("Dark".equals(value)) {
                                    kind = ColorSchemeKind.DARK;
                                    continue;
                                }
                                throw new IllegalArgumentException("Unsupported format in line " + line);
                            }
                            throw new IllegalArgumentException("'kind' should only be defined once");
                        }
                        if ("colorUltraLight".equals(key)) {
                            if (ultraLight == null) {
                                ultraLight = Color.decode(value);
                                continue;
                            }
                            throw new IllegalArgumentException("'ultraLight' should only be defined once");
                        }
                        if ("colorExtraLight".equals(key)) {
                            if (extraLight == null) {
                                extraLight = Color.decode(value);
                                continue;
                            }
                            throw new IllegalArgumentException("'extraLight' should only be defined once");
                        }
                        if ("colorLight".equals(key)) {
                            if (light == null) {
                                light = Color.decode(value);
                                continue;
                            }
                            throw new IllegalArgumentException("'light' should only be defined once");
                        }
                        if ("colorMid".equals(key)) {
                            if (mid == null) {
                                mid = Color.decode(value);
                                continue;
                            }
                            throw new IllegalArgumentException("'mid' should only be defined once");
                        }
                        if ("colorDark".equals(key)) {
                            if (dark == null) {
                                dark = Color.decode(value);
                                continue;
                            }
                            throw new IllegalArgumentException("'dark' should only be defined once");
                        }
                        if ("colorUltraDark".equals(key)) {
                            if (ultraDark == null) {
                                ultraDark = Color.decode(value);
                                continue;
                            }
                            throw new IllegalArgumentException("'ultraDark' should only be defined once");
                        }
                        if (!"colorForeground".equals(key)) break block37;
                        if (foreground != null) break;
                        foreground = Color.decode(value);
                    }
                    throw new IllegalArgumentException("'foreground' should only be defined once");
                }
                throw new IllegalArgumentException("Unsupported format in line " + line);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return new SubstanceSkin.ColorSchemes(schemes);
    }

    private static interface ColorizationSupport {
        public Color getBackground(Component var1);

        public Color getForeground(Component var1);
    }

    private static enum ColorSchemeKind {
        LIGHT,
        DARK;

    }
}

