/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsIconFactory;
import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.PlafOptions;
import com.pagosoft.plaf.RolloverButtonListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicMenuUI;

public class PgsMenuUI
extends BasicMenuUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new PgsMenuUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.menuItem.addMouseListener(this.createButtonListener(this.menuItem));
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new RolloverButtonListener(abstractButton);
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        Dimension dimension = jMenuItem.getSize();
        if (jMenuItem.getParent() instanceof JMenuBar) {
            if (jMenuItem.isEnabled() && (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected() || buttonModel.isRollover())) {
                if (PgsUtils.isFlat("MenuBarMenu")) {
                    if (buttonModel.isSelected()) {
                        graphics.setColor(UIManager.getColor("MenuBarMenu.selectedBackground"));
                    } else {
                        graphics.setColor(UIManager.getColor("MenuBarMenu.rolloverBackground"));
                    }
                    graphics.fillRect(0, 0, dimension.width, dimension.height);
                } else if (PlafOptions.isVistaStyle()) {
                    if (buttonModel.isRollover() && !buttonModel.isSelected()) {
                        PgsUtils.drawVistaBackground(graphics, jMenuItem, "MenuBarMenu.rolloverBackground");
                    } else {
                        PgsUtils.drawVistaBackground(graphics, jMenuItem, "MenuBarMenu.selectedBackground");
                    }
                } else if (buttonModel.isRollover() && !buttonModel.isSelected()) {
                    PgsUtils.drawGradient(graphics, jMenuItem.getWidth(), jMenuItem.getHeight(), UIManager.getColor("MenuBarMenu.rolloverBackgroundGradientStart"), UIManager.getColor("MenuBarMenu.rolloverBackgroundGradientEnd"));
                } else {
                    PgsUtils.drawGradient(graphics, jMenuItem.getWidth(), jMenuItem.getHeight(), UIManager.getColor("MenuBarMenu.selectedBackgroundGradientStart"), UIManager.getColor("MenuBarMenu.selectedBackgroundGradientEnd"));
                }
                if (buttonModel.isRollover() && !buttonModel.isSelected()) {
                    graphics.setColor(UIManager.getColor("MenuBarMenu.rolloverBorderColor"));
                    graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                } else {
                    graphics.setColor(UIManager.getColor("MenuBarMenu.selectedBorderColor"));
                    graphics.drawLine(0, 0, 0, dimension.height - 1);
                    graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
                    graphics.drawLine(0, 0, dimension.width - 1, 0);
                }
            } else if (PgsUtils.isFlat("MenuBar")) {
                graphics.setColor(UIManager.getColor("MenuBar.background"));
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            } else if (PlafOptions.isVistaStyle()) {
                PgsUtils.drawVistaBackground(graphics, jMenuItem, "MenuBar");
            } else {
                PgsUtils.drawGradient(graphics, jMenuItem.getWidth(), jMenuItem.getHeight(), UIManager.getColor("MenuBar.gradientStart"), UIManager.getColor("MenuBar.gradientEnd"));
            }
        } else {
            if (jMenuItem.getIcon() == null) {
                jMenuItem.setIcon(PgsIconFactory.getEmptyIcon());
            }
            PgsUtils.paintMenuItemBackground(graphics, jMenuItem, color, this.getPropertyPrefix());
        }
        graphics.setColor(color2);
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        PgsUtils.installAntialiasing(graphics);
        if (jMenuItem.getParent() instanceof JMenuBar) {
            jMenuItem.setForeground(UIManager.getColor("MenuBarMenu.foreground"));
            this.selectionForeground = UIManager.getColor("MenuBarMenu.foreground");
        }
        super.paintText(graphics, jMenuItem, rectangle, string);
        PgsUtils.uninstallAntialiasing(graphics);
    }
}

